/*
 * Decompiled with CFR 0.152.
 */
package com.moyun365.commonutil.asynctask;

import android.os.AsyncTask;
import android.os.Build;
import com.moyun365.commonutil.asynctask.IDoInBackground;
import com.moyun365.commonutil.asynctask.IIsViewActive;
import com.moyun365.commonutil.asynctask.IPostExecute;
import com.moyun365.commonutil.asynctask.IPreExecute;
import com.moyun365.commonutil.asynctask.IProgressUpdate;
import com.moyun365.commonutil.asynctask.IPublishProgress;

public class MoyunAsyncTask<Params, Progress, Result>
extends AsyncTask<Params, Progress, Result>
implements IPublishProgress<Progress> {
    private IPreExecute mPreExecute;
    private IProgressUpdate<Progress> mProgressUpdate;
    private IDoInBackground<Params, Progress, Result> mDoInBackground;
    private IIsViewActive mViewActive;
    private IPostExecute<Result> mPostExecute;

    protected void onPreExecute() {
        super.onPreExecute();
        if (this.mPreExecute != null) {
            this.mPreExecute.onPreExecute();
        }
    }

    @SafeVarargs
    protected final void onProgressUpdate(Progress ... values) {
        super.onProgressUpdate((Object[])values);
        if (this.mProgressUpdate != null) {
            this.mProgressUpdate.onProgressUpdate(values);
        }
    }

    public Result doInBackground(Params ... params) {
        return this.mDoInBackground == null ? null : (Result)this.mDoInBackground.doInBackground(this, params);
    }

    protected void onPostExecute(Result result) {
        super.onPostExecute(result);
        if (this.mPostExecute != null && (this.mViewActive == null || this.mViewActive.isViewActive())) {
            this.mPostExecute.onPostExecute(result);
        }
    }

    @Override
    public void showProgress(Progress ... values) {
        this.publishProgress(values);
    }

    @SafeVarargs
    public final AsyncTask<Params, Progress, Result> start(Params ... params) {
        if (Build.VERSION.SDK_INT >= 11) {
            return super.executeOnExecutor(THREAD_POOL_EXECUTOR, (Object[])params);
        }
        return super.execute((Object[])params);
    }

    public static <Params, Progress, Result> Builder<Params, Progress, Result> newBuilder() {
        return new Builder();
    }

    public static class Builder<Params, Progress, Result> {
        private final MoyunAsyncTask<Params, Progress, Result> mAsyncTask = new MoyunAsyncTask();

        public Builder<Params, Progress, Result> setPreExecute(IPreExecute preExecute) {
            ((MoyunAsyncTask)this.mAsyncTask).mPreExecute = preExecute;
            return this;
        }

        public Builder<Params, Progress, Result> setProgressUpdate(IProgressUpdate<Progress> progressUpdate) {
            ((MoyunAsyncTask)this.mAsyncTask).mProgressUpdate = progressUpdate;
            return this;
        }

        public Builder<Params, Progress, Result> setDoInBackground(IDoInBackground<Params, Progress, Result> doInBackground) {
            ((MoyunAsyncTask)this.mAsyncTask).mDoInBackground = doInBackground;
            return this;
        }

        public Builder<Params, Progress, Result> setViewActive(IIsViewActive viewActive) {
            ((MoyunAsyncTask)this.mAsyncTask).mViewActive = viewActive;
            return this;
        }

        public Builder<Params, Progress, Result> setPostExecute(IPostExecute<Result> postExecute) {
            ((MoyunAsyncTask)this.mAsyncTask).mPostExecute = postExecute;
            return this;
        }

        @SafeVarargs
        public final AsyncTask<Params, Progress, Result> start(Params ... params) {
            return this.mAsyncTask.start(params);
        }
    }
}

