/*
 * Decompiled with CFR 0.152.
 */
package com.moyun365.commonutil;

import android.app.Activity;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.view.Display;
import android.view.View;

public class ShotUtil {
    public static Bitmap shotView(View view) {
        if (null == view) {
            return null;
        }
        view.setDrawingCacheEnabled(true);
        view.buildDrawingCache();
        Bitmap bitmap = Bitmap.createBitmap((Bitmap)view.getDrawingCache());
        view.destroyDrawingCache();
        return bitmap;
    }

    public static Bitmap shotContentView(Activity activity) {
        View contentView = activity.findViewById(0x1020002);
        contentView.setDrawingCacheEnabled(true);
        contentView.buildDrawingCache();
        Bitmap bitmap = Bitmap.createBitmap((Bitmap)contentView.getDrawingCache());
        contentView.destroyDrawingCache();
        return bitmap;
    }

    public static Bitmap shotCurActivity(Activity activity) {
        View view = activity.getWindow().getDecorView();
        view.buildDrawingCache();
        Rect rect = new Rect();
        view.getWindowVisibleDisplayFrame(rect);
        int statusBarHeights = rect.top;
        Display display = activity.getWindowManager().getDefaultDisplay();
        int widths = display.getWidth();
        int heights = display.getHeight();
        view.setDrawingCacheEnabled(true);
        Bitmap bmp = Bitmap.createBitmap((Bitmap)view.getDrawingCache(), (int)0, (int)statusBarHeights, (int)widths, (int)(heights - statusBarHeights));
        view.destroyDrawingCache();
        return bmp;
    }

    public static Bitmap snapShotWithoutStatusBar(Activity activity) {
        View view = activity.getWindow().getDecorView();
        view.setDrawingCacheEnabled(true);
        view.buildDrawingCache();
        Bitmap bmp = view.getDrawingCache();
        if (bmp == null) {
            return null;
        }
        Rect frame = new Rect();
        activity.getWindow().getDecorView().getWindowVisibleDisplayFrame(frame);
        int statusBarHeight = frame.top;
        Bitmap bp = Bitmap.createBitmap((Bitmap)bmp, (int)0, (int)statusBarHeight, (int)bmp.getWidth(), (int)(bmp.getHeight() - statusBarHeight));
        view.destroyDrawingCache();
        view.setDrawingCacheEnabled(false);
        return bp;
    }
}

