/*
 * Decompiled with CFR 0.152.
 */
package com.moyun365.commonutil;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class PermissionsNavUtil {
    public static void gotoSetting(Context context) {
        context.startActivity(PermissionsNavUtil.getSettingIntent());
    }

    public static Intent getSettingIntent() {
        return new Intent("android.settings.SETTINGS").addFlags(0x10000000);
    }

    public static void gotoAppDetailSetting(Context context, String packageName) {
        context.startActivity(PermissionsNavUtil.getAppDetailsSettingsIntent(packageName));
    }

    public static Intent getAppDetailsSettingsIntent(String packageName) {
        return new Intent("android.settings.APPLICATION_DETAILS_SETTINGS").setData(Uri.parse((String)("package:" + packageName))).addFlags(0x10000000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getMiuiVersion() {
        String line;
        String propName = "ro.miui.ui.version.name";
        BufferedReader input = null;
        try {
            Process p = Runtime.getRuntime().exec("getprop " + propName);
            input = new BufferedReader(new InputStreamReader(p.getInputStream()), 1024);
            line = input.readLine();
            input.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        Log.i((String)PermissionsNavUtil.class.getSimpleName(), (String)("MiuiVersion = " + line));
        return line;
    }

    public static void gotoPermissionsSetting(Context context) {
        String sdk = Build.VERSION.SDK;
        String model = Build.MODEL;
        String release = Build.VERSION.RELEASE;
        String brand = Build.BRAND;
        if (TextUtils.equals((CharSequence)brand.toLowerCase(), (CharSequence)"redmi") || TextUtils.equals((CharSequence)brand.toLowerCase(), (CharSequence)"xiaomi")) {
            PermissionsNavUtil.gotoMiuiPermission(context);
        } else if (TextUtils.equals((CharSequence)brand.toLowerCase(), (CharSequence)"meizu")) {
            PermissionsNavUtil.gotoMeizuPermission(context);
        } else if (TextUtils.equals((CharSequence)brand.toLowerCase(), (CharSequence)"huawei") || TextUtils.equals((CharSequence)brand.toLowerCase(), (CharSequence)"honor")) {
            PermissionsNavUtil.gotoHuaweiPermission(context);
        } else {
            context.startActivity(PermissionsNavUtil.getAppDetailSettingIntent(context));
        }
    }

    private static void gotoMiuiPermission(Context context) {
        try {
            Intent localIntent = new Intent("miui.intent.action.APP_PERM_EDITOR");
            localIntent.setClassName("com.miui.securitycenter", "com.miui.permcenter.permissions.PermissionsEditorActivity");
            localIntent.putExtra("extra_pkgname", context.getPackageName());
            context.startActivity(localIntent);
        }
        catch (Exception e) {
            try {
                Intent localIntent = new Intent("miui.intent.action.APP_PERM_EDITOR");
                localIntent.setClassName("com.miui.securitycenter", "com.miui.permcenter.permissions.AppPermissionsEditorActivity");
                localIntent.putExtra("extra_pkgname", context.getPackageName());
                context.startActivity(localIntent);
            }
            catch (Exception e1) {
                context.startActivity(PermissionsNavUtil.getAppDetailSettingIntent(context));
            }
        }
    }

    private static void gotoMeizuPermission(Context context) {
        try {
            Intent intent = new Intent("com.meizu.safe.security.SHOW_APPSEC");
            intent.addCategory("android.intent.category.DEFAULT");
            intent.putExtra("packageName", "com.moyun365.commonutil");
            context.startActivity(intent);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.startActivity(PermissionsNavUtil.getAppDetailSettingIntent(context));
        }
    }

    private static void gotoHuaweiPermission(Context context) {
        try {
            Intent intent = new Intent();
            intent.setFlags(0x10000000);
            ComponentName comp = new ComponentName("com.huawei.systemmanager", "com.huawei.permissionmanager.ui.MainActivity");
            intent.setComponent(comp);
            context.startActivity(intent);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.startActivity(PermissionsNavUtil.getAppDetailSettingIntent(context));
        }
    }

    private static Intent getAppDetailSettingIntent(Context context) {
        Intent localIntent = new Intent();
        localIntent.addFlags(0x10000000);
        if (Build.VERSION.SDK_INT >= 9) {
            localIntent.setAction("android.settings.APPLICATION_DETAILS_SETTINGS");
            localIntent.setData(Uri.fromParts((String)"package", (String)context.getPackageName(), null));
        } else if (Build.VERSION.SDK_INT <= 8) {
            localIntent.setAction("android.intent.action.VIEW");
            localIntent.setClassName("com.android.settings", "com.android.settings.InstalledAppDetails");
            localIntent.putExtra("com.android.settings.ApplicationPkgName", context.getPackageName());
        }
        return localIntent;
    }
}

