/*
 * Decompiled with CFR 0.152.
 */
package com.moyun365.commonutil.easypermissions.helper;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.StyleRes;
import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.Fragment;
import com.moyun365.commonutil.easypermissions.helper.ActivityPermissionHelper;
import com.moyun365.commonutil.easypermissions.helper.AppCompatActivityPermissionsHelper;
import com.moyun365.commonutil.easypermissions.helper.LowApiPermissionsHelper;
import com.moyun365.commonutil.easypermissions.helper.SupportFragmentPermissionHelper;
import java.util.List;

public abstract class PermissionHelper<T> {
    private T mHost;

    @NonNull
    public static PermissionHelper<? extends Activity> newInstance(Activity host) {
        if (Build.VERSION.SDK_INT < 23) {
            return new LowApiPermissionsHelper<Activity>(host);
        }
        if (host instanceof AppCompatActivity) {
            return new AppCompatActivityPermissionsHelper((AppCompatActivity)host);
        }
        return new ActivityPermissionHelper(host);
    }

    @NonNull
    public static PermissionHelper<Fragment> newInstance(Fragment host) {
        if (Build.VERSION.SDK_INT < 23) {
            return new LowApiPermissionsHelper<Fragment>(host);
        }
        return new SupportFragmentPermissionHelper(host);
    }

    public PermissionHelper(@NonNull T host) {
        this.mHost = host;
    }

    private boolean shouldShowRationale(String ... perms) {
        for (String perm : perms) {
            if (!this.shouldShowRequestPermissionRationale(perm)) continue;
            return true;
        }
        return false;
    }

    public void requestPermissions(@NonNull String rationale, @NonNull String positiveButton, @NonNull String negativeButton, @StyleRes int theme, int requestCode, String ... perms) {
        if (this.shouldShowRationale(perms)) {
            this.showRequestPermissionRationale(rationale, positiveButton, negativeButton, theme, requestCode, perms);
        } else {
            this.directRequestPermissions(requestCode, perms);
        }
    }

    public boolean somePermissionPermanentlyDenied(@NonNull List<String> perms) {
        for (String deniedPermission : perms) {
            if (!this.permissionPermanentlyDenied(deniedPermission)) continue;
            return true;
        }
        return false;
    }

    public boolean permissionPermanentlyDenied(@NonNull String perms) {
        return !this.shouldShowRequestPermissionRationale(perms);
    }

    public boolean somePermissionDenied(String ... perms) {
        return this.shouldShowRationale(perms);
    }

    @NonNull
    public T getHost() {
        return this.mHost;
    }

    public abstract void directRequestPermissions(int var1, String ... var2);

    public abstract boolean shouldShowRequestPermissionRationale(@NonNull String var1);

    public abstract void showRequestPermissionRationale(@NonNull String var1, @NonNull String var2, @NonNull String var3, @StyleRes int var4, int var5, String ... var6);

    public abstract Context getContext();
}

