/*
 * Decompiled with CFR 0.152.
 */
package com.moyun365.commonutil;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.os.Build;
import android.provider.Settings;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.UUID;

public class SysUtil {
    public static void showInputKeyBoard(Activity context, EditText editText) {
        InputMethodManager inputManager = (InputMethodManager)editText.getContext().getSystemService("input_method");
        inputManager.showSoftInput((View)editText, 0);
    }

    public static void hideInput(Activity context) {
        if (context != null && context.getCurrentFocus() != null && context.getCurrentFocus().getWindowToken() != null) {
            ((InputMethodManager)context.getSystemService("input_method")).hideSoftInputFromWindow(context.getCurrentFocus().getWindowToken(), 2);
        }
    }

    public static int getVerCode(Context context) {
        int verCode = -1;
        try {
            verCode = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionCode;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return verCode;
    }

    public static String getVerName(Context context) {
        PackageInfo packageInfo = null;
        try {
            packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 128);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return packageInfo.versionName;
    }

    public static String getPackageName(Context context) {
        PackageInfo packageInfo = null;
        try {
            packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 128);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return packageInfo.packageName;
    }

    public static String getMac() {
        String macSerial = null;
        String str = "";
        try {
            Process pp = Runtime.getRuntime().exec("cat/sys/class/net/wlan0/address ");
            InputStreamReader ir = new InputStreamReader(pp.getInputStream());
            LineNumberReader input = new LineNumberReader(ir);
            while (null != str) {
                str = input.readLine();
                if (str == null) continue;
                macSerial = str.trim();
                break;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return macSerial;
    }

    public static String getUniqueId(Context context) {
        String deviceId = "0";
        try {
            String serial = null;
            String m_szDevIDShort = "35" + Build.BOARD.length() % 10 + Build.BRAND.length() % 10 + Build.CPU_ABI.length() % 10 + Build.DEVICE.length() % 10 + Build.DISPLAY.length() % 10 + Build.HOST.length() % 10 + Build.ID.length() % 10 + Build.MANUFACTURER.length() % 10 + Build.MODEL.length() % 10 + Build.PRODUCT.length() % 10 + Build.TAGS.length() % 10 + Build.TYPE.length() % 10 + Build.USER.length() % 10;
            try {
                serial = Settings.System.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
            }
            catch (Exception exception) {
                serial = "serial";
            }
            deviceId = new UUID(m_szDevIDShort.hashCode(), serial.hashCode()).toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return deviceId.toUpperCase().replace(" ", "");
    }

    public static int getAndroidSDKInt() {
        int currentapiVersion = Build.VERSION.SDK_INT;
        return currentapiVersion;
    }

    public static String getAndroidRelease() {
        return Build.VERSION.RELEASE;
    }

    public static String getPhoneBrand() {
        return Build.BRAND;
    }

    public static String getPhoneModel() {
        return Build.MODEL;
    }

    public static String getAndroidVersionNumber() {
        return Build.VERSION.RELEASE;
    }
}

