/*
 * Decompiled with CFR 0.152.
 */
package com.moyun365.commonutil;

import android.content.Context;
import android.content.SharedPreferences;
import com.moyun365.commonutil.log.LogUtil;

public class SharePreUtil {
    private static final String SHARE_PRE_NAME = "share_pre_data";
    static SharedPreferences preferences;

    private static synchronized SharedPreferences getInstance(Context context) {
        if (null == context) {
            LogUtil.e("jife", "====SharedPreferences==getInstance==context is null==");
        }
        if (null == preferences && null != context) {
            preferences = context.getSharedPreferences(SHARE_PRE_NAME, 0);
        }
        return preferences;
    }

    public static void saveStringDataToSharePreference(Context context, String key, String value) {
        SharedPreferences preferences = SharePreUtil.getInstance(context);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putString(key, value);
        editor.commit();
    }

    public static void saveLongDataToSharePreference(Context context, String key, long value) {
        SharedPreferences preferences = SharePreUtil.getInstance(context);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putLong(key, value);
        editor.commit();
    }

    public static void saveBooleanDataToSharePreference(Context context, String key, boolean value) {
        SharedPreferences preferences = SharePreUtil.getInstance(context);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putBoolean(key, value);
        editor.commit();
    }

    public static void saveIntDataToSharePreference(Context context, String key, int value) {
        SharedPreferences preferences = SharePreUtil.getInstance(context);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putInt(key, value);
        editor.commit();
    }

    public static String getStringDataByKey(Context context, String key) {
        SharedPreferences preferences = SharePreUtil.getInstance(context);
        return preferences.getString(key, "");
    }

    public static String getStringDataByKey(Context context, String key, String defaultValue) {
        SharedPreferences preferences = SharePreUtil.getInstance(context);
        return preferences.getString(key, defaultValue);
    }

    public static int getIntDataByKey(Context context, String key, int defaultValue) {
        SharedPreferences preferences = SharePreUtil.getInstance(context);
        return preferences.getInt(key, defaultValue);
    }

    public static boolean getBooleanDataByKey(Context context, String key, boolean defaultValue) {
        SharedPreferences preferences = SharePreUtil.getInstance(context);
        return preferences.getBoolean(key, defaultValue);
    }

    public static long getLongDataByKey(Context context, String key, long defaultValue) {
        SharedPreferences preferences = SharePreUtil.getInstance(context);
        return preferences.getLong(key, defaultValue);
    }

    public static void clearAll(Context context) {
        SharedPreferences preferences = SharePreUtil.getInstance(context);
        preferences.edit().clear().commit();
    }
}

