/*
 * Decompiled with CFR 0.152.
 */
package io.github.jhipster.service;

import io.github.jhipster.service.filter.Filter;
import io.github.jhipster.service.filter.RangeFilter;
import io.github.jhipster.service.filter.StringFilter;
import java.io.Serializable;
import java.util.Collection;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.SetAttribute;
import javax.persistence.metamodel.SingularAttribute;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public abstract class QueryService<ENTITY> {
    protected <X> Specification<ENTITY> buildSpecification(Filter<X> filter, SingularAttribute<? super ENTITY, X> field) {
        if (filter.getEquals() != null) {
            return this.equalsSpecification(field, filter.getEquals());
        }
        if (filter.getIn() != null) {
            return this.valueIn(field, filter.getIn());
        }
        if (filter.getSpecified() != null) {
            return this.byFieldSpecified(field, (boolean)filter.getSpecified());
        }
        return null;
    }

    protected Specification<ENTITY> buildStringSpecification(StringFilter filter, SingularAttribute<? super ENTITY, String> field) {
        if (filter.getEquals() != null) {
            return this.equalsSpecification(field, filter.getEquals());
        }
        if (filter.getIn() != null) {
            return this.valueIn(field, filter.getIn());
        }
        if (filter.getContains() != null) {
            return this.likeUpperSpecification(field, filter.getContains());
        }
        if (filter.getSpecified() != null) {
            return this.byFieldSpecified(field, (boolean)filter.getSpecified());
        }
        return null;
    }

    protected <X extends Comparable<? super X>> Specification<ENTITY> buildRangeSpecification(RangeFilter<X> filter, SingularAttribute<? super ENTITY, X> field) {
        if (filter.getEquals() != null) {
            return this.equalsSpecification(field, filter.getEquals());
        }
        if (filter.getIn() != null) {
            return this.valueIn(field, filter.getIn());
        }
        Specification result = Specification.where(null);
        if (filter.getSpecified() != null) {
            result = result.and(this.byFieldSpecified(field, (boolean)filter.getSpecified()));
        }
        if (filter.getGreaterThan() != null) {
            result = result.and(this.greaterThan(field, filter.getGreaterThan()));
        }
        if (filter.getGreaterOrEqualThan() != null) {
            result = result.and(this.greaterThanOrEqualTo(field, filter.getGreaterOrEqualThan()));
        }
        if (filter.getLessThan() != null) {
            result = result.and(this.lessThan(field, filter.getLessThan()));
        }
        if (filter.getLessOrEqualThan() != null) {
            result = result.and(this.lessThanOrEqualTo(field, filter.getLessOrEqualThan()));
        }
        return result;
    }

    protected <OTHER, X> Specification<ENTITY> buildReferringEntitySpecification(Filter<X> filter, SingularAttribute<? super ENTITY, OTHER> reference, SingularAttribute<OTHER, X> valueField) {
        if (filter.getEquals() != null) {
            return this.equalsSpecification(reference, valueField, filter.getEquals());
        }
        if (filter.getIn() != null) {
            return this.valueIn(reference, valueField, filter.getIn());
        }
        if (filter.getSpecified() != null) {
            return this.byFieldSpecified(reference, (boolean)filter.getSpecified());
        }
        return null;
    }

    protected <OTHER, X extends Comparable<? super X>> Specification<ENTITY> buildReferringEntitySpecification(RangeFilter<X> filter, SingularAttribute<? super ENTITY, OTHER> reference, SingularAttribute<OTHER, X> valueField) {
        if (filter.getEquals() != null) {
            return this.equalsSpecification(reference, valueField, filter.getEquals());
        }
        if (filter.getIn() != null) {
            return this.valueIn(reference, valueField, filter.getIn());
        }
        Specification result = Specification.where(null);
        if (filter.getSpecified() != null) {
            result = result.and(this.byFieldSpecified(reference, (boolean)filter.getSpecified()));
        }
        if (filter.getGreaterThan() != null) {
            result = result.and(this.greaterThan(reference, valueField, filter.getGreaterThan()));
        }
        if (filter.getGreaterOrEqualThan() != null) {
            result = result.and(this.greaterThanOrEqualTo(reference, valueField, filter.getGreaterOrEqualThan()));
        }
        if (filter.getLessThan() != null) {
            result = result.and(this.lessThan(reference, valueField, filter.getLessThan()));
        }
        if (filter.getLessOrEqualThan() != null) {
            result = result.and(this.lessThanOrEqualTo(reference, valueField, filter.getLessOrEqualThan()));
        }
        return result;
    }

    protected <OTHER, X> Specification<ENTITY> buildReferringEntitySpecification(Filter<X> filter, SetAttribute<ENTITY, OTHER> reference, SingularAttribute<OTHER, X> valueField) {
        if (filter.getEquals() != null) {
            return this.equalsSetSpecification(reference, valueField, filter.getEquals());
        }
        if (filter.getSpecified() != null) {
            return this.byFieldSpecified(reference, (boolean)filter.getSpecified());
        }
        return null;
    }

    protected <OTHER, X extends Comparable<? super X>> Specification<ENTITY> buildReferringEntitySpecification(RangeFilter<X> filter, SetAttribute<ENTITY, OTHER> reference, SingularAttribute<OTHER, X> valueField) {
        if (filter.getEquals() != null) {
            return this.equalsSetSpecification(reference, valueField, filter.getEquals());
        }
        if (filter.getIn() != null) {
            return this.valueIn(reference, valueField, filter.getIn());
        }
        Specification result = Specification.where(null);
        if (filter.getSpecified() != null) {
            result = result.and(this.byFieldSpecified(reference, (boolean)filter.getSpecified()));
        }
        if (filter.getGreaterThan() != null) {
            result = result.and(this.greaterThan((SetAttribute<? super ENTITY, OTHER>)reference, valueField, filter.getGreaterThan()));
        }
        if (filter.getGreaterOrEqualThan() != null) {
            result = result.and(this.greaterThanOrEqualTo((SetAttribute<? super ENTITY, OTHER>)reference, valueField, filter.getGreaterOrEqualThan()));
        }
        if (filter.getLessThan() != null) {
            result = result.and(this.lessThan((SetAttribute<? super ENTITY, OTHER>)reference, valueField, filter.getLessThan()));
        }
        if (filter.getLessOrEqualThan() != null) {
            result = result.and(this.lessThanOrEqualTo((SetAttribute<? super ENTITY, OTHER>)reference, valueField, filter.getLessOrEqualThan()));
        }
        return result;
    }

    protected <X> Specification<ENTITY> equalsSpecification(SingularAttribute<? super ENTITY, X> field, X value) {
        return (Specification & Serializable)(root, query, builder) -> builder.equal((Expression)root.get(field), value);
    }

    protected <OTHER, X> Specification<ENTITY> equalsSpecification(SingularAttribute<? super ENTITY, OTHER> reference, SingularAttribute<OTHER, X> idField, X value) {
        return (Specification & Serializable)(root, query, builder) -> builder.equal((Expression)root.get(reference).get(idField), value);
    }

    protected <OTHER, X> Specification<ENTITY> equalsSetSpecification(SetAttribute<? super ENTITY, OTHER> reference, SingularAttribute<OTHER, X> idField, X value) {
        return (Specification & Serializable)(root, query, builder) -> builder.equal((Expression)root.join(reference).get(idField), value);
    }

    protected Specification<ENTITY> likeUpperSpecification(SingularAttribute<? super ENTITY, String> field, String value) {
        return (Specification & Serializable)(root, query, builder) -> builder.like(builder.upper((Expression)root.get(field)), this.wrapLikeQuery(value));
    }

    protected <X> Specification<ENTITY> byFieldSpecified(SingularAttribute<? super ENTITY, X> field, boolean specified) {
        return specified ? (Specification & Serializable)(root, query, builder) -> builder.isNotNull((Expression)root.get(field)) : (Specification & Serializable)(root, query, builder) -> builder.isNull((Expression)root.get(field));
    }

    protected <X> Specification<ENTITY> byFieldSpecified(SetAttribute<ENTITY, X> field, boolean specified) {
        return specified ? (Specification & Serializable)(root, query, builder) -> builder.isNotEmpty(root.get((PluralAttribute)field)) : (Specification & Serializable)(root, query, builder) -> builder.isEmpty(root.get((PluralAttribute)field));
    }

    protected <X> Specification<ENTITY> valueIn(SingularAttribute<? super ENTITY, X> field, Collection<X> values) {
        return (Specification & Serializable)(root, query, builder) -> {
            CriteriaBuilder.In in = builder.in((Expression)root.get(field));
            for (Object value : values) {
                in = in.value(value);
            }
            return in;
        };
    }

    protected <OTHER, X> Specification<ENTITY> valueIn(SingularAttribute<? super ENTITY, OTHER> reference, SingularAttribute<OTHER, X> valueField, Collection<X> values) {
        return (Specification & Serializable)(root, query, builder) -> {
            CriteriaBuilder.In in = builder.in((Expression)root.get(reference).get(valueField));
            for (Object value : values) {
                in = in.value(value);
            }
            return in;
        };
    }

    protected <X extends Comparable<? super X>> Specification<ENTITY> greaterThanOrEqualTo(SingularAttribute<? super ENTITY, X> field, X value) {
        return (Specification & Serializable)(root, query, builder) -> builder.greaterThanOrEqualTo((Expression)root.get(field), value);
    }

    protected <X extends Comparable<? super X>> Specification<ENTITY> greaterThan(SingularAttribute<? super ENTITY, X> field, X value) {
        return (Specification & Serializable)(root, query, builder) -> builder.greaterThan((Expression)root.get(field), value);
    }

    protected <X extends Comparable<? super X>> Specification<ENTITY> lessThanOrEqualTo(SingularAttribute<? super ENTITY, X> field, X value) {
        return (Specification & Serializable)(root, query, builder) -> builder.lessThanOrEqualTo((Expression)root.get(field), value);
    }

    protected <X extends Comparable<? super X>> Specification<ENTITY> lessThan(SingularAttribute<? super ENTITY, X> field, X value) {
        return (Specification & Serializable)(root, query, builder) -> builder.lessThan((Expression)root.get(field), value);
    }

    protected String wrapLikeQuery(String txt) {
        return "%" + txt.toUpperCase() + '%';
    }

    protected <OTHER, X> Specification<ENTITY> valueIn(SetAttribute<? super ENTITY, OTHER> reference, SingularAttribute<OTHER, X> valueField, Collection<X> values) {
        return (Specification & Serializable)(root, query, builder) -> {
            CriteriaBuilder.In in = builder.in((Expression)root.join(reference).get(valueField));
            for (Object value : values) {
                in = in.value(value);
            }
            return in;
        };
    }

    protected <OTHER, X extends Comparable<? super X>> Specification<ENTITY> greaterThan(SingularAttribute<? super ENTITY, OTHER> reference, SingularAttribute<OTHER, X> valueField, X value) {
        return (Specification & Serializable)(root, query, builder) -> builder.greaterThan((Expression)root.get(reference).get(valueField), value);
    }

    protected <OTHER, X extends Comparable<? super X>> Specification<ENTITY> greaterThan(SetAttribute<? super ENTITY, OTHER> reference, SingularAttribute<OTHER, X> valueField, X value) {
        return (Specification & Serializable)(root, query, builder) -> builder.greaterThan((Expression)root.join(reference).get(valueField), value);
    }

    protected <OTHER, X extends Comparable<? super X>> Specification<ENTITY> greaterThanOrEqualTo(SingularAttribute<? super ENTITY, OTHER> reference, SingularAttribute<OTHER, X> valueField, X value) {
        return (Specification & Serializable)(root, query, builder) -> builder.greaterThanOrEqualTo((Expression)root.get(reference).get(valueField), value);
    }

    protected <OTHER, X extends Comparable<? super X>> Specification<ENTITY> greaterThanOrEqualTo(SetAttribute<? super ENTITY, OTHER> reference, SingularAttribute<OTHER, X> valueField, X value) {
        return (Specification & Serializable)(root, query, builder) -> builder.greaterThanOrEqualTo((Expression)root.join(reference).get(valueField), value);
    }

    protected <OTHER, X extends Comparable<? super X>> Specification<ENTITY> lessThan(SingularAttribute<? super ENTITY, OTHER> reference, SingularAttribute<OTHER, X> valueField, X value) {
        return (Specification & Serializable)(root, query, builder) -> builder.lessThan((Expression)root.get(reference).get(valueField), value);
    }

    protected <OTHER, X extends Comparable<? super X>> Specification<ENTITY> lessThan(SetAttribute<? super ENTITY, OTHER> reference, SingularAttribute<OTHER, X> valueField, X value) {
        return (Specification & Serializable)(root, query, builder) -> builder.lessThan((Expression)root.join(reference).get(valueField), value);
    }

    protected <OTHER, X extends Comparable<? super X>> Specification<ENTITY> lessThanOrEqualTo(SingularAttribute<? super ENTITY, OTHER> reference, SingularAttribute<OTHER, X> valueField, X value) {
        return (Specification & Serializable)(root, query, builder) -> builder.lessThanOrEqualTo((Expression)root.get(reference).get(valueField), value);
    }

    protected <OTHER, X extends Comparable<? super X>> Specification<ENTITY> lessThanOrEqualTo(SetAttribute<? super ENTITY, OTHER> reference, SingularAttribute<OTHER, X> valueField, X value) {
        return (Specification & Serializable)(root, query, builder) -> builder.lessThanOrEqualTo((Expression)root.join(reference).get(valueField), value);
    }
}

