/*
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 * Copyright (c) 2023-2025 Jeremy Long. All Rights Reserved.
 */
package io.github.jeremylong.openvulnerability.client.ghsa;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

import java.io.Serializable;
import java.util.Objects;

/**
 * The Common Vulnerability Scoring System
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonPropertyOrder({"cvssV3", "cvssV4"})
public class CVSSSeverities implements Serializable {

    private static final long serialVersionUID = -6425427956203326377L;

    @JsonProperty("cvssV3")
    private CVSS cvssV3;

    @JsonProperty("cvssV4")
    private CVSS cvssV4;

    public CVSS getCvssV3() {
        return cvssV3;
    }

    public CVSS getCvssV4() {
        return cvssV4;
    }

    @Override
    public String toString() {
        return "CVSSSeverities{" + "cvssV3=" + cvssV3 + ", cvssV4=" + cvssV4 + '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o)
            return true;
        if (o == null || getClass() != o.getClass())
            return false;
        CVSSSeverities cvss = (CVSSSeverities) o;
        return cvssV3.equals(cvss.cvssV3) && cvssV4.equals(cvss.cvssV4);
    }

    @Override
    public int hashCode() {
        return Objects.hash(cvssV3, cvssV4);
    }
}
