/*
 * Decompiled with CFR 0.152.
 */
package io.github.jeremylong.openvulnerability.client.nvd;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"version", "vectorString", "accessVector", "accessComplexity", "authentication", "confidentialityImpact", "integrityImpact", "availabilityImpact", "baseScore", "exploitability", "remediationLevel", "reportConfidence", "temporalScore", "collateralDamagePotential", "targetDistribution", "confidentialityRequirement", "integrityRequirement", "availabilityRequirement", "environmentalScore"})
public class CvssV2Data
implements Serializable {
    private static final long serialVersionUID = -3488320581980953116L;
    @JsonProperty(value="version")
    @JsonPropertyDescription(value="CVSS Version")
    private Version version;
    @JsonProperty(value="vectorString")
    private String vectorString;
    @JsonProperty(value="accessVector")
    private AccessVectorType accessVector;
    @JsonProperty(value="accessComplexity")
    private AccessComplexityType accessComplexity;
    @JsonProperty(value="authentication")
    private AuthenticationType authentication;
    @JsonProperty(value="confidentialityImpact")
    private CiaType confidentialityImpact;
    @JsonProperty(value="integrityImpact")
    private CiaType integrityImpact;
    @JsonProperty(value="availabilityImpact")
    private CiaType availabilityImpact;
    @JsonProperty(value="baseScore")
    private Double baseScore;
    @JsonProperty(value="baseSeverity")
    private String baseSeverity;
    @JsonProperty(value="exploitability")
    private ExploitabilityType exploitability;
    @JsonProperty(value="remediationLevel")
    private RemediationLevelType remediationLevel;
    @JsonProperty(value="reportConfidence")
    private ReportConfidenceType reportConfidence;
    @JsonProperty(value="temporalScore")
    private Double temporalScore;
    @JsonProperty(value="collateralDamagePotential")
    private CollateralDamagePotentialType collateralDamagePotential;
    @JsonProperty(value="targetDistribution")
    private TargetDistributionType targetDistribution;
    @JsonProperty(value="confidentialityRequirement")
    private CiaRequirementType confidentialityRequirement;
    @JsonProperty(value="integrityRequirement")
    private CiaRequirementType integrityRequirement;
    @JsonProperty(value="availabilityRequirement")
    private CiaRequirementType availabilityRequirement;
    @JsonProperty(value="environmentalScore")
    private Double environmentalScore;

    public CvssV2Data() {
    }

    public CvssV2Data(String version, String vectorString, AccessVectorType accessVector, AccessComplexityType accessComplexity, AuthenticationType authentication, CiaType confidentialityImpact, CiaType integrityImpact, CiaType availabilityImpact, Double baseScore, String baseSeverity, ExploitabilityType exploitability, RemediationLevelType remediationLevel, ReportConfidenceType reportConfidence, Double temporalScore, CollateralDamagePotentialType collateralDamagePotential, TargetDistributionType targetDistribution, CiaRequirementType confidentialityRequirement, CiaRequirementType integrityRequirement, CiaRequirementType availabilityRequirement, Double environmentalScore) {
        this.version = Version.fromValue(version);
        this.vectorString = vectorString;
        this.accessVector = accessVector;
        this.accessComplexity = accessComplexity;
        this.authentication = authentication;
        this.confidentialityImpact = confidentialityImpact;
        this.integrityImpact = integrityImpact;
        this.availabilityImpact = availabilityImpact;
        this.baseScore = baseScore;
        this.baseSeverity = baseSeverity;
        this.exploitability = exploitability;
        this.remediationLevel = remediationLevel;
        this.reportConfidence = reportConfidence;
        this.temporalScore = temporalScore;
        this.collateralDamagePotential = collateralDamagePotential;
        this.targetDistribution = targetDistribution;
        this.confidentialityRequirement = confidentialityRequirement;
        this.integrityRequirement = integrityRequirement;
        this.availabilityRequirement = availabilityRequirement;
        this.environmentalScore = environmentalScore;
    }

    @JsonProperty(value="version")
    public Version getVersion() {
        return this.version;
    }

    @JsonProperty(value="vectorString")
    public String getVectorString() {
        return this.vectorString;
    }

    @JsonProperty(value="accessVector")
    public AccessVectorType getAccessVector() {
        return this.accessVector;
    }

    @JsonProperty(value="accessComplexity")
    public AccessComplexityType getAccessComplexity() {
        return this.accessComplexity;
    }

    @JsonProperty(value="authentication")
    public AuthenticationType getAuthentication() {
        return this.authentication;
    }

    @JsonProperty(value="confidentialityImpact")
    public CiaType getConfidentialityImpact() {
        return this.confidentialityImpact;
    }

    @JsonProperty(value="integrityImpact")
    public CiaType getIntegrityImpact() {
        return this.integrityImpact;
    }

    @JsonProperty(value="availabilityImpact")
    public CiaType getAvailabilityImpact() {
        return this.availabilityImpact;
    }

    @JsonProperty(value="baseScore")
    public Double getBaseScore() {
        return this.baseScore;
    }

    @JsonProperty(value="baseSeverity")
    public String getBaseSeverity() {
        return this.baseSeverity;
    }

    @JsonProperty(value="exploitability")
    public ExploitabilityType getExploitability() {
        return this.exploitability;
    }

    @JsonProperty(value="remediationLevel")
    public RemediationLevelType getRemediationLevel() {
        return this.remediationLevel;
    }

    @JsonProperty(value="reportConfidence")
    public ReportConfidenceType getReportConfidence() {
        return this.reportConfidence;
    }

    @JsonProperty(value="temporalScore")
    public Double getTemporalScore() {
        return this.temporalScore;
    }

    @JsonProperty(value="collateralDamagePotential")
    public CollateralDamagePotentialType getCollateralDamagePotential() {
        return this.collateralDamagePotential;
    }

    @JsonProperty(value="targetDistribution")
    public TargetDistributionType getTargetDistribution() {
        return this.targetDistribution;
    }

    @JsonProperty(value="confidentialityRequirement")
    public CiaRequirementType getConfidentialityRequirement() {
        return this.confidentialityRequirement;
    }

    @JsonProperty(value="integrityRequirement")
    public CiaRequirementType getIntegrityRequirement() {
        return this.integrityRequirement;
    }

    @JsonProperty(value="availabilityRequirement")
    public CiaRequirementType getAvailabilityRequirement() {
        return this.availabilityRequirement;
    }

    @JsonProperty(value="environmentalScore")
    public Double getEnvironmentalScore() {
        return this.environmentalScore;
    }

    public String toString() {
        return "CvssV2Data{version=" + (Object)((Object)this.version) + ", vectorString='" + this.vectorString + '\'' + ", accessVector=" + (Object)((Object)this.accessVector) + ", accessComplexity=" + (Object)((Object)this.accessComplexity) + ", authentication=" + (Object)((Object)this.authentication) + ", confidentialityImpact=" + (Object)((Object)this.confidentialityImpact) + ", integrityImpact=" + (Object)((Object)this.integrityImpact) + ", availabilityImpact=" + (Object)((Object)this.availabilityImpact) + ", baseScore=" + this.baseScore + ", exploitability=" + (Object)((Object)this.exploitability) + ", remediationLevel=" + (Object)((Object)this.remediationLevel) + ", reportConfidence=" + (Object)((Object)this.reportConfidence) + ", temporalScore=" + this.temporalScore + ", collateralDamagePotential=" + (Object)((Object)this.collateralDamagePotential) + ", targetDistribution=" + (Object)((Object)this.targetDistribution) + ", confidentialityRequirement=" + (Object)((Object)this.confidentialityRequirement) + ", integrityRequirement=" + (Object)((Object)this.integrityRequirement) + ", availabilityRequirement=" + (Object)((Object)this.availabilityRequirement) + ", environmentalScore=" + this.environmentalScore + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CvssV2Data cvssV2Data = (CvssV2Data)o;
        return this.version == cvssV2Data.version && Objects.equals(this.vectorString, cvssV2Data.vectorString) && this.accessVector == cvssV2Data.accessVector && this.accessComplexity == cvssV2Data.accessComplexity && this.authentication == cvssV2Data.authentication && this.confidentialityImpact == cvssV2Data.confidentialityImpact && this.integrityImpact == cvssV2Data.integrityImpact && this.availabilityImpact == cvssV2Data.availabilityImpact && Objects.equals(this.baseScore, cvssV2Data.baseScore) && this.exploitability == cvssV2Data.exploitability && this.remediationLevel == cvssV2Data.remediationLevel && this.reportConfidence == cvssV2Data.reportConfidence && Objects.equals(this.temporalScore, cvssV2Data.temporalScore) && this.collateralDamagePotential == cvssV2Data.collateralDamagePotential && this.targetDistribution == cvssV2Data.targetDistribution && this.confidentialityRequirement == cvssV2Data.confidentialityRequirement && this.integrityRequirement == cvssV2Data.integrityRequirement && this.availabilityRequirement == cvssV2Data.availabilityRequirement && Objects.equals(this.environmentalScore, cvssV2Data.environmentalScore);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.version, this.vectorString, this.accessVector, this.accessComplexity, this.authentication, this.confidentialityImpact, this.integrityImpact, this.availabilityImpact, this.baseScore, this.exploitability, this.remediationLevel, this.reportConfidence, this.temporalScore, this.collateralDamagePotential, this.targetDistribution, this.confidentialityRequirement, this.integrityRequirement, this.availabilityRequirement, this.environmentalScore});
    }

    public static enum Version {
        _2_0("2.0");

        private static final Map<String, Version> CONSTANTS;
        private final String value;

        private Version(String value) {
            this.value = value;
        }

        @JsonCreator
        public static Version fromValue(String value) {
            Version constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, Version>();
            for (Version c : Version.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum TargetDistributionType {
        NONE("NONE"),
        LOW("LOW"),
        MEDIUM("MEDIUM"),
        HIGH("HIGH"),
        NOT_DEFINED("NOT_DEFINED");

        private static final Map<String, TargetDistributionType> CONSTANTS;
        private final String value;

        private TargetDistributionType(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TargetDistributionType fromValue(String value) {
            TargetDistributionType constant;
            if (value != null && value.length() == 1) {
                if ("x".equalsIgnoreCase(value)) {
                    return NOT_DEFINED;
                }
                for (TargetDistributionType t : TargetDistributionType.values()) {
                    if (!t.value.startsWith(value)) continue;
                    return t;
                }
            }
            if ((constant = CONSTANTS.get(value)) == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, TargetDistributionType>();
            for (TargetDistributionType c : TargetDistributionType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum ReportConfidenceType {
        UNCONFIRMED("UNCONFIRMED"),
        UNCORROBORATED("UNCORROBORATED"),
        CONFIRMED("CONFIRMED"),
        NOT_DEFINED("NOT_DEFINED");

        private static final Map<String, ReportConfidenceType> CONSTANTS;
        private final String value;

        private ReportConfidenceType(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ReportConfidenceType fromValue(String value) {
            ReportConfidenceType constant;
            if (value != null && value.length() == 1) {
                for (ReportConfidenceType t : ReportConfidenceType.values()) {
                    if (!t.value.startsWith(value)) continue;
                    return t;
                }
            }
            if ((constant = CONSTANTS.get(value)) == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, ReportConfidenceType>();
            for (ReportConfidenceType c : ReportConfidenceType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum RemediationLevelType {
        OFFICIAL_FIX("OFFICIAL_FIX"),
        TEMPORARY_FIX("TEMPORARY_FIX"),
        WORKAROUND("WORKAROUND"),
        UNAVAILABLE("UNAVAILABLE"),
        NOT_DEFINED("NOT_DEFINED");

        private static final Map<String, RemediationLevelType> CONSTANTS;
        private final String value;

        private RemediationLevelType(String value) {
            this.value = value;
        }

        @JsonCreator
        public static RemediationLevelType fromValue(String value) {
            RemediationLevelType constant;
            if (value != null && value.length() == 1) {
                if ("x".equalsIgnoreCase(value)) {
                    return NOT_DEFINED;
                }
                for (RemediationLevelType t : RemediationLevelType.values()) {
                    if (!t.value.startsWith(value)) continue;
                    return t;
                }
            }
            if ((constant = CONSTANTS.get(value)) == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, RemediationLevelType>();
            for (RemediationLevelType c : RemediationLevelType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum ExploitabilityType {
        UNPROVEN("UNPROVEN"),
        PROOF_OF_CONCEPT("PROOF_OF_CONCEPT"),
        FUNCTIONAL("FUNCTIONAL"),
        HIGH("HIGH"),
        NOT_DEFINED("NOT_DEFINED");

        private static final Map<String, ExploitabilityType> CONSTANTS;
        private final String value;

        private ExploitabilityType(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ExploitabilityType fromValue(String value) {
            ExploitabilityType constant;
            if (value != null && value.length() == 1) {
                for (ExploitabilityType t : ExploitabilityType.values()) {
                    if (!t.value.startsWith(value)) continue;
                    return t;
                }
            }
            if ((constant = CONSTANTS.get(value)) == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, ExploitabilityType>();
            for (ExploitabilityType c : ExploitabilityType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum CollateralDamagePotentialType {
        NONE("NONE"),
        LOW("LOW"),
        LOW_MEDIUM("LOW_MEDIUM"),
        MEDIUM_HIGH("MEDIUM_HIGH"),
        HIGH("HIGH"),
        NOT_DEFINED("NOT_DEFINED");

        private static final Map<String, CollateralDamagePotentialType> CONSTANTS;
        private final String value;

        private CollateralDamagePotentialType(String value) {
            this.value = value;
        }

        @JsonCreator
        public static CollateralDamagePotentialType fromValue(String value) {
            CollateralDamagePotentialType constant;
            if (value != null && value.length() == 1) {
                for (CollateralDamagePotentialType t : CollateralDamagePotentialType.values()) {
                    if (!t.value.startsWith(value)) continue;
                    return t;
                }
            }
            if ((constant = CONSTANTS.get(value)) == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, CollateralDamagePotentialType>();
            for (CollateralDamagePotentialType c : CollateralDamagePotentialType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum CiaType {
        NONE("NONE"),
        PARTIAL("PARTIAL"),
        COMPLETE("COMPLETE");

        private static final Map<String, CiaType> CONSTANTS;
        private final String value;

        private CiaType(String value) {
            this.value = value;
        }

        @JsonCreator
        public static CiaType fromValue(String value) {
            CiaType constant;
            if (value != null && value.length() == 1) {
                for (CiaType t : CiaType.values()) {
                    if (!t.value.startsWith(value)) continue;
                    return t;
                }
            }
            if ((constant = CONSTANTS.get(value)) == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, CiaType>();
            for (CiaType c : CiaType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum CiaRequirementType {
        LOW("LOW"),
        MEDIUM("MEDIUM"),
        HIGH("HIGH"),
        NOT_DEFINED("NOT_DEFINED");

        private static final Map<String, CiaRequirementType> CONSTANTS;
        private final String value;

        private CiaRequirementType(String value) {
            this.value = value;
        }

        @JsonCreator
        public static CiaRequirementType fromValue(String value) {
            CiaRequirementType constant;
            if (value != null && value.length() == 1) {
                if ("x".equalsIgnoreCase(value)) {
                    return NOT_DEFINED;
                }
                for (CiaRequirementType t : CiaRequirementType.values()) {
                    if (!t.value.startsWith(value)) continue;
                    return t;
                }
            }
            if ((constant = CONSTANTS.get(value)) == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, CiaRequirementType>();
            for (CiaRequirementType c : CiaRequirementType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum AuthenticationType {
        MULTIPLE("MULTIPLE"),
        SINGLE("SINGLE"),
        NONE("NONE");

        private static final Map<String, AuthenticationType> CONSTANTS;
        private final String value;

        private AuthenticationType(String value) {
            this.value = value;
        }

        @JsonCreator
        public static AuthenticationType fromValue(String value) {
            AuthenticationType constant;
            if (value != null && value.length() == 1) {
                for (AuthenticationType t : AuthenticationType.values()) {
                    if (!t.value.startsWith(value)) continue;
                    return t;
                }
            }
            if ((constant = CONSTANTS.get(value)) == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, AuthenticationType>();
            for (AuthenticationType c : AuthenticationType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum AccessVectorType {
        NETWORK("NETWORK"),
        ADJACENT_NETWORK("ADJACENT_NETWORK"),
        LOCAL("LOCAL");

        private static final Map<String, AccessVectorType> CONSTANTS;
        private final String value;

        private AccessVectorType(String value) {
            this.value = value;
        }

        @JsonCreator
        public static AccessVectorType fromValue(String value) {
            AccessVectorType constant;
            if (value != null && value.length() == 1) {
                for (AccessVectorType t : AccessVectorType.values()) {
                    if (!t.value.startsWith(value)) continue;
                    return t;
                }
            }
            if ((constant = CONSTANTS.get(value)) == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, AccessVectorType>();
            for (AccessVectorType c : AccessVectorType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum AccessComplexityType {
        HIGH("HIGH"),
        MEDIUM("MEDIUM"),
        LOW("LOW");

        private static final Map<String, AccessComplexityType> CONSTANTS;
        private final String value;

        private AccessComplexityType(String value) {
            this.value = value;
        }

        @JsonCreator
        public static AccessComplexityType fromValue(String value) {
            AccessComplexityType constant;
            if (value != null && value.length() == 1) {
                for (AccessComplexityType t : AccessComplexityType.values()) {
                    if (!t.value.startsWith(value)) continue;
                    return t;
                }
            }
            if ((constant = CONSTANTS.get(value)) == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, AccessComplexityType>();
            for (AccessComplexityType c : AccessComplexityType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

