/*
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 * Copyright (c) 2023 Jeremy Long. All Rights Reserved.
 */
package io.github.jeremylong.openvulnerability.client.nvd;

import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;

public class RateLimitedCall {
    private final SimpleHttpResponse response;
    private final int clientIndex;
    private final int startIndex;

    @SuppressFBWarnings(value = {"EI_EXPOSE_REP",
            "EI_EXPOSE_REP2"}, justification = "I prefer to suppress these FindBugs warnings")
    public RateLimitedCall(SimpleHttpResponse response, int clientIndex, int startIndex) {
        this.response = response;
        this.clientIndex = clientIndex;
        this.startIndex = startIndex;
    }

    @SuppressFBWarnings(value = {"EI_EXPOSE_REP",
            "EI_EXPOSE_REP2"}, justification = "I prefer to suppress these FindBugs warnings")
    public SimpleHttpResponse getResponse() {
        return response;
    }

    public int getClientIndex() {
        return clientIndex;
    }

    public int getStartIndex() {
        return startIndex;
    }
}
