/*
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 * Copyright (c) 2023 Jeremy Long. All Rights Reserved.
 */
package io.github.jeremylong.openvulnerability.client;

import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.routing.SystemDefaultRoutePlanner;

import java.net.ProxySelector;
import java.util.function.Supplier;

/**
 * Supplier for {@link CloseableHttpClient}s.
 * <p>
 * May be used to provide customized HTTP clients to data source clients.
 * <p>
 * Closing of the supplied {@link CloseableHttpClient} instances is a responsibility of the caller.
 */
@FunctionalInterface
public interface HttpClientSupplier extends Supplier<CloseableHttpClient> {

    static HttpClientSupplier getDefault() {
        return () -> {
            SystemDefaultRoutePlanner planner = new SystemDefaultRoutePlanner(ProxySelector.getDefault());
            return HttpClientBuilder.create().setRoutePlanner(planner).useSystemProperties().build();
        };
    }

}
