/*
 * Decompiled with CFR 0.152.
 */
package kafka.context;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import kafka.context.PasswordHelper;

public class ContextHelper {
    static Path baseDir() throws IOException {
        String homePath = System.getProperty("user.home");
        if (homePath.isBlank()) {
            throw new IllegalStateException("Can't find user's home. ${HOME} is empty");
        }
        Path home = Path.of(homePath, ".kafka");
        if (!Files.isDirectory(home, new LinkOption[0])) {
            System.err.println("Kafka Context directory doesn't exist, creating one...");
            Files.createDirectories(home, new FileAttribute[0]);
        }
        return home;
    }

    static PasswordHelper passwordHelper() {
        try {
            Path saltPath = ContextHelper.baseDir().resolve(".salt");
            if (!Files.exists(saltPath, new LinkOption[0])) {
                String salt = PasswordHelper.generateKey();
                Files.writeString(saltPath, (CharSequence)salt, new OpenOption[0]);
                return new PasswordHelper(salt);
            }
            String salt = Files.readString(saltPath);
            return new PasswordHelper(salt);
        }
        catch (IOException e) {
            throw new IllegalStateException("Password helper not loading", e);
        }
    }
}

