/*
 * Decompiled with CFR 0.152.
 */
package com.jccdex.rpc.core.types.known.tx.result;

import com.jccdex.core.encoding.common.B16;
import com.jccdex.rpc.core.coretypes.AccountID;
import com.jccdex.rpc.core.coretypes.STArray;
import com.jccdex.rpc.core.coretypes.STObject;
import com.jccdex.rpc.core.coretypes.hash.Hash;
import com.jccdex.rpc.core.coretypes.hash.Hash256;
import com.jccdex.rpc.core.coretypes.hash.Index;
import com.jccdex.rpc.core.coretypes.uint.UInt32;
import com.jccdex.rpc.core.fields.Field;
import com.jccdex.rpc.core.serialized.SerializedType;
import com.jccdex.rpc.core.serialized.enums.EngineResult;
import com.jccdex.rpc.core.serialized.enums.LedgerEntryType;
import com.jccdex.rpc.core.serialized.enums.TransactionType;
import com.jccdex.rpc.core.types.known.tx.Transaction;
import com.jccdex.rpc.core.types.known.tx.result.TransactionMeta;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class TransactionResult
implements Comparable<TransactionResult> {
    public EngineResult engineResult;
    public UInt32 ledgerIndex;
    public Hash256 hash;
    @Deprecated
    public Hash256 ledgerHash;
    @Deprecated
    public boolean validated;
    public Transaction txn;
    public TransactionMeta meta;
    @Deprecated
    public JSONObject message;

    public TransactionResult(long ledgerIndex, Hash256 hash, Transaction txn, TransactionMeta meta) {
        this.ledgerIndex = new UInt32(ledgerIndex);
        this.hash = hash;
        this.txn = txn;
        this.meta = meta;
        this.engineResult = meta.engineResult();
        this.validated = true;
    }

    public boolean isPayment() {
        return this.transactionType() == TransactionType.Payment;
    }

    public TransactionType transactionType() {
        return this.txn.transactionType();
    }

    public AccountID createdAccount() {
        AccountID destination = null;
        Hash destinationIndex = null;
        if (this.transactionType() == TransactionType.Payment && this.meta.has(Field.AffectedNodes)) {
            STArray affected = this.meta.get(STArray.AffectedNodes);
            for (STObject node : affected) {
                STObject created;
                if (!node.has(STObject.CreatedNode) || STObject.ledgerEntryType(created = node.get(STObject.CreatedNode)) != LedgerEntryType.AccountRoot) continue;
                if (destination == null) {
                    destination = this.txn.get(AccountID.Destination);
                    destinationIndex = Index.accountRoot(destination);
                }
                if (!destinationIndex.equals(created.get(Hash256.LedgerIndex))) continue;
                return destination;
            }
        }
        return null;
    }

    public Map<AccountID, STObject> modifiedRoots() {
        HashMap<AccountID, STObject> accounts = null;
        if (this.meta.has(Field.AffectedNodes)) {
            accounts = new HashMap<AccountID, STObject>();
            STArray affected = this.meta.get(STArray.AffectedNodes);
            for (STObject node : affected) {
                STObject finalFields;
                if (!node.has(Field.ModifiedNode) || STObject.ledgerEntryType(node = node.get(STObject.ModifiedNode)) != LedgerEntryType.AccountRoot || (finalFields = node.get(STObject.FinalFields)) == null) continue;
                AccountID key = finalFields.get(AccountID.Account);
                accounts.put(key, node);
            }
        }
        return accounts;
    }

    public AccountID initiatingAccount() {
        return this.txn.get(AccountID.Account);
    }

    @Override
    public int compareTo(TransactionResult o2) {
        TransactionResult o1 = this;
        int i = o1.ledgerIndex.compareTo(o2.ledgerIndex);
        if (i != 0) {
            return i;
        }
        return o1.meta.transactionIndex().compareTo(o2.meta.transactionIndex());
    }

    public static TransactionResult fromJSON(JSONObject json) {
        Transaction txn;
        boolean binary;
        String txKey;
        String metaKey;
        String string = metaKey = json.has("meta") ? "meta" : "metaData";
        String string2 = json.has("transaction") ? "transaction" : (json.has("tx") ? "tx" : (txKey = json.has("tx_blob") ? "tx_blob" : null));
        if (txKey == null && !json.has("TransactionType")) {
            throw new RuntimeException("This json isn't a transaction " + json);
        }
        boolean bl = binary = txKey != null && json.get(txKey) instanceof String;
        if (txKey == null) {
            txn = (Transaction)STObject.fromJSONObject(json);
        } else {
            txn = (Transaction)TransactionResult.parseObject(json, txKey, binary);
            if (json.has("hash")) {
                txn.put(Hash256.hash, Hash256.fromHex(json.getString("hash")));
            } else if (binary) {
                byte[] decode = B16.decode((String)json.getString(txKey));
                txn.put(Hash256.hash, Index.transactionID(decode));
            }
        }
        TransactionMeta meta = (TransactionMeta)TransactionResult.parseObject(json, metaKey, binary);
        long ledger_index = json.optLong("ledger_index", 0L);
        if (ledger_index == 0L && !binary) {
            ledger_index = json.getJSONObject(txKey).getLong("ledger_index");
        }
        TransactionResult tr = new TransactionResult(ledger_index, txn.get(Hash256.hash), txn, meta);
        if (json.has("ledger_hash")) {
            tr.ledgerHash = Hash256.fromHex(json.getString("ledger_hash"));
        }
        return tr;
    }

    private static STObject parseObject(JSONObject json, String key, boolean binary) {
        if (binary) {
            return (STObject)STObject.translate.fromHex(json.getString(key));
        }
        JSONObject tx_json = json.getJSONObject(key);
        return STObject.translate.fromJSONObject(tx_json);
    }

    public TransactionResult(JSONObject json, Source resultMessageSource) {
        this.message = json;
        if (resultMessageSource == Source.transaction_subscription_notification) {
            this.engineResult = EngineResult.valueOf(json.getString("engine_result"));
            this.validated = json.getBoolean("validated");
            this.ledgerHash = (Hash256)Hash256.translate.fromString(json.getString("ledger_hash"));
            this.ledgerIndex = new UInt32(json.getLong("ledger_index"));
            if (json.has("transaction")) {
                this.txn = (Transaction)STObject.fromJSONObject(json.getJSONObject("transaction"));
                this.hash = this.txn.get(Hash256.hash);
            }
            if (json.has("meta")) {
                this.meta = (TransactionMeta)STObject.fromJSONObject(json.getJSONObject("meta"));
            }
        } else if (resultMessageSource == Source.ledger_transactions_expanded_with_ledger_index_injected) {
            this.validated = true;
            this.meta = (TransactionMeta)STObject.translate.fromJSONObject(json.getJSONObject("metaData"));
            this.txn = (Transaction)STObject.translate.fromJSONObject(json);
            this.hash = this.txn.get(Hash256.hash);
            this.engineResult = this.meta.engineResult();
            this.ledgerIndex = new UInt32(json.getLong("ledger_index"));
            this.ledgerHash = null;
        } else if (resultMessageSource == Source.request_tx_result) {
            this.validated = json.optBoolean("validated", false);
            if (this.validated && !json.has("meta")) {
                throw new IllegalStateException("It's validated, why doesn't it have meta??");
            }
            if (this.validated) {
                this.meta = (TransactionMeta)STObject.fromJSONObject(json.getJSONObject("meta"));
                this.engineResult = this.meta.engineResult();
                this.txn = (Transaction)STObject.fromJSONObject(json);
                this.hash = this.txn.get(Hash256.hash);
                this.ledgerHash = null;
                this.ledgerIndex = new UInt32(json.getLong("ledger_index"));
            }
        } else if (resultMessageSource == Source.request_account_tx) {
            this.validated = json.optBoolean("validated", false);
            if (this.validated && !json.has("meta")) {
                throw new IllegalStateException("It's validated, why doesn't it have meta??");
            }
            if (this.validated) {
                JSONObject tx = json.getJSONObject("tx");
                this.meta = (TransactionMeta)STObject.fromJSONObject(json.getJSONObject("meta"));
                this.engineResult = this.meta.engineResult();
                this.txn = (Transaction)STObject.fromJSONObject(tx);
                this.hash = this.txn.get(Hash256.hash);
                this.ledgerIndex = new UInt32(tx.getLong("ledger_index"));
                this.ledgerHash = null;
            }
        } else if (resultMessageSource == Source.request_account_tx_binary || resultMessageSource == Source.request_tx_binary) {
            this.validated = json.optBoolean("validated", false);
            if (this.validated && !json.has("meta")) {
                throw new IllegalStateException("It's validated, why doesn't it have meta??");
            }
            if (this.validated) {
                boolean account_tx = resultMessageSource == Source.request_account_tx_binary;
                String tx = json.getString(account_tx ? "tx_blob" : "tx");
                byte[] decodedTx = B16.decode((String)tx);
                this.meta = (TransactionMeta)STObject.translate.fromHex(json.getString("meta"));
                this.txn = (Transaction)STObject.translate.fromBytes(decodedTx);
                this.hash = account_tx ? Index.transactionID(decodedTx) : (Hash256)Hash256.translate.fromHex(json.getString("hash"));
                this.txn.put(Field.hash, (SerializedType)this.hash);
                this.engineResult = this.meta.engineResult();
                this.ledgerIndex = new UInt32(json.getLong("ledger_index"));
                this.ledgerHash = null;
            }
        }
    }

    public String toString() {
        if (this.message != null) {
            return this.message.toString();
        }
        JSONObject object = this.toJSON();
        return object.toString();
    }

    public JSONObject toJSON() {
        JSONObject o = new JSONObject();
        o.put("tx", this.txn.toJSON());
        o.put("meta", this.meta.toJSON());
        o.put("ledger_index", (Object)this.ledgerIndex);
        o.put("hash", (Object)this.hash.toHex());
        return o;
    }

    public TransactionResult copy() {
        TransactionMeta metaCopy = (TransactionMeta)STObject.translate.fromBytes(this.meta.toBytes());
        Transaction txnCopy = (Transaction)STObject.translate.fromBytes(this.txn.toBytes());
        return new TransactionResult(this.ledgerIndex.longValue(), this.hash, txnCopy, metaCopy);
    }

    public JSONObject toJSONBinary() {
        JSONObject o = new JSONObject();
        o.put("hash", (Object)this.hash.toHex());
        o.put("meta", (Object)this.meta.toHex());
        o.put("tx", (Object)this.txn.toHex());
        o.put("ledger_index", (Object)this.ledgerIndex);
        return o;
    }

    public static enum Source {
        request_tx_result,
        request_account_tx,
        request_account_tx_binary,
        request_tx_binary,
        ledger_transactions_expanded_with_ledger_index_injected,
        transaction_subscription_notification;

    }
}

