/*
 * Decompiled with CFR 0.152.
 */
package com.jccdex.rpc.core.types.shamap;

import com.jccdex.rpc.core.coretypes.hash.Hash256;
import com.jccdex.rpc.core.types.shamap.ShaMapInner;
import com.jccdex.rpc.core.types.shamap.ShaMapLeaf;
import com.jccdex.rpc.core.types.shamap.ShaMapNode;
import java.util.ArrayDeque;
import java.util.Iterator;

public class PathToIndex {
    public Hash256 index;
    public ShaMapLeaf leaf;
    private ArrayDeque<ShaMapInner> inners;
    private ShaMapInner[] dirtied;
    private boolean matched = false;

    public boolean hasLeaf() {
        return this.leaf != null;
    }

    public boolean leafMatchedIndex() {
        return this.matched;
    }

    public boolean copyLeafOnUpdate() {
        return this.leaf.version != (long)this.dirtied[0].version;
    }

    int size() {
        return this.inners.size();
    }

    public ShaMapInner top() {
        return this.dirtied[this.dirtied.length - 1];
    }

    public ShaMapInner dirtyOrCopyInners() {
        if (this.maybeCopyOnWrite()) {
            int ix = 0;
            this.dirtied = new ShaMapInner[this.inners.size()];
            Iterator<ShaMapInner> it = this.inners.descendingIterator();
            ShaMapInner top = it.next();
            this.dirtied[ix++] = top;
            top.invalidate();
            while (it.hasNext()) {
                boolean doCopies;
                ShaMapInner next = it.next();
                boolean bl = doCopies = next.version != top.version;
                if (doCopies) {
                    ShaMapInner copy = next.copy(top.version);
                    copy.invalidate();
                    top.setBranch(this.index, (ShaMapNode)copy);
                    next = copy;
                } else {
                    next.invalidate();
                }
                top = next;
                this.dirtied[ix++] = top;
            }
            return top;
        }
        this.copyInnersToDirtiedArray();
        return this.inners.peekFirst();
    }

    public boolean hasMatchedLeaf() {
        return this.hasLeaf() && this.leafMatchedIndex();
    }

    public void collapseOnlyLeafChildInners() {
        assert (this.dirtied != null);
        ShaMapLeaf onlyChild = null;
        for (int i = this.dirtied.length - 1; i >= 0; --i) {
            ShaMapInner next = this.dirtied[i];
            if (onlyChild != null) {
                next.setLeaf(onlyChild);
            }
            if ((onlyChild = next.onlyChildLeaf()) == null) break;
        }
    }

    private void copyInnersToDirtiedArray() {
        int ix = 0;
        this.dirtied = new ShaMapInner[this.inners.size()];
        Iterator<ShaMapInner> descending = this.inners.descendingIterator();
        while (descending.hasNext()) {
            ShaMapInner next = descending.next();
            this.dirtied[ix++] = next;
            next.invalidate();
        }
    }

    private boolean maybeCopyOnWrite() {
        return this.inners.peekLast().doCoW;
    }

    public PathToIndex(ShaMapInner root, Hash256 index) {
        this.index = index;
        this.makeStack(root, index);
    }

    private void makeStack(ShaMapInner root, Hash256 index) {
        this.inners = new ArrayDeque();
        ShaMapInner top = root;
        while (true) {
            this.inners.push(top);
            ShaMapNode existing = top.getBranch(index);
            if (existing == null) break;
            if (existing.isLeaf()) {
                this.leaf = existing.asLeaf();
                this.matched = this.leaf.index.equals(index);
                break;
            }
            if (!existing.isInner()) continue;
            top = existing.asInner();
        }
    }

    public ShaMapLeaf invalidatedPossiblyCopiedLeafForUpdating() {
        assert (this.matched);
        if (this.dirtied == null) {
            this.dirtyOrCopyInners();
        }
        ShaMapLeaf theLeaf = this.leaf;
        if (this.copyLeafOnUpdate()) {
            theLeaf = this.leaf.copy();
            this.top().setLeaf(theLeaf);
        }
        theLeaf.invalidate();
        return theLeaf;
    }
}

