/*
 * Decompiled with CFR 0.152.
 */
package com.jccdex.rpc.core.coretypes.hash;

import com.jccdex.core.serialized.BytesSink;
import com.jccdex.rpc.core.coretypes.hash.Hash256;
import com.jccdex.rpc.core.coretypes.hash.prefixes.Prefix;
import com.jccdex.rpc.core.serialized.SerializedType;
import java.security.MessageDigest;

public class HalfSha512
implements BytesSink {
    MessageDigest messageDigest;

    public HalfSha512() {
        try {
            this.messageDigest = MessageDigest.getInstance("SHA-512", "BC");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static HalfSha512 prefixed256(Prefix bytes) {
        HalfSha512 halfSha512 = new HalfSha512();
        halfSha512.update(bytes);
        return halfSha512;
    }

    public void update(byte[] bytes) {
        this.messageDigest.update(bytes);
    }

    public void update(Hash256 hash) {
        this.messageDigest.update(hash.bytes());
    }

    public MessageDigest digest() {
        return this.messageDigest;
    }

    public Hash256 finish() {
        byte[] half = this.digestBytes();
        return new Hash256(half);
    }

    private byte[] digestBytes() {
        byte[] digest = this.messageDigest.digest();
        byte[] half = new byte[32];
        System.arraycopy(digest, 0, half, 0, 32);
        return half;
    }

    private Hash256 makeHash(byte[] half) {
        return new Hash256(half);
    }

    public void add(byte aByte) {
        this.messageDigest.update(aByte);
    }

    public void add(byte[] bytes) {
        this.messageDigest.update(bytes);
    }

    public void update(Prefix prefix) {
        this.messageDigest.update(prefix.bytes());
    }

    public HalfSha512 add(SerializedType st) {
        st.toBytesSink(this);
        return this;
    }
}

