/*
 * Decompiled with CFR 0.152.
 */
package com.jccdex.rpc.core.types.shamap;

import com.jccdex.rpc.core.coretypes.hash.Hash256;
import com.jccdex.rpc.core.types.shamap.LeafWalker;
import com.jccdex.rpc.core.types.shamap.ShaMap;
import com.jccdex.rpc.core.types.shamap.ShaMapInner;
import com.jccdex.rpc.core.types.shamap.ShaMapLeaf;
import com.jccdex.rpc.core.types.shamap.ShaMapNode;
import java.util.TreeSet;

public class ShaMapDiff {
    public ShaMap one;
    public ShaMap two;
    public TreeSet<Hash256> modified = new TreeSet();
    public TreeSet<Hash256> deleted = new TreeSet();
    public TreeSet<Hash256> added = new TreeSet();

    public ShaMapDiff(ShaMap one, ShaMap two) {
        this.one = one;
        this.two = two;
    }

    public void find() {
        this.one.hash();
        this.two.hash();
        this.compare(this.one, this.two);
    }

    public ShaMapDiff inverted() {
        ShaMapDiff shaMapDiff = new ShaMapDiff(this.two, this.one);
        shaMapDiff.added = this.deleted;
        shaMapDiff.modified = this.modified;
        shaMapDiff.deleted = this.added;
        return shaMapDiff;
    }

    public void apply(ShaMap sa) {
        for (Hash256 mod : this.modified) {
            boolean modded = sa.updateItem(mod, this.two.getItem(mod).copy());
            if (!modded) {
                throw new AssertionError();
            }
        }
        for (Hash256 add : this.added) {
            boolean added = sa.addItem(add, this.two.getItem(add).copy());
            if (!added) {
                throw new AssertionError();
            }
        }
        for (Hash256 delete : this.deleted) {
            boolean removed = sa.removeLeaf(delete);
            if (!removed) {
                throw new AssertionError();
            }
        }
    }

    private void compare(ShaMapInner a, ShaMapInner b) {
        for (int i = 0; i < 16; ++i) {
            ShaMapLeaf leaf;
            ShaMapLeaf la;
            ShaMapNode aChild = a.getBranch(i);
            ShaMapNode bChild = b.getBranch(i);
            if (aChild == null && bChild != null) {
                this.trackAdded(bChild);
                continue;
            }
            if (aChild != null && bChild == null) {
                this.trackRemoved(aChild);
                continue;
            }
            if (aChild == null || aChild.hash().equals(bChild.hash())) continue;
            boolean aleaf = aChild.isLeaf();
            boolean bLeaf = bChild.isLeaf();
            if (aleaf && bLeaf) {
                la = (ShaMapLeaf)aChild;
                ShaMapLeaf lb = (ShaMapLeaf)bChild;
                if (la.index.equals(lb.index)) {
                    this.modified.add(la.index);
                    continue;
                }
                this.deleted.add(la.index);
                this.added.add(lb.index);
                continue;
            }
            if (aleaf) {
                la = (ShaMapLeaf)aChild;
                ShaMapInner ib = (ShaMapInner)bChild;
                this.trackAdded(ib);
                if (ib.hasLeaf(la.index)) {
                    this.added.remove(la.index);
                    leaf = ib.getLeaf(la.index);
                    if (leaf.hash().equals(la.hash())) continue;
                    this.modified.add(la.index);
                    continue;
                }
                this.deleted.add(la.index);
                continue;
            }
            if (bLeaf) {
                ShaMapLeaf lb = (ShaMapLeaf)bChild;
                ShaMapInner ia = (ShaMapInner)aChild;
                this.trackRemoved(ia);
                if (ia.hasLeaf(lb.index)) {
                    this.deleted.remove(lb.index);
                    leaf = ia.getLeaf(lb.index);
                    if (leaf.hash().equals(lb.hash())) continue;
                    this.modified.add(lb.index);
                    continue;
                }
                this.added.add(lb.index);
                continue;
            }
            this.compare((ShaMapInner)aChild, (ShaMapInner)bChild);
        }
    }

    private void trackRemoved(ShaMapNode child) {
        child.walkAnyLeaves(new LeafWalker(){

            @Override
            public void onLeaf(ShaMapLeaf leaf) {
                ShaMapDiff.this.deleted.add(leaf.index);
            }
        });
    }

    private void trackAdded(ShaMapNode child) {
        child.walkAnyLeaves(new LeafWalker(){

            @Override
            public void onLeaf(ShaMapLeaf leaf) {
                ShaMapDiff.this.added.add(leaf.index);
            }
        });
    }
}

