/*
 * Decompiled with CFR 0.152.
 */
package com.jccdex.rpc.core.types.shamap;

import com.jccdex.rpc.core.coretypes.hash.Hash256;
import com.jccdex.rpc.core.fields.Field;
import com.jccdex.rpc.core.types.known.sle.LedgerEntry;
import com.jccdex.rpc.core.types.known.sle.ThreadedLedgerEntry;
import com.jccdex.rpc.core.types.known.sle.entries.DirectoryNode;
import com.jccdex.rpc.core.types.known.sle.entries.Offer;
import com.jccdex.rpc.core.types.known.sle.entries.RippleState;
import com.jccdex.rpc.core.types.known.tx.result.AffectedNode;
import com.jccdex.rpc.core.types.known.tx.result.TransactionResult;
import com.jccdex.rpc.core.types.shamap.AccountState;
import com.jccdex.rpc.core.types.shamap.LedgerEntryItem;
import com.jccdex.rpc.core.types.shamap.ShaMapLeaf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.TreeSet;

public class AccountStateBuilder {
    private AccountState state;
    private AccountState previousState = null;
    private long targetLedgerIndex;
    public long nextTransactionIndex = 0L;
    private Hash256 targetAccountHash;
    public long totalTransactions = 0L;
    private TreeSet<Hash256> directoriesModifiedMoreThanOnceByTransaction = new TreeSet();
    private TreeSet<Hash256> directoriesModifiedByTransaction = new TreeSet();
    public TreeSet<Hash256> modifiedEntries = new TreeSet();

    public void resetModified() {
        this.modifiedEntries.clear();
        this.directoriesModifiedMoreThanOnceByTransaction.clear();
    }

    public AccountStateBuilder(AccountState state, long targetLedgerIndex) {
        this.state = state;
        this.setStateCheckPoint();
        this.targetLedgerIndex = targetLedgerIndex;
    }

    public void onLedgerClose(long ledgerIndex, Hash256 accountHash, Hash256 parentHash) {
        this.state.updateSkipLists(ledgerIndex, parentHash);
        this.targetLedgerIndex = ledgerIndex;
        this.targetAccountHash = accountHash;
        this.nextTransactionIndex = 0L;
    }

    public void setStateCheckPoint() {
        this.previousState = this.state.copy();
    }

    public void onTransaction(TransactionResult tr) {
        if (tr.meta.transactionIndex().longValue() != this.nextTransactionIndex) {
            throw new AssertionError();
        }
        if (tr.ledgerIndex.longValue() != this.targetLedgerIndex + 1L) {
            throw new AssertionError((Object)String.format("%d != %d", tr.ledgerIndex.longValue(), this.targetLedgerIndex + 1L));
        }
        ++this.nextTransactionIndex;
        ++this.totalTransactions;
        this.directoriesModifiedByTransaction = new TreeSet();
        for (AffectedNode an : this.sortedAffectedNodes(tr)) {
            RippleState state;
            DirectoryNode dn;
            Offer offer;
            Hash256 id = an.ledgerIndex();
            LedgerEntry le = an.nodeAsFinal();
            if (an.isCreatedNode()) {
                this.modifiedEntries.add(id);
                le.setDefaults();
                this.state.addLE(le);
                if (le instanceof Offer) {
                    offer = (Offer)le;
                    offer.setOfferDefaults();
                    for (Hash256 directory : offer.directoryIndexes()) {
                        dn = this.getDirectoryForUpdating(directory);
                        Hash256 index = offer.index();
                        this.addToDirectoryNode(dn, index);
                    }
                } else if (le instanceof RippleState) {
                    state = (RippleState)le;
                    for (Hash256 directory : state.directoryIndexes()) {
                        dn = this.getDirectoryForUpdating(directory);
                        this.addToDirectoryNode(dn, state.index());
                    }
                }
                if (!(le instanceof ThreadedLedgerEntry)) continue;
                ThreadedLedgerEntry tle = (ThreadedLedgerEntry)le;
                tle.previousTxnID(tr.hash);
                tle.previousTxnLgrSeq(tr.ledgerIndex);
                continue;
            }
            if (an.isDeletedNode()) {
                this.modifiedEntries.remove(id);
                this.directoriesModifiedMoreThanOnceByTransaction.remove(id);
                this.state.removeLeaf(id);
                if (le instanceof Offer) {
                    offer = (Offer)le;
                    for (Hash256 directory : offer.directoryIndexes()) {
                        try {
                            dn = this.getDirectoryForUpdating(directory);
                            if (dn == null) continue;
                            if (dn.owner() != null) {
                                this.deleteFromDirectoryUnstable(offer, dn);
                                continue;
                            }
                            this.deleteFromDirectoryStable(offer, dn);
                        }
                        catch (Exception dn2) {
                            // empty catch block
                        }
                    }
                    continue;
                }
                if (!(le instanceof RippleState)) continue;
                state = (RippleState)le;
                for (Hash256 directory : state.directoryIndexes()) {
                    try {
                        dn = this.getDirectoryForUpdating(directory);
                        if (dn == null) continue;
                        this.deleteFromDirectoryUnstable(le, dn);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                continue;
            }
            if (!an.isModifiedNode()) continue;
            this.modifiedEntries.add(id);
            ShaMapLeaf leaf = this.state.getLeafForUpdating(id);
            LedgerEntryItem item = (LedgerEntryItem)leaf.item;
            LedgerEntry leModded = item.entry;
            if (le instanceof ThreadedLedgerEntry) {
                ThreadedLedgerEntry tle = (ThreadedLedgerEntry)le;
                tle.previousTxnID(tr.hash);
                tle.previousTxnLgrSeq(tr.ledgerIndex);
            }
            for (Field field : le) {
                if (field == Field.LedgerIndex) continue;
                leModded.put(field, le.get(field));
            }
        }
    }

    private void deleteFromDirectoryUnstable(LedgerEntry b4, DirectoryNode dn) {
        block3: {
            boolean b = this.directoryRemoveUnstable(dn, b4.index());
            DirectoryNode cursor = dn;
            if (!b) {
                while (cursor.indexNext() != null && !(b = this.directoryRemoveUnstable(cursor = this.getDirectoryForUpdating(cursor.nextIndex()), b4.index()))) {
                }
            }
            if (b) break block3;
            cursor = dn;
            while (cursor.indexPrevious() != null && !(b = this.directoryRemoveUnstable(cursor = this.getDirectoryForUpdating(cursor.prevIndex()), b4.index()))) {
            }
        }
    }

    private void deleteFromDirectoryStable(LedgerEntry b4, DirectoryNode dn) {
        block3: {
            boolean b = this.directoryRemoveStable(dn, b4.index());
            DirectoryNode cursor = dn;
            if (!b) {
                cursor = dn;
                while (cursor.indexPrevious() != null && !(b = this.directoryRemoveStable(cursor = this.getDirectoryForUpdating(cursor.prevIndex()), b4.index()))) {
                }
            }
            if (b) break block3;
            while (cursor.indexNext() != null && !(b = this.directoryRemoveStable(cursor = this.getDirectoryForUpdating(cursor.nextIndex()), b4.index()))) {
            }
        }
    }

    public static <E> Collection<E> makeCollection(Iterable<E> iter) {
        ArrayList<E> list = new ArrayList<E>();
        for (E item : iter) {
            list.add(item);
        }
        return list;
    }

    private ArrayList<AffectedNode> sortedAffectedNodes(TransactionResult tr) {
        ArrayList<AffectedNode> sorted = new ArrayList<AffectedNode>(AccountStateBuilder.makeCollection(tr.meta.affectedNodes()));
        Collections.sort(sorted, new Comparator<AffectedNode>(){

            @Override
            public int compare(AffectedNode o1, AffectedNode o2) {
                return this.ord(o1) - this.ord(o2);
            }

            private int ord(AffectedNode o1) {
                switch (o1.ledgerEntryType()) {
                    case DirectoryNode: {
                        return 1;
                    }
                    case RippleState: {
                        return 2;
                    }
                    case Offer: {
                        return 3;
                    }
                }
                return 4;
            }
        });
        return sorted;
    }

    private void onDirectoryModified(DirectoryNode dn) {
        Hash256 index = dn.index();
        if (this.directoriesModifiedByTransaction.contains(index)) {
            this.directoriesModifiedMoreThanOnceByTransaction.add(index);
        } else {
            this.directoriesModifiedByTransaction.add(index);
        }
    }

    private boolean directoryRemoveStable(DirectoryNode dn, Hash256 index) {
        this.onDirectoryModified(dn);
        return dn.indexes().remove(index);
    }

    private boolean directoryRemoveUnstable(DirectoryNode dn, Hash256 index) {
        this.onDirectoryModified(dn);
        return dn.indexes().removeUnstable(index);
    }

    private void addToDirectoryNode(DirectoryNode dn, Hash256 index) {
        this.onDirectoryModified(dn);
        dn.indexes().add(index);
    }

    private DirectoryNode getDirectoryForUpdating(Hash256 directoryIndex) {
        ShaMapLeaf leaf = this.state.getLeafForUpdating(directoryIndex);
        if (leaf == null) {
            return null;
        }
        LedgerEntryItem lei = (LedgerEntryItem)leaf.item;
        return (DirectoryNode)lei.entry;
    }

    public AccountState state() {
        return this.state;
    }

    public long currentLedgerIndex() {
        return this.targetLedgerIndex;
    }

    public String targetAccountHashHex() {
        return this.targetAccountHash.toHex();
    }

    public Hash256 targetAccountHash() {
        return this.targetAccountHash;
    }

    public TreeSet<Hash256> directoriesWithIndexesOutOfOrder() {
        TreeSet<Hash256> ret = new TreeSet<Hash256>();
        for (Hash256 hash256 : this.directoriesModifiedMoreThanOnceByTransaction) {
            DirectoryNode dn = this.state.getDirectoryNode(hash256);
            if (dn.owner() == null) continue;
            ret.add(hash256);
        }
        return ret;
    }

    public boolean bad() {
        return !this.state.hash().equals(this.targetAccountHash);
    }

    public AccountState previousState() {
        return this.previousState;
    }

    public void setState(AccountState map) {
        this.state = map;
    }
}

