/*
 * Decompiled with CFR 0.152.
 */
package com.jccdex.rpc.core.serialized;

import com.jccdex.core.encoding.common.B16;
import com.jccdex.core.serialized.BytesSink;
import com.jccdex.rpc.core.runtime.Value;
import com.jccdex.rpc.core.serialized.BinaryParser;
import com.jccdex.rpc.core.serialized.BytesList;
import com.jccdex.rpc.core.serialized.SerializedType;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class TypeTranslator<T extends SerializedType> {
    public T fromValue(Object object) {
        switch (Value.typeOf(object)) {
            case STRING: {
                return this.fromString((String)object);
            }
            case DOUBLE: {
                return this.fromDouble((Double)object);
            }
            case INTEGER: {
                return this.fromInteger((Integer)object);
            }
            case LONG: {
                return this.fromLong((Long)object);
            }
            case BOOLEAN: {
                return this.fromBoolean((Boolean)object);
            }
            case JSON_ARRAY: {
                return this.fromJSONArray((JSONArray)object);
            }
            case JSON_OBJECT: {
                return this.fromJSONObject((JSONObject)object);
            }
            case BYTE_ARRAY: {
                return this.fromBytes((byte[])object);
            }
        }
        return (T)((SerializedType)object);
    }

    public boolean toBoolean(T obj) {
        throw new UnsupportedOperationException();
    }

    public long toLong(T obj) {
        throw new UnsupportedOperationException();
    }

    public int toInteger(T obj) {
        throw new UnsupportedOperationException();
    }

    public double toDouble(T obj) {
        throw new UnsupportedOperationException();
    }

    public String toString(T obj) {
        return obj.toString();
    }

    public T fromJSONObject(JSONObject jsonObject) {
        throw new UnsupportedOperationException();
    }

    public T fromJSONArray(JSONArray jsonArray) {
        throw new UnsupportedOperationException();
    }

    public T fromBoolean(boolean aBoolean) {
        throw new UnsupportedOperationException();
    }

    public T fromLong(long aLong) {
        throw new UnsupportedOperationException();
    }

    public T fromInteger(int integer) {
        throw new UnsupportedOperationException();
    }

    public T fromDouble(double aDouble) {
        throw new UnsupportedOperationException();
    }

    public T fromString(String value) {
        throw new UnsupportedOperationException();
    }

    public abstract T fromParser(BinaryParser var1, Integer var2);

    public T fromParser(BinaryParser parser) {
        return this.fromParser(parser, null);
    }

    public T fromBytes(byte[] b) {
        return this.fromParser(new BinaryParser(b));
    }

    public T fromHex(String hex) {
        return this.fromBytes(B16.decode((String)hex));
    }

    public JSONObject toJSONObject(T obj) {
        throw new UnsupportedOperationException();
    }

    public JSONArray toJSONArray(T obj) {
        throw new UnsupportedOperationException();
    }

    public Object toJSON(T obj) {
        return obj.toJSON();
    }

    public void toBytesSink(T obj, BytesSink to) {
        obj.toBytesSink(to);
    }

    public byte[] toBytes(T obj) {
        BytesList to = new BytesList();
        this.toBytesSink(obj, to);
        return to.bytes();
    }

    public String toHex(T obj) {
        BytesList to = new BytesList();
        this.toBytesSink(obj, to);
        return to.bytesHex();
    }
}

