/*
 * Decompiled with CFR 0.152.
 */
package com.jccdex.rpc.core.coretypes.hash;

import com.jccdex.core.serialized.BytesSink;
import com.jccdex.rpc.core.coretypes.AccountID;
import com.jccdex.rpc.core.coretypes.hash.Hash;
import com.jccdex.rpc.core.fields.Field;
import com.jccdex.rpc.core.fields.Hash160Field;
import com.jccdex.rpc.core.fields.Type;

public class Hash160
extends Hash<Hash160> {
    public static Translator translate = new Translator();
    public static Hash160Field TakerPaysIssuer = Hash160.hash160Field(Field.TakerPaysIssuer);
    public static Hash160Field TakerGetsCurrency = Hash160.hash160Field(Field.TakerGetsCurrency);
    public static Hash160Field TakerPaysCurrency = Hash160.hash160Field(Field.TakerPaysCurrency);
    public static Hash160Field TakerGetsIssuer = Hash160.hash160Field(Field.TakerGetsIssuer);

    public Hash160(byte[] bytes) {
        super(bytes, 20);
    }

    @Override
    public Object toJSON() {
        return translate.toJSON(this);
    }

    @Override
    public byte[] toBytes() {
        return translate.toBytes(this);
    }

    @Override
    public String toHex() {
        return translate.toHex(this);
    }

    @Override
    public void toBytesSink(BytesSink to) {
        translate.toBytesSink(this, to);
    }

    @Override
    public Type type() {
        return Type.Hash160;
    }

    public static Hash160Field hash160Field(final Field f) {
        return new Hash160Field(){

            @Override
            public Field getField() {
                return f;
            }
        };
    }

    public static class Translator
    extends Hash.HashTranslator<Hash160> {
        @Override
        public Hash160 newInstance(byte[] b) {
            return new Hash160(b);
        }

        @Override
        public int byteWidth() {
            return 20;
        }

        @Override
        public Hash160 fromString(String value) {
            if (value.startsWith("r")) {
                return this.newInstance(AccountID.fromAddress(value).bytes());
            }
            return (Hash160)super.fromString(value);
        }
    }
}

