/*
 * Decompiled with CFR 0.152.
 */
package com.jccdex.rpc;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jccdex.core.client.Wallet;
import com.jccdex.core.client.WalletSM;
import com.jccdex.rpc.config.Config;
import com.jccdex.rpc.config.RpcNode;
import com.jccdex.rpc.core.coretypes.AccountID;
import com.jccdex.rpc.core.coretypes.Amount;
import com.jccdex.rpc.core.coretypes.Currency;
import com.jccdex.rpc.core.coretypes.uint.UInt32;
import com.jccdex.rpc.core.serialized.enums.EngineResult;
import com.jccdex.rpc.core.types.known.tx.signed.SignedTransaction;
import com.jccdex.rpc.core.types.known.tx.txns.OfferCancel;
import com.jccdex.rpc.core.types.known.tx.txns.OfferCreate;
import com.jccdex.rpc.core.types.known.tx.txns.Payment;
import com.jccdex.rpc.http.OkhttpUtil;
import com.jccdex.rpc.utils.Utils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class JccJingtum {
    private final RpcNode rpcNode;
    private int tryTimes;
    private final String SUCCESS_CODE = "success";
    private final Map<String, UInt32> seqList = new HashMap<String, UInt32>();
    private Boolean guomi;

    public JccJingtum(Boolean guomi, ArrayList<String> rpcNodes) {
        this.guomi = guomi;
        this.tryTimes = rpcNodes.size() > 5 ? rpcNodes.size() : 5;
        this.rpcNode = new RpcNode(rpcNodes);
    }

    public JccJingtum(Integer fee, String baseToken, Boolean guomi, ArrayList<String> rpcNodes) {
        this(guomi, rpcNodes);
        Config.setFee(fee);
        Config.setCurrency(baseToken);
    }

    public JccJingtum(String alphabet, Integer fee, String baseToken, Boolean guomi, ArrayList<String> rpcNodes) {
        this(fee, baseToken, guomi, rpcNodes);
        Config.setAlphabet(alphabet);
    }

    public JccJingtum(String alphabet, Integer fee, String baseToken, String platform, Boolean guomi, ArrayList<String> rpcNodes) {
        this(alphabet, fee, baseToken, guomi, rpcNodes);
        Config.setPlatform(platform);
    }

    public void setFee(Integer fee) throws Exception {
        if (fee < 10) {
            throw new Exception("\u71c3\u6599\u8d39\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0");
        }
        Config.setFee(fee);
    }

    public Integer getFee() {
        return Config.FEE;
    }

    public void setPlatform(String platform) throws Exception {
        if (!this.isValidAddress(platform)) {
            throw new Exception("\u5e73\u53f0\u8d26\u53f7\u4e0d\u5408\u6cd5");
        }
        Config.setPlatform(platform);
    }

    public String getPlatform() {
        return Config.PLATFORM;
    }

    public void setIssuer(String issuer) throws Exception {
        if (!this.isValidAddress(issuer)) {
            throw new Exception("\u5e73\u53f0\u8d26\u53f7\u4e0d\u5408\u6cd5");
        }
        Config.setIssuer(issuer);
    }

    public String getIssuer() {
        return Config.ISSUER;
    }

    public String getAlphabet() {
        return Config.Alphabet;
    }

    public String createWallet() throws Exception {
        try {
            ObjectNode data = new ObjectMapper().createObjectNode();
            if (this.guomi.booleanValue()) {
                WalletSM walletSM = WalletSM.generate((String)Config.Alphabet);
                data.put("secret", walletSM.getSecret());
                data.put("address", walletSM.getAddress());
            } else {
                Wallet wallet = Wallet.generate((String)Config.Alphabet);
                data.put("secret", wallet.getSecret());
                data.put("address", wallet.getAddress());
            }
            return data.toString();
        }
        catch (Exception e) {
            throw new Exception("\u521b\u5efa\u94b1\u5305\u5f02\u5e38");
        }
    }

    public String getAddress(String secret) throws Exception {
        try {
            if (!this.isValidSecret(secret)) {
                throw new Exception("\u94b1\u5305\u5bc6\u94a5\u4e0d\u5408\u6cd5");
            }
            if (this.guomi.booleanValue()) {
                WalletSM walletSM = WalletSM.fromSecret((String)secret);
                return walletSM.getAddress();
            }
            Wallet wallet = Wallet.fromSecret((String)secret);
            return wallet.getAddress();
        }
        catch (Exception e) {
            throw new Exception("\u83b7\u53d6\u94b1\u5305\u5730\u5740\u5f02\u5e38");
        }
    }

    public void setTryTimes(int tryTimes) {
        this.tryTimes = tryTimes;
    }

    private String getSequence(String address, String rpcNode) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode data = mapper.createObjectNode();
        ObjectNode object = mapper.createObjectNode();
        object.put("account", address);
        ArrayList<ObjectNode> params = new ArrayList<ObjectNode>();
        params.add(object);
        ArrayNode array = (ArrayNode)mapper.valueToTree(params);
        data.put("method", "account_info");
        data.set("params", (JsonNode)array);
        return OkhttpUtil.post(rpcNode, data.toString());
    }

    public long getSequence(String address) throws Exception {
        int times = this.tryTimes;
        Boolean success = false;
        if (!this.isValidAddress(address)) {
            throw new Exception("\u94b1\u5305\u5730\u5740\u4e0d\u5408\u6cd5");
        }
        UInt32 seq = this.seqList.get(address);
        String res = "";
        if (seq != null) {
            return seq.value();
        }
        do {
            --times;
            String url = this.rpcNode.randomUrl();
            res = this.getSequence(address, url);
            String sequence = "";
            try {
                String code = JSONObject.parseObject((String)res).getJSONObject("result").getString("status");
                if (!"success".equals(code)) continue;
                sequence = JSONObject.parseObject((String)res).getJSONObject("result").getJSONObject("account_data").getString("Sequence");
                seq = new UInt32(sequence);
                success = true;
                break;
            }
            catch (Exception e) {
                // empty catch block
            }
        } while (times > 0);
        if (success.booleanValue()) {
            this.seqList.put(address, seq);
            return seq.value();
        }
        throw new Exception(res);
    }

    public void setSequence(String address, long pSequence) throws Exception {
        if (!this.isValidAddress(address)) {
            throw new Exception("\u94b1\u5305\u5730\u5740\u4e0d\u5408\u6cd5");
        }
        if (pSequence < 0L) {
            throw new Exception("sequence\u4e0d\u5408\u6cd5,sequence\u4e0d\u80fd\u5c0f\u4e8e0");
        }
        this.seqList.put(address, new UInt32(pSequence));
    }

    private String requestTx(String hash, String rpcNode) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode data = mapper.createObjectNode();
        ObjectNode object = mapper.createObjectNode();
        object.put("transaction", hash);
        object.put("binary", false);
        ArrayList<ObjectNode> params = new ArrayList<ObjectNode>();
        params.add(object);
        ArrayNode array = (ArrayNode)mapper.valueToTree(params);
        data.put("method", "tx");
        data.set("params", (JsonNode)array);
        String res = OkhttpUtil.post(rpcNode, data.toString());
        return res;
    }

    public String requestTx(String hash) throws Exception {
        int times = this.tryTimes;
        String res = "";
        Boolean success = false;
        ArrayList<String> list = this.rpcNode.getUrls();
        Iterator<String> it = list.iterator();
        do {
            --times;
            String url = this.rpcNode.randomUrl();
            res = this.requestTx(hash, url);
            try {
                String status = JSONObject.parseObject((String)res).getJSONObject("result").getString("status");
                Boolean validated = JSONObject.parseObject((String)res).getJSONObject("result").getBoolean("validated");
                if (!"success".equals(status) || !validated.booleanValue()) continue;
                success = true;
                break;
            }
            catch (Exception e) {
                // empty catch block
            }
        } while (times > 0);
        if (success.booleanValue()) {
            return res;
        }
        throw new Exception(res);
    }

    public String getMemoData(String hexStrMemData) throws Exception {
        try {
            return Utils.hexStrToStr(hexStrMemData);
        }
        catch (Exception e) {
            throw new Exception("\u5185\u5bb9\u8f6c\u6362\u5931\u8d25");
        }
    }

    public String paymentWithCheck(String secret, String receiver, String pToken, String pAmount, String memos) throws Exception {
        return this.paymentWithCheck(secret, receiver, pToken, pAmount, Config.ISSUER, memos);
    }

    public String paymentWithCheck(String secret, String receiver, String pToken, String pAmount, String pIssuer, String memos) throws Exception {
        if (!this.isValidSecret(secret)) {
            throw new Exception("\u94b1\u5305\u5bc6\u94a5\u4e0d\u5408\u6cd5");
        }
        if (!this.isValidAddress(receiver)) {
            throw new Exception("\u94b1\u5305\u5730\u5740\u4e0d\u5408\u6cd5");
        }
        if (!this.isValidAddress(pIssuer)) {
            throw new Exception("\u94f6\u5173\u5730\u5740\u4e0d\u5408\u6cd5");
        }
        if (pToken.isEmpty()) {
            throw new Exception("token\u540d\u79f0\u4e0d\u5408\u6cd5");
        }
        if (pAmount.isEmpty()) {
            throw new Exception("\u6570\u91cf\u4e0d\u5408\u6cd5");
        }
        String sender = this.getAddress(secret);
        long sequence = this.getSequence(sender);
        ObjectMapper mapper = new ObjectMapper();
        String token = pToken.toUpperCase();
        Payment payment = new Payment(this.guomi);
        payment.as(AccountID.Account, sender);
        payment.as(AccountID.Destination, receiver);
        BigDecimal bigDecimal = new BigDecimal(pAmount);
        if (bigDecimal.compareTo(new BigDecimal(0)) < 1) {
            throw new Exception("token\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0");
        }
        Amount amount = Config.CURRENCY.equals(token) ? new Amount(bigDecimal) : new Amount(bigDecimal, Currency.fromString(token), AccountID.fromString(pIssuer));
        payment.as(Amount.Amount, amount);
        payment.as(Amount.Fee, String.valueOf(Config.FEE));
        payment.sequence(new UInt32(sequence));
        payment.flags(new UInt32(0));
        if (memos.length() > 0) {
            ArrayList<String> memoList = new ArrayList<String>(1);
            memoList.add(memos);
            payment.addMemo(memoList);
        }
        SignedTransaction tx = payment.sign(secret);
        String res = this.submitWithCheck(tx.tx_blob, tx.hash.toHex());
        return res;
    }

    public String paymentNoCheck(String secret, String receiver, String pToken, String pAmount, String memos) throws Exception {
        return this.paymentNoCheck(secret, receiver, pToken, pAmount, Config.ISSUER, memos);
    }

    public String paymentNoCheck(String secret, String receiver, String pToken, String pAmount, String pIssuer, String memos) throws Exception {
        if (!this.isValidSecret(secret)) {
            throw new Exception("\u94b1\u5305\u5bc6\u94a5\u4e0d\u5408\u6cd5");
        }
        if (!this.isValidAddress(receiver)) {
            throw new Exception("\u94b1\u5305\u5730\u5740\u4e0d\u5408\u6cd5");
        }
        if (!this.isValidAddress(pIssuer)) {
            throw new Exception("\u94f6\u5173\u5730\u5740\u4e0d\u5408\u6cd5");
        }
        if (pToken.isEmpty()) {
            throw new Exception("token\u540d\u79f0\u4e0d\u5408\u6cd5");
        }
        if (pAmount.isEmpty()) {
            throw new Exception("\u6570\u91cf\u4e0d\u5408\u6cd5");
        }
        String sender = this.getAddress(secret);
        long sequence = this.getSequence(sender);
        ObjectMapper mapper = new ObjectMapper();
        String token = pToken.toUpperCase();
        Payment payment = new Payment(this.guomi);
        payment.as(AccountID.Account, sender);
        payment.as(AccountID.Destination, receiver);
        BigDecimal bigDecimal = new BigDecimal(pAmount);
        if (bigDecimal.compareTo(new BigDecimal(0)) < 1) {
            throw new Exception("token\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0");
        }
        Amount amount = Config.CURRENCY.equals(token) ? new Amount(bigDecimal) : new Amount(bigDecimal, Currency.fromString(token), AccountID.fromString(pIssuer));
        payment.as(Amount.Amount, amount);
        payment.as(Amount.Fee, String.valueOf(Config.FEE));
        payment.sequence(new UInt32(sequence));
        payment.flags(new UInt32(0));
        if (memos.length() > 0) {
            ArrayList<String> memoList = new ArrayList<String>(1);
            memoList.add(memos);
            payment.addMemo(memoList);
        }
        SignedTransaction tx = payment.sign(secret);
        String res = this.submitNoCheck(tx.tx_blob);
        return res;
    }

    public String createOrderWithCheck(String secret, String pPayToke, String pPayAmount, String pGetToken, String pGetAmount, String memos) throws Exception {
        return this.createOrderWithCheck(secret, pPayToke, pPayAmount, Config.ISSUER, pGetToken, pGetAmount, Config.ISSUER, memos);
    }

    public String createOrderWithCheck(String secret, String pPayToke, String pPayAmount, String pPayIssuer, String pGetToken, String pGetAmount, String pGetIssuer, String memos) throws Exception {
        if (!this.isValidSecret(secret)) {
            throw new Exception("\u94b1\u5305\u5bc6\u94a5\u4e0d\u5408\u6cd5");
        }
        if (!this.isValidAddress(pPayIssuer)) {
            throw new Exception("\u94f6\u5173\u5730\u5740\u4e0d\u5408\u6cd5");
        }
        if (!this.isValidAddress(pGetIssuer)) {
            throw new Exception("\u94f6\u5173\u5730\u5740\u4e0d\u5408\u6cd5");
        }
        if (pPayToke.isEmpty() || pGetToken.isEmpty()) {
            throw new Exception("token\u540d\u79f0\u4e0d\u5408\u6cd5");
        }
        if (pPayAmount.isEmpty() || pGetAmount.isEmpty()) {
            throw new Exception("token\u6570\u91cf\u4e0d\u5408\u6cd5");
        }
        String address = this.getAddress(secret);
        String payToken = pPayToke.toUpperCase();
        String getToken = pGetToken.toUpperCase();
        OfferCreate offerCreate = new OfferCreate(this.guomi);
        offerCreate.as(AccountID.Account, address);
        offerCreate.as(AccountID.Platform, Config.PLATFORM);
        BigDecimal payBigDecimal = new BigDecimal(pPayAmount);
        BigDecimal getBigDecimal = new BigDecimal(pGetAmount);
        if (payBigDecimal.compareTo(new BigDecimal(0)) < 1) {
            throw new Exception("token\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0");
        }
        if (getBigDecimal.compareTo(new BigDecimal(0)) < 1) {
            throw new Exception("token\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0");
        }
        Amount payAmount = Config.CURRENCY.equals(payToken) ? new Amount(payBigDecimal) : new Amount(payBigDecimal, Currency.fromString(payToken), AccountID.fromString(pPayIssuer));
        Amount getAmount = Config.CURRENCY.equals(getToken) ? new Amount(getBigDecimal) : new Amount(getBigDecimal, Currency.fromString(getToken), AccountID.fromString(pGetIssuer));
        offerCreate.as(Amount.TakerPays, getAmount);
        offerCreate.as(Amount.TakerGets, payAmount);
        offerCreate.as(Amount.Fee, String.valueOf(Config.FEE));
        long sequence = this.getSequence(address);
        offerCreate.sequence(new UInt32(sequence));
        if (memos.length() > 0) {
            ArrayList<String> memoList = new ArrayList<String>(1);
            memoList.add(memos);
            offerCreate.addMemo(memoList);
        }
        SignedTransaction tx = offerCreate.sign(secret);
        String res = this.submitWithCheck(tx.tx_blob, tx.hash.toHex());
        return res;
    }

    public String createOrderNoCheck(String secret, String pPayToke, String pPayAmount, String pGetToken, String pGetAmount, String memos) throws Exception {
        try {
            return this.createOrderNoCheck(secret, pPayToke, pPayAmount, Config.ISSUER, pGetToken, pGetAmount, Config.ISSUER, memos);
        }
        catch (Exception e) {
            throw new Exception("\u6302\u5355\u5931\u8d25");
        }
    }

    public String createOrderNoCheck(String secret, String pPayToke, String pPayAmount, String pPayIssuer, String pGetToken, String pGetAmount, String pGetIssuer, String memos) throws Exception {
        if (!this.isValidSecret(secret)) {
            throw new Exception("\u94b1\u5305\u5bc6\u94a5\u4e0d\u5408\u6cd5");
        }
        if (!this.isValidAddress(pPayIssuer)) {
            throw new Exception("\u94f6\u5173\u5730\u5740\u4e0d\u5408\u6cd5");
        }
        if (!this.isValidAddress(pGetIssuer)) {
            throw new Exception("\u94f6\u5173\u5730\u5740\u4e0d\u5408\u6cd5");
        }
        if (pPayToke.isEmpty() || pGetToken.isEmpty()) {
            throw new Exception("token\u540d\u79f0\u4e0d\u5408\u6cd5");
        }
        if (pPayAmount.isEmpty() || pGetAmount.isEmpty()) {
            throw new Exception("token\u6570\u91cf\u4e0d\u5408\u6cd5");
        }
        String address = this.getAddress(secret);
        String payToken = pPayToke.toUpperCase();
        String getToken = pGetToken.toUpperCase();
        OfferCreate offerCreate = new OfferCreate(this.guomi);
        offerCreate.as(AccountID.Account, address);
        offerCreate.as(AccountID.Platform, Config.PLATFORM);
        BigDecimal payBigDecimal = new BigDecimal(pPayAmount);
        BigDecimal getBigDecimal = new BigDecimal(pGetAmount);
        if (payBigDecimal.compareTo(new BigDecimal(0)) < 1) {
            throw new Exception("token\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0");
        }
        if (getBigDecimal.compareTo(new BigDecimal(0)) < 1) {
            throw new Exception("token\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0");
        }
        Amount payAmount = Config.CURRENCY.equals(payToken) ? new Amount(payBigDecimal) : new Amount(payBigDecimal, Currency.fromString(payToken), AccountID.fromString(pPayIssuer));
        Amount getAmount = Config.CURRENCY.equals(getToken) ? new Amount(getBigDecimal) : new Amount(getBigDecimal, Currency.fromString(getToken), AccountID.fromString(pGetIssuer));
        offerCreate.as(Amount.TakerPays, getAmount);
        offerCreate.as(Amount.TakerGets, payAmount);
        offerCreate.as(Amount.Fee, String.valueOf(Config.FEE));
        long sequence = this.getSequence(address);
        offerCreate.sequence(new UInt32(sequence));
        if (memos.length() > 0) {
            ArrayList<String> memoList = new ArrayList<String>(1);
            memoList.add(memos);
            offerCreate.addMemo(memoList);
        }
        SignedTransaction tx = offerCreate.sign(secret);
        String res = this.submitNoCheck(tx.tx_blob);
        return res;
    }

    public String cancleOrder(String secret, long pSequence) throws Exception {
        if (!this.isValidSecret(secret)) {
            throw new Exception("\u94b1\u5305\u5bc6\u94a5\u4e0d\u5408\u6cd5");
        }
        if (pSequence < 1L) {
            throw new Exception("sequence\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0");
        }
        String address = this.getAddress(secret);
        OfferCancel offerCancel = new OfferCancel(this.guomi);
        offerCancel.as(AccountID.Account, address);
        offerCancel.as(UInt32.OfferSequence, pSequence);
        offerCancel.as(Amount.Fee, String.valueOf(Config.FEE));
        long sequence = this.getSequence(address);
        offerCancel.sequence(new UInt32(sequence));
        SignedTransaction tx = offerCancel.sign(secret);
        String res = this.submitNoCheck(tx.tx_blob);
        return res;
    }

    public String setTokenIssue721(String secret, String receiver, String pToken, String pAmount, String pIssuer, String memos) throws Exception {
        try {
            if (!this.isValidSecret(secret)) {
                throw new Exception("\u94b1\u5305\u5bc6\u94a5\u4e0d\u5408\u6cd5");
            }
            if (!this.isValidAddress(receiver)) {
                throw new Exception("\u94b1\u5305\u5730\u5740\u4e0d\u5408\u6cd5");
            }
            if (!this.isValidAddress(pIssuer)) {
                throw new Exception("\u94f6\u5173\u5730\u5740\u4e0d\u5408\u6cd5");
            }
            if (pToken.isEmpty()) {
                throw new Exception("token\u540d\u79f0\u4e0d\u5408\u6cd5");
            }
            if (pAmount.isEmpty()) {
                throw new Exception("\u6570\u91cf\u4e0d\u5408\u6cd5");
            }
            String sender = this.getAddress(secret);
            long sequence = this.getSequence(sender);
            ObjectMapper mapper = new ObjectMapper();
            String token = pToken.toUpperCase();
            Payment payment = new Payment(this.guomi);
            payment.as(AccountID.Account, sender);
            payment.as(AccountID.Destination, receiver);
            BigDecimal bigDecimal = new BigDecimal(pAmount);
            if (bigDecimal.compareTo(new BigDecimal(0)) < 1) {
                throw new Exception("token\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0");
            }
            Amount amount = Config.CURRENCY.equals(token) ? new Amount(bigDecimal) : new Amount(bigDecimal, Currency.fromString(token), AccountID.fromString(pIssuer));
            payment.as(Amount.Amount, amount);
            payment.as(Amount.Fee, String.valueOf(Config.FEE));
            payment.sequence(new UInt32(sequence));
            payment.flags(new UInt32(0));
            if (memos.length() > 0) {
                ArrayList<String> memoList = new ArrayList<String>(1);
                memoList.add(memos);
                payment.addMemo(memoList);
            }
            SignedTransaction tx = payment.sign(secret);
            String res = this.submitWithCheck(tx.tx_blob, tx.hash.toHex());
            return res;
        }
        catch (Exception e) {
            throw new Exception("\u8f6c\u8d26\u5931\u8d25");
        }
    }

    public String submitWithCheck(String txBlob, String hash) throws Exception {
        int times = this.tryTimes;
        String resTx = "";
        String res = "";
        String successRes = "";
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode data = mapper.createObjectNode();
        ObjectNode object = mapper.createObjectNode();
        object.put("tx_blob", txBlob);
        ArrayList<ObjectNode> params = new ArrayList<ObjectNode>();
        params.add(object);
        ArrayNode array = (ArrayNode)mapper.valueToTree(params);
        data.put("method", "submit");
        data.set("params", (JsonNode)array);
        do {
            --times;
            try {
                String url = this.rpcNode.randomUrl();
                res = OkhttpUtil.post(url, data.toString());
                String sender = JSONObject.parseObject((String)res).getJSONObject("result").getJSONObject("tx_json").getString("Account");
                int engine_result_code = JSONObject.parseObject((String)res).getJSONObject("result").getIntValue("engine_result_code");
                EngineResult engineResult = EngineResult.fromNumber(engine_result_code);
                if (EngineResult.isPastSeq(engineResult).booleanValue()) {
                    this.seqList.remove(sender);
                    break;
                }
                if (!EngineResult.isRetry(engineResult).booleanValue()) break;
                if (EngineResult.isSuccess(engineResult).booleanValue()) {
                    successRes = res;
                    long sequence = JSONObject.parseObject((String)res).getJSONObject("result").getJSONObject("tx_json").getLongValue("Sequence");
                    this.setSequence(sender, ++sequence);
                }
                Thread.sleep(500L);
            }
            catch (Exception e) {
                continue;
            }
            Thread.sleep(2000L);
        } while (times > 0);
        resTx = this.requestTx(hash);
        if (!resTx.isEmpty()) {
            return successRes;
        }
        throw new Exception(res);
    }

    public String submitNoCheck(String txBlob) throws Exception {
        int times = this.tryTimes;
        String resTx = "";
        String res = "";
        String successRes = "";
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode data = mapper.createObjectNode();
        ObjectNode object = mapper.createObjectNode();
        object.put("tx_blob", txBlob);
        ArrayList<ObjectNode> params = new ArrayList<ObjectNode>();
        params.add(object);
        ArrayNode array = (ArrayNode)mapper.valueToTree(params);
        data.put("method", "submit");
        data.set("params", (JsonNode)array);
        do {
            --times;
            try {
                String url = this.rpcNode.randomUrl();
                res = OkhttpUtil.post(url, data.toString());
                String sender = JSONObject.parseObject((String)res).getJSONObject("result").getJSONObject("tx_json").getString("Account");
                int engine_result_code = JSONObject.parseObject((String)res).getJSONObject("result").getIntValue("engine_result_code");
                EngineResult engineResult = EngineResult.fromNumber(engine_result_code);
                if (EngineResult.isPastSeq(engineResult).booleanValue()) {
                    this.seqList.remove(sender);
                    break;
                }
                if (!EngineResult.isRetry(engineResult).booleanValue()) break;
                if (EngineResult.isSuccess(engineResult).booleanValue()) {
                    successRes = res;
                    long sequence = JSONObject.parseObject((String)res).getJSONObject("result").getJSONObject("tx_json").getLongValue("Sequence");
                    this.setSequence(sender, ++sequence);
                    break;
                }
                Thread.sleep(500L);
            }
            catch (Exception e) {
                continue;
            }
            Thread.sleep(2000L);
        } while (times > 0);
        if (!successRes.isEmpty()) {
            return successRes;
        }
        throw new Exception(res);
    }

    private boolean isValidSecret(String secret) {
        try {
            if (this.guomi.booleanValue()) {
                return WalletSM.isValidSecret((String)secret, (String)Config.Alphabet);
            }
            return Wallet.isValidSecret((String)secret, (String)Config.Alphabet);
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isValidAddress(String address) {
        try {
            if (this.guomi.booleanValue()) {
                return WalletSM.isValidAddress((String)address, (String)Config.Alphabet);
            }
            return Wallet.isValidAddress((String)address, (String)Config.Alphabet);
        }
        catch (Exception e) {
            return false;
        }
    }
}

