/*
 * Decompiled with CFR 0.152.
 */
package com.jccdex.rpc.utils;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.jccdex.rpc.utils.NameUtils;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JsonUtils {
    private static ObjectMapper om = new ObjectMapper();

    public static String toJsonString(Object obj) {
        try {
            om.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
            return om.writerWithDefaultPrettyPrinter().writeValueAsString(obj);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T toObject(String jsonStr, Class<T> cla) {
        om.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        if (jsonStr == null) {
            return null;
        }
        try {
            return (T)om.readValue(jsonStr, cla);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T toEntity(String jsonStr, Class<T> cla) {
        om.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        if (jsonStr == null) {
            return null;
        }
        try {
            Map res = (Map)om.readValue(jsonStr, Map.class);
            String status = (String)res.get("status");
            if (status.equals("success")) {
                Map result = (Map)res.get("result");
                T obj = cla.newInstance();
                BeanInfo beanInfo = Introspector.getBeanInfo(cla, Object.class);
                PropertyDescriptor[] pds = beanInfo.getPropertyDescriptors();
                Map<String, PropertyDescriptor> props = JsonUtils.propDesc2Map(pds);
                JsonUtils.transfer(result, obj, props);
                return obj;
            }
            if (status.equals("error")) {
                String error = (String)res.get("error");
                String error_code = String.valueOf(res.get("error_code"));
                String error_message = (String)res.get("error_message");
                String msg = error_code + ":" + error + ". " + error_message;
                throw new RuntimeException(msg);
            }
            throw new RuntimeException("unknown error");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Map<String, PropertyDescriptor> propDesc2Map(PropertyDescriptor[] props) {
        HashMap<String, PropertyDescriptor> res = new HashMap<String, PropertyDescriptor>();
        if (props != null && props.length > 0) {
            for (PropertyDescriptor prop : props) {
                res.put(prop.getName().toUpperCase(), prop);
            }
        }
        return res;
    }

    private static <T> void transfer(Map<String, Object> result, T obj, Map<String, PropertyDescriptor> props) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchFieldException, SecurityException, InstantiationException, IntrospectionException, ClassNotFoundException {
        for (Map.Entry<String, Object> entry : result.entrySet()) {
            String key = entry.getKey();
            Object val = entry.getValue();
            String attrKey = NameUtils.getCamelName(key);
            PropertyDescriptor prop = props.get(attrKey.toUpperCase());
            if (val != null && prop != null) {
                if (val instanceof Map) {
                    JsonUtils.transferMap(prop, obj, attrKey, val);
                    continue;
                }
                if (val instanceof List) {
                    JsonUtils.transferList(prop, obj, attrKey, val);
                    continue;
                }
                if (!(val instanceof Integer) && !(val instanceof Long) && !(val instanceof Short) && !(val instanceof Float) && !(val instanceof String) && !(val instanceof Double) && !(val instanceof Boolean)) continue;
                JsonUtils.transferValue(prop, obj, val);
                continue;
            }
            if (val == null || prop != null || !(val instanceof Map)) continue;
            JsonUtils.transfer((Map)val, obj, props);
        }
    }

    private static <T> void transferMap(PropertyDescriptor prop, T obj, String attrKey, Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchFieldException, SecurityException, ClassNotFoundException, InstantiationException, IntrospectionException {
        Field mapField = obj.getClass().getDeclaredField(attrKey);
        Object chdObj = mapField.getType().newInstance();
        BeanInfo beanInfo = Introspector.getBeanInfo(mapField.getType(), Object.class);
        PropertyDescriptor[] chdPds = beanInfo.getPropertyDescriptors();
        Map<String, PropertyDescriptor> chdProps = JsonUtils.propDesc2Map(chdPds);
        JsonUtils.transfer((Map)val, chdObj, chdProps);
        prop.getWriteMethod().invoke(obj, chdObj);
    }

    private static <T> void transferList(PropertyDescriptor prop, T obj, String attrKey, Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchFieldException, SecurityException, ClassNotFoundException, InstantiationException, IntrospectionException {
        Field listField = obj.getClass().getDeclaredField(attrKey);
        ParameterizedType listGenericType = (ParameterizedType)listField.getGenericType();
        Type[] listActualTypeArguments = listGenericType.getActualTypeArguments();
        if (listActualTypeArguments != null && listActualTypeArguments.length > 0) {
            List<?> chdList = new ArrayList();
            Type actualType = listActualTypeArguments[0];
            if (actualType.getTypeName().contains("java.lang.") || actualType.getTypeName().contains("java.util.")) {
                chdList = (List)val;
            } else {
                List items = (List)val;
                for (Map map : items) {
                    Class<?> clazz = Class.forName(actualType.getTypeName());
                    Object item = clazz.newInstance();
                    BeanInfo beanInfo = Introspector.getBeanInfo(clazz, Object.class);
                    PropertyDescriptor[] chdPds = beanInfo.getPropertyDescriptors();
                    Map<String, PropertyDescriptor> chdProps = JsonUtils.propDesc2Map(chdPds);
                    JsonUtils.transfer(map, item, chdProps);
                    chdList.add(item);
                }
            }
            prop.getWriteMethod().invoke(obj, chdList);
        }
    }

    private static <T> void transferValue(PropertyDescriptor prop, T obj, Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (prop != null) {
            Method setter = prop.getWriteMethod();
            if (prop.getPropertyType().equals(Integer.class)) {
                setter.invoke(obj, Integer.parseInt(val.toString()));
            } else if (prop.getPropertyType().equals(Long.class)) {
                setter.invoke(obj, Long.parseLong(val.toString()));
            } else if (prop.getPropertyType().equals(Short.class)) {
                setter.invoke(obj, Short.parseShort(val.toString()));
            } else if (prop.getPropertyType().equals(String.class)) {
                setter.invoke(obj, val.toString());
            } else if (prop.getPropertyType().equals(Float.class)) {
                setter.invoke(obj, Float.valueOf(Float.parseFloat(val.toString())));
            } else if (prop.getPropertyType().equals(Double.class)) {
                setter.invoke(obj, Double.parseDouble(val.toString()));
            } else if (prop.getPropertyType().equals(Boolean.class)) {
                setter.invoke(obj, Boolean.parseBoolean(val.toString()));
            }
        }
    }
}

