/*
 * Decompiled with CFR 0.152.
 */
package com.jccdex.rpc.core.types.known.tx.signed;

import com.jccdex.core.crypto.ecdsa.IKeyPair;
import com.jccdex.core.crypto.ecdsa.Seed;
import com.jccdex.core.crypto.ecdsa.SeedSM;
import com.jccdex.core.serialized.BytesSink;
import com.jccdex.core.utils.SM3;
import com.jccdex.rpc.core.coretypes.Amount;
import com.jccdex.rpc.core.coretypes.Blob;
import com.jccdex.rpc.core.coretypes.STObject;
import com.jccdex.rpc.core.coretypes.hash.HalfSha512;
import com.jccdex.rpc.core.coretypes.hash.Hash256;
import com.jccdex.rpc.core.coretypes.hash.prefixes.HashPrefix;
import com.jccdex.rpc.core.coretypes.uint.UInt32;
import com.jccdex.rpc.core.serialized.BytesList;
import com.jccdex.rpc.core.serialized.MultiSink;
import com.jccdex.rpc.core.serialized.enums.TransactionType;
import com.jccdex.rpc.core.types.known.tx.Transaction;
import java.util.Arrays;

public class SignedTransaction {
    public Transaction txn;
    public Hash256 hash;
    public byte[] signingData;
    public byte[] previousSigningData;
    public String tx_blob;
    private Boolean guomi = false;

    private SignedTransaction(Transaction of) {
        this.txn = (Transaction)STObject.translate.fromBytes(of.toBytes());
        this.guomi = of.getGuomi();
    }

    @Deprecated
    public SignedTransaction() {
    }

    public void sign(String base58Secret) {
        if (this.guomi.booleanValue()) {
            this.sign(SeedSM.fromBase58((String)base58Secret).keyPair());
        } else {
            this.sign(Seed.fromBase58((String)base58Secret).keyPair());
        }
    }

    public static SignedTransaction fromTx(Transaction tx) {
        return new SignedTransaction(tx);
    }

    public void sign(IKeyPair keyPair) {
        this.prepare(keyPair, null, null, null);
    }

    public void prepare(IKeyPair keyPair, Amount fee, UInt32 Sequence, UInt32 lastLedgerSequence) {
        Blob pubKey = new Blob(keyPair.canonicalPubBytes());
        if (lastLedgerSequence != null) {
            this.txn.put(UInt32.LastLedgerSequence, lastLedgerSequence);
        }
        if (Sequence != null) {
            this.txn.put(UInt32.Sequence, Sequence);
        }
        if (fee != null) {
            this.txn.put(Amount.Fee, fee);
        }
        this.txn.signingPubKey(pubKey);
        this.txn.setCanonicalSignatureFlag();
        this.txn.checkFormat();
        this.signingData = this.txn.signingData();
        if (this.previousSigningData != null && Arrays.equals(this.signingData, this.previousSigningData)) {
            return;
        }
        try {
            this.txn.txnSignature(new Blob(keyPair.signMessage(this.signingData)));
            BytesList blob = new BytesList();
            if (this.guomi.booleanValue()) {
                SM3 id = SM3.prefixed256((byte[])HashPrefix.transactionID.bytes());
                this.txn.toBytesSink(new MultiSink(new BytesSink[]{blob, id}));
                this.tx_blob = blob.bytesHex();
                this.hash = new Hash256(id.finish());
            } else {
                HalfSha512 id = HalfSha512.prefixed256(HashPrefix.transactionID);
                this.txn.toBytesSink(new MultiSink(blob, id));
                this.tx_blob = blob.bytesHex();
                this.hash = id.finish();
            }
        }
        catch (Exception e) {
            this.previousSigningData = null;
            throw new RuntimeException(e);
        }
        this.previousSigningData = this.signingData;
    }

    public TransactionType transactionType() {
        return this.txn.transactionType();
    }
}

