/*
 * Decompiled with CFR 0.152.
 */
package com.jccdex.rpc.core.types.known.tx;

import com.jccdex.core.crypto.ecdsa.IKeyPair;
import com.jccdex.rpc.core.coretypes.AccountID;
import com.jccdex.rpc.core.coretypes.Amount;
import com.jccdex.rpc.core.coretypes.Blob;
import com.jccdex.rpc.core.coretypes.STArray;
import com.jccdex.rpc.core.coretypes.STObject;
import com.jccdex.rpc.core.coretypes.hash.HalfSha512;
import com.jccdex.rpc.core.coretypes.hash.Hash256;
import com.jccdex.rpc.core.coretypes.hash.prefixes.HashPrefix;
import com.jccdex.rpc.core.coretypes.uint.UInt16;
import com.jccdex.rpc.core.coretypes.uint.UInt32;
import com.jccdex.rpc.core.enums.TransactionFlag;
import com.jccdex.rpc.core.fields.Field;
import com.jccdex.rpc.core.formats.TxFormat;
import com.jccdex.rpc.core.serialized.BytesList;
import com.jccdex.rpc.core.serialized.SerializedType;
import com.jccdex.rpc.core.serialized.enums.TransactionType;
import com.jccdex.rpc.core.types.known.tx.signed.SignedTransaction;
import com.jccdex.rpc.utils.HashUtils;
import com.jccdex.rpc.utils.Utils;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class Transaction
extends STObject {
    public static final boolean CANONICAL_FLAG_DEPLOYED = true;
    public static final UInt32 CANONICAL_SIGNATURE = new UInt32(TransactionFlag.FullyCanonicalSig);
    private Boolean guomi = false;

    public Transaction(TransactionType type) {
        this.setFormat(TxFormat.formats.get(type));
        this.put(Field.TransactionType, type);
    }

    public Transaction(TransactionType type, Boolean guomi) {
        this.guomi = guomi;
        this.setFormat(TxFormat.formats.get(type));
        this.put(Field.TransactionType, type);
    }

    public SignedTransaction sign(String secret) {
        SignedTransaction signed = SignedTransaction.fromTx(this);
        signed.sign(secret);
        return signed;
    }

    public SignedTransaction sign(IKeyPair keyPair) {
        SignedTransaction signed = SignedTransaction.fromTx(this);
        signed.sign(keyPair);
        return signed;
    }

    public TransactionType transactionType() {
        return Transaction.transactionType(this);
    }

    public Hash256 signingHash() {
        HalfSha512 signing = HalfSha512.prefixed256(HashPrefix.txSign);
        this.toBytesSink(signing, new STObject.FieldFilter(){

            @Override
            public boolean evaluate(Field a) {
                return a.isSigningField();
            }
        });
        return signing.finish();
    }

    public byte[] signingData() {
        BytesList bl = new BytesList();
        bl.add(HashPrefix.txSign.bytes);
        this.toBytesSink(bl, new STObject.FieldFilter(){

            @Override
            public boolean evaluate(Field a) {
                return a.isSigningField();
            }
        });
        return bl.bytes();
    }

    public Boolean getGuomi() {
        return this.guomi;
    }

    public void setCanonicalSignatureFlag() {
        UInt32 flags = this.get(UInt32.Flags);
        flags = flags == null ? CANONICAL_SIGNATURE : (UInt32)flags.or(CANONICAL_SIGNATURE);
        this.put(UInt32.Flags, flags);
    }

    public UInt32 flags() {
        return this.get(UInt32.Flags);
    }

    public UInt32 sourceTag() {
        return this.get(UInt32.SourceTag);
    }

    public UInt32 sequence() {
        return this.get(UInt32.Sequence);
    }

    public UInt32 lastLedgerSequence() {
        return this.get(UInt32.LastLedgerSequence);
    }

    public UInt32 operationLimit() {
        return this.get(UInt32.OperationLimit);
    }

    public Hash256 previousTxnID() {
        return this.get(Hash256.PreviousTxnID);
    }

    public Hash256 accountTxnID() {
        return this.get(Hash256.AccountTxnID);
    }

    public Amount fee() {
        return this.get(Amount.Fee);
    }

    public Blob signingPubKey() {
        return this.get(Blob.SigningPubKey);
    }

    public Blob txnSignature() {
        return this.get(Blob.TxnSignature);
    }

    public AccountID account() {
        return this.get(AccountID.Account);
    }

    public void transactionType(UInt16 val) {
        this.put(Field.TransactionType, (SerializedType)val);
    }

    public void flags(UInt32 val) {
        this.put(Field.Flags, (SerializedType)val);
    }

    public void sourceTag(UInt32 val) {
        this.put(Field.SourceTag, (SerializedType)val);
    }

    public void sequence(UInt32 val) {
        this.put(Field.Sequence, (SerializedType)val);
    }

    public void lastLedgerSequence(UInt32 val) {
        this.put(Field.LastLedgerSequence, (SerializedType)val);
    }

    public void operationLimit(UInt32 val) {
        this.put(Field.OperationLimit, (SerializedType)val);
    }

    public void previousTxnID(Hash256 val) {
        this.put(Field.PreviousTxnID, (SerializedType)val);
    }

    public void accountTxnID(Hash256 val) {
        this.put(Field.AccountTxnID, (SerializedType)val);
    }

    public void fee(Amount val) {
        this.put(Field.Fee, (SerializedType)val);
    }

    public void signingPubKey(Blob val) {
        this.put(Field.SigningPubKey, (SerializedType)val);
    }

    public void txnSignature(Blob val) {
        this.put(Field.TxnSignature, (SerializedType)val);
    }

    public void account(AccountID val) {
        this.put(Field.Account, (SerializedType)val);
    }

    public void platform(AccountID val) {
        this.put(Field.Platform, (SerializedType)val);
    }

    public void memos(STArray val) {
        this.put(Field.Memos, (SerializedType)val);
    }

    public void addMemo(List<String> memos) {
        JSONArray memosArray = new JSONArray();
        if (memos != null) {
            for (String memo : memos) {
                JSONObject memoObj = new JSONObject();
                JSONObject memoData = new JSONObject();
                memoData.put("MemoData", (Object)Utils.strToHexStr(memo));
                memoObj.put("Memo", (Object)memoData);
                memosArray.put((Object)memoObj);
            }
        }
        this.put(STArray.Memos, STArray.translate.fromJSONArray(memosArray));
    }

    public Hash256 hash() {
        return this.get(Hash256.hash);
    }

    public AccountID signingKey() {
        byte[] pubKey = HashUtils.SHA256_RIPEMD160(this.signingPubKey().toBytes());
        return AccountID.fromAddressBytes(pubKey);
    }
}

