/*
 * Decompiled with CFR 0.152.
 */
package com.jccdex.rpc.core.serialized.enums;

import com.jccdex.core.encoding.common.B16;
import com.jccdex.core.serialized.BytesSink;
import com.jccdex.rpc.core.fields.Type;
import com.jccdex.rpc.core.serialized.BinaryParser;
import com.jccdex.rpc.core.serialized.SerializedType;
import com.jccdex.rpc.core.serialized.TypeTranslator;
import java.util.TreeMap;

public enum TransactionType implements SerializedType
{
    Invalid(-1),
    Payment(0),
    SuspendedPaymentCreate(1),
    SuspendedPaymentFinish(2),
    AccountSet(3),
    SuspendedPaymentCancel(4),
    SetRegularKey(5),
    NickNameSet(6),
    OfferCreate(7),
    OfferCancel(8),
    unused(9),
    TicketCreate(10),
    TicketCancel(11),
    SignerListSet(12),
    TrustSet(20),
    RelationSet(30),
    EnableAmendment(100),
    SetFee(101),
    TransferToken(208),
    TokenIssue(209),
    TokenDel(210);

    final int ord;
    private static TreeMap<Integer, TransactionType> byCode;
    public static Translator translate;

    public int asInteger() {
        return this.ord;
    }

    private TransactionType(int i) {
        this.ord = i;
    }

    @Override
    public Type type() {
        return Type.UInt16;
    }

    public static TransactionType fromNumber(Number i) {
        return byCode.get(i.intValue());
    }

    @Override
    public byte[] toBytes() {
        return new byte[]{(byte)(this.ord >> 8), (byte)(this.ord & 0xFF)};
    }

    @Override
    public Object toJSON() {
        return this.toString();
    }

    @Override
    public String toHex() {
        return B16.toString((byte[])this.toBytes());
    }

    @Override
    public void toBytesSink(BytesSink to) {
        to.add(this.toBytes());
    }

    static {
        byCode = new TreeMap();
        TransactionType[] transactionTypeArray = TransactionType.values();
        int n = transactionTypeArray.length;
        for (int i = 0; i < n; ++i) {
            TransactionType a;
            TransactionType f = a = transactionTypeArray[i];
            byCode.put(f.ord, f);
        }
        translate = new Translator();
    }

    public static class Translator
    extends TypeTranslator<TransactionType> {
        @Override
        public TransactionType fromParser(BinaryParser parser, Integer hint) {
            byte[] read = parser.read(2);
            return TransactionType.fromNumber(read[0] << 8 | read[1]);
        }

        @Override
        public TransactionType fromInteger(int integer) {
            return TransactionType.fromNumber(integer);
        }

        @Override
        public TransactionType fromString(String value) {
            return TransactionType.valueOf(value);
        }
    }
}

