/*
 * Decompiled with CFR 0.152.
 */
package com.jccdex.rpc.core.serialized.enums;

import com.jccdex.core.encoding.common.B16;
import com.jccdex.core.serialized.BytesSink;
import com.jccdex.rpc.core.fields.Type;
import com.jccdex.rpc.core.serialized.BinaryParser;
import com.jccdex.rpc.core.serialized.SerializedType;
import com.jccdex.rpc.core.serialized.TypeTranslator;
import java.util.TreeMap;

public enum LedgerEntryType implements SerializedType
{
    Invalid(-1),
    AccountRoot(97),
    DirectoryNode(100),
    GeneratorMap(103),
    RippleState(114),
    SuspendedPayment(117),
    Offer(111),
    Contract(99),
    LedgerHashes(104),
    Amendments(102),
    FeeSettings(115),
    Ticket(84),
    SignerList(83);

    final int ord;
    private static TreeMap<Integer, LedgerEntryType> byCode;
    public static Translator translate;

    private LedgerEntryType(int i) {
        this.ord = i;
    }

    @Override
    public Type type() {
        return Type.UInt16;
    }

    public static LedgerEntryType fromNumber(Number i) {
        return byCode.get(i.intValue());
    }

    public Integer asInteger() {
        return this.ord;
    }

    @Override
    public byte[] toBytes() {
        return new byte[]{(byte)(this.ord >>> 8 & 0xFF), (byte)(this.ord & 0xFF)};
    }

    @Override
    public Object toJSON() {
        return this.toString();
    }

    @Override
    public String toHex() {
        return B16.toString((byte[])this.toBytes());
    }

    @Override
    public void toBytesSink(BytesSink to) {
        to.add(this.toBytes());
    }

    static {
        byCode = new TreeMap();
        LedgerEntryType[] ledgerEntryTypeArray = LedgerEntryType.values();
        int n = ledgerEntryTypeArray.length;
        for (int i = 0; i < n; ++i) {
            LedgerEntryType a;
            LedgerEntryType f = a = ledgerEntryTypeArray[i];
            byCode.put(f.ord, f);
        }
        translate = new Translator();
    }

    public static class Translator
    extends TypeTranslator<LedgerEntryType> {
        @Override
        public LedgerEntryType fromParser(BinaryParser parser, Integer hint) {
            return LedgerEntryType.fromNumber(parser.readOneInt() << 8 | parser.readOneInt());
        }

        @Override
        public LedgerEntryType fromInteger(int integer) {
            return LedgerEntryType.fromNumber(integer);
        }

        @Override
        public LedgerEntryType fromString(String value) {
            return LedgerEntryType.valueOf(value);
        }
    }
}

