/*
 * Decompiled with CFR 0.152.
 */
package com.jccdex.rpc.core.serialized;

import com.jccdex.core.serialized.BytesSink;
import java.security.MessageDigest;
import java.util.ArrayList;

public class BytesList
implements BytesSink {
    private ArrayList<byte[]> buffer = new ArrayList();
    private int len = 0;
    public static String[] hexLookup = new String[256];

    public void add(BytesList bl) {
        for (byte[] bytes : bl.rawList()) {
            this.add(bytes);
        }
    }

    public void add(byte aByte) {
        this.add(new byte[]{aByte});
    }

    public void add(byte[] bytes) {
        this.len += bytes.length;
        this.buffer.add(bytes);
    }

    public byte[] bytes() {
        int n = this.bytesLength();
        byte[] bytes = new byte[n];
        this.addBytes(bytes, 0);
        return bytes;
    }

    public String bytesHex() {
        StringBuilder builder = new StringBuilder(this.len * 2);
        for (byte[] buf : this.buffer) {
            for (byte aBytes : buf) {
                builder.append(hexLookup[aBytes & 0xFF]);
            }
        }
        return builder.toString();
    }

    private int addBytes(byte[] bytes, int destPos) {
        for (byte[] buf : this.buffer) {
            System.arraycopy(buf, 0, bytes, destPos, buf.length);
            destPos += buf.length;
        }
        return destPos;
    }

    public void updateDigest(MessageDigest digest) {
        for (byte[] buf : this.buffer) {
            digest.update(buf);
        }
    }

    public int bytesLength() {
        return this.len;
    }

    public ArrayList<byte[]> rawList() {
        return this.buffer;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            String s = Integer.toHexString(i).toUpperCase();
            if (s.length() == 1) {
                s = "0" + s;
            }
            BytesList.hexLookup[i] = s;
        }
    }
}

