/*
 * Decompiled with CFR 0.152.
 */
package com.jccdex.rpc.core.coretypes.hash;

import com.jccdex.core.serialized.BytesSink;
import com.jccdex.rpc.core.coretypes.hash.HalfSha512;
import com.jccdex.rpc.core.coretypes.hash.Hash;
import com.jccdex.rpc.core.coretypes.hash.prefixes.HashPrefix;
import com.jccdex.rpc.core.coretypes.hash.prefixes.Prefix;
import com.jccdex.rpc.core.fields.Field;
import com.jccdex.rpc.core.fields.Hash256Field;
import com.jccdex.rpc.core.fields.Type;
import java.math.BigInteger;
import java.util.TreeMap;

public class Hash256
extends Hash<Hash256> {
    public static final BigInteger bookBaseSize = new BigInteger("10000000000000000", 16);
    public static final Hash256 ZERO_256 = new Hash256(new byte[32]);
    public static Translator translate = new Translator();
    public static Hash256Field LedgerHash = Hash256.hash256Field(Field.LedgerHash);
    public static Hash256Field ParentHash = Hash256.hash256Field(Field.ParentHash);
    public static Hash256Field TransactionHash = Hash256.hash256Field(Field.TransactionHash);
    public static Hash256Field AccountHash = Hash256.hash256Field(Field.AccountHash);
    public static Hash256Field PreviousTxnID = Hash256.hash256Field(Field.PreviousTxnID);
    public static Hash256Field AccountTxnID = Hash256.hash256Field(Field.AccountTxnID);
    public static Hash256Field LedgerIndex = Hash256.hash256Field(Field.LedgerIndex);
    public static Hash256Field WalletLocator = Hash256.hash256Field(Field.WalletLocator);
    public static Hash256Field RootIndex = Hash256.hash256Field(Field.RootIndex);
    public static Hash256Field BookDirectory = Hash256.hash256Field(Field.BookDirectory);
    public static Hash256Field InvoiceID = Hash256.hash256Field(Field.InvoiceID);
    public static Hash256Field Nickname = Hash256.hash256Field(Field.Nickname);
    public static Hash256Field Amendment = Hash256.hash256Field(Field.Amendment);
    public static Hash256Field TicketID = Hash256.hash256Field(Field.TicketID);
    public static Hash256Field hash = Hash256.hash256Field(Field.hash);
    public static Hash256Field index = Hash256.hash256Field(Field.index);

    public int divergenceDepth(Hash256 other) {
        return this.divergenceDepth(0, other);
    }

    public int divergenceDepth(int i, Hash256 other) {
        while (i < 64 && this.nibblet(i) == other.nibblet(i)) {
            ++i;
        }
        return i;
    }

    @Override
    public Object toJSON() {
        return translate.toJSON(this);
    }

    @Override
    public byte[] toBytes() {
        return translate.toBytes(this);
    }

    @Override
    public String toHex() {
        return translate.toHex(this);
    }

    @Override
    public void toBytesSink(BytesSink to) {
        translate.toBytesSink(this, to);
    }

    @Override
    public Type type() {
        return Type.Hash256;
    }

    public boolean isZero() {
        return this == ZERO_256 || this.equals(ZERO_256);
    }

    public boolean isNonZero() {
        return !this.isZero();
    }

    public static Hash256 fromHex(String s) {
        return (Hash256)translate.fromHex(s);
    }

    public Hash256(byte[] bytes) {
        super(bytes, 32);
    }

    public static Hash256 signingHash(byte[] blob) {
        return Hash256.prefixedHalfSha512(HashPrefix.txSign, blob);
    }

    public static Hash256 prefixedHalfSha512(Prefix prefix, byte[] blob) {
        HalfSha512 messageDigest = HalfSha512.prefixed256(prefix);
        messageDigest.update(blob);
        return messageDigest.finish();
    }

    public int nibblet(int depth) {
        int byte_ix = depth > 0 ? depth / 2 : 0;
        int b = ((Hash)this).hash[byte_ix];
        b = depth % 2 == 0 ? (b & 0xF0) >> 4 : (b &= 0xF);
        return b;
    }

    public static Hash256Field hash256Field(final Field f) {
        return new Hash256Field(){

            @Override
            public Field getField() {
                return f;
            }
        };
    }

    public static class Translator
    extends Hash.HashTranslator<Hash256> {
        @Override
        public Hash256 newInstance(byte[] b) {
            return new Hash256(b);
        }

        @Override
        public int byteWidth() {
            return 32;
        }
    }

    public static class Hash256Map<Value>
    extends TreeMap<Hash256, Value> {
        public Hash256Map(Hash256Map<Value> cache) {
            super(cache);
        }

        public Hash256Map() {
        }
    }
}

