/*
 * Decompiled with CFR 0.152.
 */
package com.jccdex.rpc.core.coretypes;

import com.jccdex.rpc.config.Config;
import com.jccdex.rpc.core.coretypes.AccountID;
import com.jccdex.rpc.core.coretypes.Amount;
import com.jccdex.rpc.core.coretypes.Currency;
import com.jccdex.rpc.core.coretypes.hash.Hash160;
import java.math.BigDecimal;
import org.json.JSONObject;

public class Issue
implements Comparable<Issue> {
    public static final Issue SWT = Issue.fromString(Config.CURRENCY);
    final Currency currency;
    final AccountID issuer;

    public Issue(Currency currency, AccountID issuer) {
        this.currency = currency;
        this.issuer = issuer;
    }

    public static Issue fromString(String pair) {
        String[] split = pair.split("/");
        return Issue.fromStringPair(split);
    }

    private static Issue fromStringPair(String[] split) {
        if (split.length == 2) {
            return new Issue(Currency.fromString(split[0]), AccountID.fromString(split[1]));
        }
        if (split[0].equals(Config.CURRENCY)) {
            return new Issue(Currency.SWT, AccountID.SWT_ISSUER);
        }
        throw new RuntimeException("Issue string must be XRP or $currency/$issuer");
    }

    public static Issue from160s(Hash160 currency, Hash160 issuer) {
        return new Issue(new Currency(currency.bytes()), new AccountID(issuer.toBytes()));
    }

    public Currency currency() {
        return this.currency;
    }

    public AccountID issuer() {
        return this.issuer;
    }

    public String toString() {
        if (this.isNative()) {
            return "XRP";
        }
        return String.format("%s/%s", this.currency, this.issuer);
    }

    public JSONObject toJSON() {
        JSONObject o = new JSONObject();
        o.put("currency", (Object)this.currency);
        if (!this.isNative()) {
            o.put("issuer", (Object)this.issuer);
        }
        return o;
    }

    public Amount amount(BigDecimal value) {
        return new Amount(value, this.currency, this.issuer, this.isNative());
    }

    public boolean isNative() {
        return this == SWT || this.currency.equals(Currency.SWT);
    }

    public Amount amount(Number value) {
        return new Amount(BigDecimal.valueOf(value.doubleValue()), this.currency, this.issuer, this.isNative());
    }

    @Override
    public int compareTo(Issue o) {
        int ret = this.issuer.compareTo(o.issuer);
        if (ret != 0) {
            return ret;
        }
        ret = this.currency.compareTo(o.currency);
        return ret;
    }

    public Amount roundedAmount(BigDecimal amount) {
        return this.amount(Amount.roundValue(amount, this.isNative()));
    }
}

