/*
 * Decompiled with CFR 0.152.
 */
package com.jccdex.rpc.utils;

import com.jccdex.core.client.Wallet;
import com.jccdex.rpc.client.bean.AmountInfo;
import com.jccdex.rpc.config.Config;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class CheckUtils {
    public static final String CURRENCY_RE = "(([a-zA-Z0-9]{3,6})|([A-F0-9]{40}))";
    public static Pattern pattern = Pattern.compile("(([a-zA-Z0-9]{3,6})|([A-F0-9]{40}))");

    public static boolean isValidAddress(String address) {
        if (StringUtils.isNotEmpty((CharSequence)address)) {
            return Wallet.isValidAddress((String)address);
        }
        return false;
    }

    public static boolean isValidAmount(AmountInfo amount) {
        if (StringUtils.isBlank((CharSequence)amount.getCurrency()) || !pattern.matcher(amount.getCurrency()).find()) {
            return false;
        }
        if (amount.getCurrency().equals(Config.CURRENCY) && StringUtils.isNotBlank((CharSequence)amount.getIssuer())) {
            return false;
        }
        return amount.getCurrency().equals(Config.CURRENCY) || Wallet.isValidAddress((String)amount.getIssuer());
    }

    public static boolean isValidAmountValue(String value) {
        return true;
    }

    public static boolean isValidType(String type, String value) {
        if (StringUtils.isEmpty((CharSequence)type) || StringUtils.isEmpty((CharSequence)value)) {
            return false;
        }
        Object[] offer_types = new String[]{"Sell", "Buy"};
        Object[] relation_types = new String[]{"trust", "authorize", "freeze", "unfreeze"};
        Object[] accountSet_types = new String[]{"property", "delegate", "signer"};
        boolean flag = false;
        switch (type) {
            case "relation": {
                if (!ArrayUtils.contains((Object[])relation_types, (Object)value)) break;
                flag = true;
                break;
            }
            case "offer": {
                if (!ArrayUtils.contains((Object[])offer_types, (Object)value)) break;
                flag = true;
                break;
            }
            case "accountSet": {
                if (!ArrayUtils.contains((Object[])accountSet_types, (Object)value)) break;
                flag = true;
                break;
            }
        }
        return flag;
    }

    public static String prepareFlag(Number flag) {
        return "";
    }

    public static boolean isNumeric(String ledger_index) {
        Pattern pattern;
        Matcher isNum;
        return !StringUtils.isNotEmpty((CharSequence)ledger_index) || (isNum = (pattern = Pattern.compile("[0-9]*")).matcher(ledger_index)).matches();
    }

    public static boolean isValidHash(String ledger_hash) {
        if (StringUtils.isNotEmpty((CharSequence)ledger_hash)) {
            // empty if block
        }
        return true;
    }
}

