/*
 * Decompiled with CFR 0.152.
 */
package com.jccdex.rpc.encoding.base58;

import com.jccdex.rpc.encoding.base58.EncodingFormatException;
import com.jccdex.rpc.utils.HashUtils;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.Arrays;

public class B58 {
    private int[] mIndexes;
    private char[] mAlphabet;

    public B58(String alphabet) {
        this.setAlphabet(alphabet);
        this.buildIndexes();
    }

    public byte[] findPrefix(int payLoadLength, String desiredPrefix) {
        int totalLength = payLoadLength + 4;
        double chars = Math.log(Math.pow(256.0, totalLength)) / Math.log(58.0);
        int requiredChars = (int)Math.ceil(chars + 0.2);
        int charPos = this.mAlphabet.length / 2 - 1;
        char padding = this.mAlphabet[charPos];
        String template = desiredPrefix + B58.repeat(requiredChars, padding);
        byte[] decoded = this.decode(template);
        return this.copyOfRange(decoded, 0, decoded.length - totalLength);
    }

    private static String repeat(int times, char repeated) {
        char[] chars = new char[times];
        Arrays.fill(chars, repeated);
        return new String(chars);
    }

    private void setAlphabet(String alphabet) {
        this.mAlphabet = alphabet.toCharArray();
    }

    private void buildIndexes() {
        int i;
        this.mIndexes = new int[128];
        for (i = 0; i < this.mIndexes.length; ++i) {
            this.mIndexes[i] = -1;
        }
        for (i = 0; i < this.mAlphabet.length; ++i) {
            this.mIndexes[this.mAlphabet[i]] = i;
        }
    }

    public String encodeToStringChecked(byte[] input, int version) {
        return this.encodeToStringChecked(input, new byte[]{(byte)version});
    }

    public String encodeToStringChecked(byte[] input, byte[] version) {
        try {
            return new String(this.encodeToBytesChecked(input, version), "US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] encodeToBytesChecked(byte[] input, int version) {
        return this.encodeToBytesChecked(input, new byte[]{(byte)version});
    }

    public byte[] encodeToBytesChecked(byte[] input, byte[] version) {
        byte[] buffer = new byte[input.length + version.length];
        System.arraycopy(version, 0, buffer, 0, version.length);
        System.arraycopy(input, 0, buffer, version.length, input.length);
        byte[] checkSum = this.copyOfRange(HashUtils.doubleDigest(buffer), 0, 4);
        byte[] output = new byte[buffer.length + checkSum.length];
        System.arraycopy(buffer, 0, output, 0, buffer.length);
        System.arraycopy(checkSum, 0, output, buffer.length, checkSum.length);
        return this.encodeToBytes(output);
    }

    public String encodeToString(byte[] input) {
        byte[] output = this.encodeToBytes(input);
        try {
            return new String(output, "US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] encodeToBytes(byte[] input) {
        int zeroCount;
        if (input.length == 0) {
            return new byte[0];
        }
        input = this.copyOfRange(input, 0, input.length);
        for (zeroCount = 0; zeroCount < input.length && input[zeroCount] == 0; ++zeroCount) {
        }
        byte[] temp = new byte[input.length * 2];
        int j = temp.length;
        int startAt = zeroCount;
        while (startAt < input.length) {
            byte mod = this.divmod58(input, startAt);
            if (input[startAt] == 0) {
                ++startAt;
            }
            temp[--j] = (byte)this.mAlphabet[mod];
        }
        while (j < temp.length && temp[j] == this.mAlphabet[0]) {
            ++j;
        }
        while (--zeroCount >= 0) {
            temp[--j] = (byte)this.mAlphabet[0];
        }
        byte[] output = this.copyOfRange(temp, j, temp.length);
        return output;
    }

    public byte[] decode(String input) throws EncodingFormatException {
        int zeroCount;
        if (input.length() == 0) {
            return new byte[0];
        }
        byte[] input58 = new byte[input.length()];
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            int digit58 = -1;
            if (c >= '\u0000' && c < '\u0080') {
                digit58 = this.mIndexes[c];
            }
            if (digit58 < 0) {
                throw new EncodingFormatException("Illegal character " + c + " at " + i);
            }
            input58[i] = (byte)digit58;
        }
        for (zeroCount = 0; zeroCount < input58.length && input58[zeroCount] == 0; ++zeroCount) {
        }
        byte[] temp = new byte[input.length()];
        int j = temp.length;
        int startAt = zeroCount;
        while (startAt < input58.length) {
            byte mod = this.divmod256(input58, startAt);
            if (input58[startAt] == 0) {
                ++startAt;
            }
            temp[--j] = mod;
        }
        while (j < temp.length && temp[j] == 0) {
            ++j;
        }
        return this.copyOfRange(temp, j - zeroCount, temp.length);
    }

    public BigInteger decodeToBigInteger(String input) throws EncodingFormatException {
        return new BigInteger(1, this.decode(input));
    }

    public byte[] decodeChecked(String input, int version) throws EncodingFormatException {
        byte[] buffer = this.decodeAndCheck(input);
        byte actualVersion = buffer[0];
        if (actualVersion != version) {
            throw new EncodingFormatException("Bro, version is wrong yo");
        }
        return this.copyOfRange(buffer, 1, buffer.length - 4);
    }

    public Decoded decodeMulti(String input, int expectedLength, byte[] ... possibleVersions) throws EncodingFormatException {
        byte[] buffer = this.decodeAndCheck(input);
        int versionLength = buffer.length - 4 - expectedLength;
        byte[] versionBytes = this.copyOfRange(buffer, 0, versionLength);
        byte[] foundVersion = null;
        for (byte[] possible : possibleVersions) {
            if (!Arrays.equals(possible, versionBytes)) continue;
            foundVersion = possible;
            break;
        }
        if (foundVersion == null) {
            throw new EncodingFormatException("Bro, version is wrong yo");
        }
        byte[] bytes = this.copyOfRange(buffer, versionLength, buffer.length - 4);
        return new Decoded(foundVersion, bytes);
    }

    private byte[] decodeAndCheck(String input) {
        byte[] buffer = this.decode(input);
        if (buffer.length < 4) {
            throw new EncodingFormatException("Input too short");
        }
        byte[] toHash = this.copyOfRange(buffer, 0, buffer.length - 4);
        byte[] hashed = this.copyOfRange(HashUtils.doubleDigest(toHash), 0, 4);
        byte[] checksum = this.copyOfRange(buffer, buffer.length - 4, buffer.length);
        return buffer;
    }

    private byte divmod58(byte[] number, int startAt) {
        int remainder = 0;
        for (int i = startAt; i < number.length; ++i) {
            int digit256 = number[i] & 0xFF;
            int temp = remainder * 256 + digit256;
            number[i] = (byte)(temp / 58);
            remainder = temp % 58;
        }
        return (byte)remainder;
    }

    private byte divmod256(byte[] number58, int startAt) {
        int remainder = 0;
        for (int i = startAt; i < number58.length; ++i) {
            int digit58 = number58[i] & 0xFF;
            int temp = remainder * 58 + digit58;
            number58[i] = (byte)(temp / 256);
            remainder = temp % 256;
        }
        return (byte)remainder;
    }

    private byte[] copyOfRange(byte[] source, int from, int to) {
        byte[] range = new byte[to - from];
        System.arraycopy(source, from, range, 0, range.length);
        return range;
    }

    public static class Decoded {
        public final byte[] version;
        public final byte[] payload;

        public Decoded(byte[] version, byte[] payload) {
            this.version = version;
            this.payload = payload;
        }
    }
}

