/*
 * Decompiled with CFR 0.152.
 */
package com.jccdex.rpc.crypto.ecdsa;

import com.jccdex.rpc.config.Config;
import com.jccdex.rpc.crypto.ecdsa.EDKeyPair;
import com.jccdex.rpc.crypto.ecdsa.IKeyPair;
import com.jccdex.rpc.crypto.ecdsa.K256KeyPair;
import com.jccdex.rpc.encoding.base58.B58;
import com.jccdex.rpc.utils.Sha512;
import com.jccdex.rpc.utils.Utils;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Random;

public class Seed {
    public static byte[] VER_K256 = new byte[]{33};
    public static byte[] VER_ED25519 = new byte[]{1, -31, 75};
    final byte[] seedBytes;
    byte[] version;

    public Seed(byte[] seedBytes) {
        this(VER_K256, seedBytes);
    }

    public Seed(byte[] version, byte[] seedBytes) {
        this.seedBytes = seedBytes;
        this.version = version;
    }

    public String toString() {
        return Config.getB58().encodeToStringChecked(this.seedBytes, this.version);
    }

    public byte[] bytes() {
        return this.seedBytes;
    }

    public byte[] version() {
        return this.version;
    }

    public Seed setEd25519() {
        this.version = VER_ED25519;
        return this;
    }

    public IKeyPair keyPair() {
        return this.keyPair(0);
    }

    public IKeyPair rootKeyPair() {
        return this.keyPair(-1);
    }

    public IKeyPair keyPair(int account) {
        if (Arrays.equals(this.version, VER_ED25519)) {
            if (account != 0) {
                throw new AssertionError();
            }
            return EDKeyPair.from128Seed(this.seedBytes);
        }
        return Seed.createKeyPair(this.seedBytes, account);
    }

    public static Seed fromBase58(String b58) {
        B58.Decoded decoded = Config.getB58().decodeMulti(b58, 16, VER_K256, VER_ED25519);
        return new Seed(decoded.version, decoded.payload);
    }

    public static Seed fromPassPhrase(String passPhrase) {
        return new Seed(Seed.passPhraseToSeedBytes(passPhrase));
    }

    public static byte[] passPhraseToSeedBytes(String phrase) {
        try {
            return new Sha512(phrase.getBytes("utf-8")).finish128();
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static IKeyPair createKeyPair(byte[] seedBytes) {
        return Seed.createKeyPair(seedBytes, 0);
    }

    public static IKeyPair createKeyPair(byte[] seedBytes, int accountNumber) {
        BigInteger privateGen = K256KeyPair.computePrivateGen(seedBytes);
        byte[] publicGenBytes = K256KeyPair.computePublicGenerator(privateGen);
        if (accountNumber == -1) {
            return new K256KeyPair(privateGen, Utils.uBigInt(publicGenBytes));
        }
        BigInteger secret = K256KeyPair.computeSecretKey(privateGen, publicGenBytes, accountNumber);
        BigInteger pub = K256KeyPair.computePublicKey(secret);
        return new K256KeyPair(secret, pub);
    }

    public static IKeyPair getKeyPair(byte[] seedBytes) {
        return Seed.createKeyPair(seedBytes, 0);
    }

    public static IKeyPair getKeyPair(String b58) {
        return Seed.getKeyPair(Config.getB58IdentiferCodecs().decodeFamilySeed(b58));
    }

    public static String random() {
        byte[] randBytes = new byte[16];
        Random random = new Random();
        random.nextBytes(randBytes);
        byte[] bytes = new byte[randBytes.length + 1];
        bytes[0] = (byte)Config.SEED_PREFIX;
        System.arraycopy(randBytes, 0, bytes, 1, randBytes.length);
        byte[] sha256 = null;
        try {
            sha256 = MessageDigest.getInstance("SHA-256").digest(bytes);
            sha256 = MessageDigest.getInstance("SHA-256").digest(sha256);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        byte[] checksum = Arrays.copyOf(sha256, 4);
        byte[] ret = new byte[bytes.length + checksum.length];
        System.arraycopy(bytes, 0, ret, 0, bytes.length);
        System.arraycopy(checksum, 0, ret, bytes.length, checksum.length);
        return Config.getB58().encodeToString(ret);
    }
}

