/*
 * Decompiled with CFR 0.152.
 */
package com.jccdex.rpc.crypto.ecdsa;

import com.jccdex.rpc.crypto.ecdsa.SECP256K1;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.DERSequenceGenerator;
import org.bouncycastle.asn1.DLSequence;

public class ECDSASignature {
    public BigInteger r;
    public BigInteger s;

    public ECDSASignature(BigInteger r, BigInteger s) {
        this.r = r;
        this.s = s;
    }

    public static boolean isStrictlyCanonical(byte[] sig) {
        return ECDSASignature.checkIsCanonical(sig, true);
    }

    public static boolean checkIsCanonical(byte[] sig, boolean strict) {
        int sigLen = sig.length;
        if (sigLen < 8 || sigLen > 72) {
            return false;
        }
        if (sig[0] != 48 || sig[1] != sigLen - 2) {
            return false;
        }
        int rPos = 4;
        byte rLen = sig[rPos - 1];
        if (rLen < 1 || rLen > 33 || rLen + 7 > sigLen) {
            return false;
        }
        int sPos = rLen + 6;
        byte sLen = sig[sPos - 1];
        if (sLen < 1 || sLen > 33 || rLen + sLen + 6 != sigLen) {
            return false;
        }
        if (sig[rPos - 2] != 2 || sig[sPos - 2] != 2) {
            return false;
        }
        if ((sig[rPos] & 0x80) != 0) {
            return false;
        }
        if (sig[rPos] == 0 && rLen == 1) {
            return false;
        }
        if (sig[rPos] == 0 && (sig[rPos + 1] & 0x80) == 0) {
            return false;
        }
        if ((sig[sPos] & 0x80) != 0) {
            return false;
        }
        if (sig[sPos] == 0 && sLen == 1) {
            return false;
        }
        if (sig[sPos] == 0 && (sig[sPos + 1] & 0x80) == 0) {
            return false;
        }
        byte[] rBytes = new byte[rLen];
        byte[] sBytes = new byte[sLen];
        System.arraycopy(sig, rPos, rBytes, 0, rLen);
        System.arraycopy(sig, sPos, sBytes, 0, sLen);
        BigInteger r = new BigInteger(1, rBytes);
        BigInteger s = new BigInteger(1, sBytes);
        BigInteger order = SECP256K1.order();
        if (r.compareTo(order) != -1 || s.compareTo(order) != -1) {
            return false;
        }
        if (strict) {
            return order.subtract(s).compareTo(s) != -1;
        }
        return true;
    }

    public byte[] encodeToDER() {
        try {
            return this.derByteStream().toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ECDSASignature decodeFromDER(byte[] bytes) {
        ASN1Integer s;
        ASN1Integer r;
        ASN1InputStream decoder = new ASN1InputStream(bytes);
        DLSequence seq = (DLSequence)decoder.readObject();
        try {
            r = (ASN1Integer)seq.getObjectAt(0);
            s = (ASN1Integer)seq.getObjectAt(1);
        }
        catch (ClassCastException e) {
            ECDSASignature eCDSASignature;
            try {
                eCDSASignature = null;
            }
            catch (Throwable throwable) {
                try {
                    decoder.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
            }
            decoder.close();
            return eCDSASignature;
        }
        decoder.close();
        return new ECDSASignature(r.getPositiveValue(), s.getPositiveValue());
    }

    protected ByteArrayOutputStream derByteStream() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(72);
        DERSequenceGenerator seq = new DERSequenceGenerator((OutputStream)bos);
        seq.addObject((ASN1Encodable)new ASN1Integer(this.r));
        seq.addObject((ASN1Encodable)new ASN1Integer(this.s));
        seq.close();
        return bos;
    }
}

