/*
 * Decompiled with CFR 0.152.
 */
package com.jccdex.rpc.core.types.shamap;

import com.jccdex.rpc.core.coretypes.hash.Hash256;
import com.jccdex.rpc.core.coretypes.hash.prefixes.HashPrefix;
import com.jccdex.rpc.core.coretypes.hash.prefixes.Prefix;
import com.jccdex.rpc.core.serialized.BytesSink;
import com.jccdex.rpc.core.types.shamap.HashedTreeWalker;
import com.jccdex.rpc.core.types.shamap.LeafWalker;
import com.jccdex.rpc.core.types.shamap.PathToIndex;
import com.jccdex.rpc.core.types.shamap.ShaMapItem;
import com.jccdex.rpc.core.types.shamap.ShaMapLeaf;
import com.jccdex.rpc.core.types.shamap.ShaMapNode;
import com.jccdex.rpc.core.types.shamap.TreeWalker;
import java.util.Iterator;

public class ShaMapInner
extends ShaMapNode
implements Iterable<ShaMapNode> {
    public int depth;
    int slotBits = 0;
    int version = 0;
    boolean doCoW;
    protected ShaMapNode[] branches = new ShaMapNode[16];

    public ShaMapInner(int depth) {
        this(false, depth, 0);
    }

    public ShaMapInner(boolean isCopy, int depth, int version) {
        this.doCoW = isCopy;
        this.depth = depth;
        this.version = version;
    }

    protected ShaMapInner copy(int version) {
        ShaMapInner copy = this.makeInnerOfSameClass(this.depth);
        System.arraycopy(this.branches, 0, copy.branches, 0, this.branches.length);
        copy.slotBits = this.slotBits;
        copy.hash = this.hash;
        copy.version = version;
        this.doCoW = true;
        return copy;
    }

    protected ShaMapInner makeInnerOfSameClass(int depth) {
        return new ShaMapInner(true, depth, this.version);
    }

    protected ShaMapInner makeInnerChild() {
        int childDepth = this.depth + 1;
        if (childDepth >= 64) {
            throw new AssertionError();
        }
        return new ShaMapInner(this.doCoW, childDepth, this.version);
    }

    protected void setLeaf(ShaMapLeaf leaf) {
        if (leaf.version == -1L) {
            leaf.version = this.version;
        }
        this.setBranch(leaf.index, (ShaMapNode)leaf);
    }

    private void removeBranch(Hash256 index) {
        this.removeBranch(this.selectBranch(index));
    }

    public void walkLeaves(LeafWalker leafWalker) {
        for (ShaMapNode branch : this.branches) {
            if (branch == null) continue;
            if (branch.isInner()) {
                branch.asInner().walkLeaves(leafWalker);
                continue;
            }
            if (!branch.isLeaf()) continue;
            leafWalker.onLeaf(branch.asLeaf());
        }
    }

    public void walkTree(TreeWalker treeWalker) {
        treeWalker.onInner(this);
        for (ShaMapNode branch : this.branches) {
            if (branch == null) continue;
            if (branch.isLeaf()) {
                ShaMapLeaf ln = branch.asLeaf();
                treeWalker.onLeaf(ln);
                continue;
            }
            if (!branch.isInner()) continue;
            ShaMapInner childInner = branch.asInner();
            childInner.walkTree(treeWalker);
        }
    }

    public void walkHashedTree(HashedTreeWalker walker) {
        walker.onInner(this.hash(), this);
        for (ShaMapNode branch : this.branches) {
            if (branch == null) continue;
            if (branch.isLeaf()) {
                ShaMapLeaf ln = branch.asLeaf();
                walker.onLeaf(branch.hash(), ln);
                continue;
            }
            if (!branch.isInner()) continue;
            ShaMapInner childInner = branch.asInner();
            childInner.walkHashedTree(walker);
        }
    }

    public ShaMapLeaf onlyChildLeaf() {
        ShaMapLeaf leaf = null;
        int leaves = 0;
        for (ShaMapNode branch : this.branches) {
            if (branch == null) continue;
            if (branch.isInner()) {
                leaf = null;
                break;
            }
            if (++leaves == 1) {
                leaf = branch.asLeaf();
                continue;
            }
            leaf = null;
            break;
        }
        return leaf;
    }

    public boolean removeLeaf(Hash256 index) {
        PathToIndex path = this.pathToIndex(index);
        if (path.hasMatchedLeaf()) {
            ShaMapInner top = path.dirtyOrCopyInners();
            top.removeBranch(index);
            path.collapseOnlyLeafChildInners();
            return true;
        }
        return false;
    }

    public ShaMapItem getItem(Hash256 index) {
        ShaMapLeaf leaf = this.getLeaf(index);
        ShaMapItem shaMapItem = leaf == null ? null : leaf.item;
        return shaMapItem;
    }

    public boolean addItem(Hash256 index, ShaMapItem item) {
        return this.addLeaf(new ShaMapLeaf(index, item));
    }

    public boolean updateItem(Hash256 index, ShaMapItem item) {
        return this.updateLeaf(new ShaMapLeaf(index, item));
    }

    public boolean hasLeaf(Hash256 index) {
        return this.pathToIndex(index).hasMatchedLeaf();
    }

    public ShaMapLeaf getLeaf(Hash256 index) {
        PathToIndex stack = this.pathToIndex(index);
        if (stack.hasMatchedLeaf()) {
            return stack.leaf;
        }
        return null;
    }

    public boolean addLeaf(ShaMapLeaf leaf) {
        PathToIndex stack = this.pathToIndex(leaf.index);
        if (stack.hasMatchedLeaf()) {
            return false;
        }
        ShaMapInner top = stack.dirtyOrCopyInners();
        top.addLeafToTerminalInner(leaf);
        return true;
    }

    public boolean updateLeaf(ShaMapLeaf leaf) {
        PathToIndex stack = this.pathToIndex(leaf.index);
        if (stack.hasMatchedLeaf()) {
            ShaMapInner top = stack.dirtyOrCopyInners();
            top.setLeaf(leaf);
            return true;
        }
        return false;
    }

    public PathToIndex pathToIndex(Hash256 index) {
        return new PathToIndex(this, index);
    }

    void addLeafToTerminalInner(ShaMapLeaf leaf) {
        ShaMapNode branch = this.getBranch(leaf.index);
        if (branch == null) {
            this.setLeaf(leaf);
        } else {
            if (branch.isInner()) {
                throw new AssertionError();
            }
            if (branch.isLeaf()) {
                ShaMapInner inner = this.makeInnerChild();
                this.setBranch(leaf.index, (ShaMapNode)inner);
                inner.addLeafToTerminalInner(leaf);
                inner.addLeafToTerminalInner(branch.asLeaf());
            }
        }
    }

    protected void setBranch(Hash256 index, ShaMapNode node) {
        this.setBranch(this.selectBranch(index), node);
    }

    protected ShaMapNode getBranch(Hash256 index) {
        return this.getBranch(index.nibblet(this.depth));
    }

    public ShaMapNode getBranch(int i) {
        return this.branches[i];
    }

    public ShaMapNode branch(int i) {
        return this.branches[i];
    }

    protected int selectBranch(Hash256 index) {
        return index.nibblet(this.depth);
    }

    public boolean hasLeaf(int i) {
        return this.branches[i].isLeaf();
    }

    public boolean hasInner(int i) {
        return this.branches[i].isInner();
    }

    public boolean hasNone(int i) {
        return this.branches[i] == null;
    }

    private void setBranch(int slot, ShaMapNode node) {
        this.slotBits |= 1 << slot;
        this.branches[slot] = node;
        this.invalidate();
    }

    private void removeBranch(int slot) {
        this.branches[slot] = null;
        this.slotBits &= ~(1 << slot);
    }

    public boolean empty() {
        return this.slotBits == 0;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public boolean isInner() {
        return true;
    }

    @Override
    Prefix hashPrefix() {
        return HashPrefix.innerNode;
    }

    @Override
    public void toBytesSink(BytesSink sink) {
        for (ShaMapNode branch : this.branches) {
            if (branch != null) {
                branch.hash().toBytesSink(sink);
                continue;
            }
            Hash256.ZERO_256.toBytesSink(sink);
        }
    }

    @Override
    public Hash256 hash() {
        if (this.empty()) {
            assert (this.depth == 0);
            return Hash256.ZERO_256;
        }
        return super.hash();
    }

    public ShaMapLeaf getLeafForUpdating(Hash256 leaf) {
        PathToIndex path = this.pathToIndex(leaf);
        if (path.hasMatchedLeaf()) {
            return path.invalidatedPossiblyCopiedLeafForUpdating();
        }
        return null;
    }

    @Override
    public Iterator<ShaMapNode> iterator() {
        return new Iterator<ShaMapNode>(){
            int ix = 0;

            @Override
            public boolean hasNext() {
                return this.ix != 16;
            }

            @Override
            public ShaMapNode next() {
                return ShaMapInner.this.branch(this.ix++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public int branchCount() {
        int populated = 0;
        for (ShaMapNode branch : this.branches) {
            if (branch == null) continue;
            ++populated;
        }
        return populated;
    }
}

