/*
 * Decompiled with CFR 0.152.
 */
package com.jccdex.rpc.core.types.shamap;

import com.jccdex.rpc.core.coretypes.STObject;
import com.jccdex.rpc.core.coretypes.Vector256;
import com.jccdex.rpc.core.coretypes.hash.Hash256;
import com.jccdex.rpc.core.coretypes.hash.Index;
import com.jccdex.rpc.core.coretypes.uint.UInt32;
import com.jccdex.rpc.core.types.known.sle.LedgerEntry;
import com.jccdex.rpc.core.types.known.sle.LedgerHashes;
import com.jccdex.rpc.core.types.known.sle.entries.DirectoryNode;
import com.jccdex.rpc.core.types.known.sle.entries.OfferDirectory;
import com.jccdex.rpc.core.types.shamap.LeafWalker;
import com.jccdex.rpc.core.types.shamap.LedgerEntryItem;
import com.jccdex.rpc.core.types.shamap.LedgerEntryVisitor;
import com.jccdex.rpc.core.types.shamap.PathToIndex;
import com.jccdex.rpc.core.types.shamap.ShaMap;
import com.jccdex.rpc.core.types.shamap.ShaMapInner;
import com.jccdex.rpc.core.types.shamap.ShaMapLeaf;
import com.jccdex.rpc.core.types.shamap.ShaMapNode;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.json.JSONWriter;

public class AccountState
extends ShaMap {
    public AccountState() {
    }

    public AccountState(boolean isCopy, int depth) {
        super(isCopy, depth);
    }

    @Override
    protected ShaMapInner makeInnerOfSameClass(int depth) {
        return new AccountState(true, depth);
    }

    private static LedgerHashes newSkipList(Hash256 skipIndex) {
        LedgerHashes skip = new LedgerHashes();
        skip.put(UInt32.Flags, new UInt32(0));
        skip.hashes(new Vector256());
        skip.index(skipIndex);
        return skip;
    }

    public void updateSkipLists(long currentIndex, Hash256 parentHash) {
        Vector256 hashes;
        LedgerHashes skip;
        Hash256 skipIndex;
        long prev = currentIndex - 1L;
        if ((prev & 0xFFL) == 0L) {
            skipIndex = Index.ledgerHashes(prev);
            skip = this.createOrUpdateSkipList(skipIndex);
            hashes = skip.hashes();
            assert (hashes.size() <= 256);
            hashes.add(parentHash);
            skip.put(UInt32.LastLedgerSequence, new UInt32(prev));
        }
        if ((hashes = (skip = this.createOrUpdateSkipList(skipIndex = Index.ledgerHashes())).hashes()).size() > 256) {
            throw new AssertionError();
        }
        if (hashes.size() == 256) {
            hashes.remove(0);
        }
        hashes.add(parentHash);
        skip.put(UInt32.LastLedgerSequence, new UInt32(prev));
    }

    private LedgerHashes createOrUpdateSkipList(Hash256 skipIndex) {
        LedgerEntryItem item;
        PathToIndex path = this.pathToIndex(skipIndex);
        ShaMapInner top = path.dirtyOrCopyInners();
        if (path.hasMatchedLeaf()) {
            ShaMapLeaf leaf = path.invalidatedPossiblyCopiedLeafForUpdating();
            item = (LedgerEntryItem)leaf.item;
        } else {
            item = new LedgerEntryItem(AccountState.newSkipList(skipIndex));
            top.addLeafToTerminalInner(new ShaMapLeaf(skipIndex, item));
        }
        return (LedgerHashes)item.entry;
    }

    public boolean addLE(LedgerEntry entry) {
        LedgerEntryItem item = new LedgerEntryItem(entry);
        return this.addItem(entry.index(), item);
    }

    public boolean updateLE(LedgerEntry entry) {
        LedgerEntryItem item = new LedgerEntryItem(entry);
        return this.updateItem(entry.index(), item);
    }

    public LedgerEntry getLE(Hash256 index) {
        LedgerEntryItem item = (LedgerEntryItem)this.getItem(index);
        return item == null ? null : item.value();
    }

    public DirectoryNode getDirectoryNode(Hash256 index) {
        return (DirectoryNode)this.getLE(index);
    }

    public Iterable<OfferDirectory> offerDirectories(Hash256 bookBase) {
        final QualityIterator iter = this.qualityIterator(bookBase);
        return new Iterable<OfferDirectory>(){

            @Override
            public Iterator<OfferDirectory> iterator() {
                return new Iterator<OfferDirectory>(){

                    @Override
                    public boolean hasNext() {
                        boolean hasNext = iter.hasNext();
                        if (hasNext && !(iter.next() instanceof OfferDirectory)) {
                            return this.hasNext();
                        }
                        return hasNext;
                    }

                    @Override
                    public OfferDirectory next() {
                        return (OfferDirectory)iter.next();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public void writeEntriesArray(final JSONWriter writer) {
        writer.array();
        this.walkEntries(new LedgerEntryVisitor(){

            @Override
            public void onEntry(LedgerEntry entry) {
                writer.value(entry.toJSON());
            }
        });
        writer.endArray();
    }

    public QualityIterator qualityIterator(Hash256 bookBase) {
        return new QualityIterator(bookBase);
    }

    public Iterable<Hash256> directoryIterator(OfferDirectory forQuality) {
        Vector256 indexes = new Vector256();
        OfferDirectory cursor = forQuality;
        while (cursor != null) {
            LedgerEntry le;
            indexes.addAll(cursor.indexes());
            if (!cursor.hasNextIndex() || !((le = this.getLE(cursor.nextIndex())) instanceof OfferDirectory)) break;
            cursor = (OfferDirectory)le;
        }
        return indexes;
    }

    public void walkEntries(final LedgerEntryVisitor walker) {
        this.walkLeaves(new LeafWalker(){

            @Override
            public void onLeaf(ShaMapLeaf leaf) {
                LedgerEntryItem item = (LedgerEntryItem)leaf.item;
                walker.onEntry(item.entry);
            }
        });
    }

    public Hash256 getNextIndex(Hash256 nextIndex, Hash256 bookEnd) {
        return null;
    }

    @Override
    public AccountState copy() {
        return (AccountState)super.copy();
    }

    public static AccountState loadFromLedgerDump(String filePath) throws IOException {
        FileReader reader = new FileReader(filePath);
        JSONTokener tokenizer = new JSONTokener((Reader)reader);
        JSONObject ledger = new JSONObject(tokenizer);
        if (ledger.has("result")) {
            ledger = ledger.getJSONObject("result");
        }
        if (ledger.has("ledger")) {
            ledger = ledger.getJSONObject("ledger");
        }
        JSONArray array = ledger.getJSONArray("accountState");
        reader.close();
        return AccountState.parseShaMap(array);
    }

    public static AccountState parseShaMap(JSONArray array) {
        AccountState map = new AccountState();
        for (int i = 0; i < array.length(); ++i) {
            JSONObject jsonItem = array.getJSONObject(i);
            map.addLE((LedgerEntry)STObject.fromJSONObject(jsonItem));
        }
        return map;
    }

    public class QualityIterator
    implements Iterator<LedgerEntry> {
        ShaMapInner[] inners = new ShaMapInner[64];
        Hash256 base;
        Hash256 end;
        int[] selections = new int[64];
        int commonNibblets;
        int depth;
        ShaMapLeaf next;
        private boolean finished = false;

        public QualityIterator(Hash256 start) {
            this.base = start;
            this.depth = 0;
            this.end = Index.bookEnd(start);
            AccountState inner = AccountState.this;
            this.setInner(inner);
            this.setSelected(start.nibblet(this.depth));
            this.findCommonNibblets();
        }

        private void findCommonNibblets() {
            int i = 0;
            while (i < 64 && this.base.nibblet(i) == this.end.nibblet(i)) {
                this.commonNibblets = i++;
            }
        }

        private void setInner(ShaMapInner inner) {
            this.inners[this.depth] = inner;
        }

        private void findNext() {
            block7: {
                boolean leafIsOnPathToBase;
                ShaMapNode branch;
                this.next = null;
                while (true) {
                    if (this.selected() > 15) {
                        --this.depth;
                        this.incrementSelection();
                        continue;
                    }
                    if (this.depth < this.commonNibblets && this.selected() > this.end.nibblet(this.depth)) {
                        this.finished = true;
                        break block7;
                    }
                    ShaMapInner current = this.currentInner();
                    branch = current.getBranch(this.selected());
                    if (branch == null) {
                        this.incrementSelection();
                        continue;
                    }
                    if (branch.isInner()) {
                        ++this.depth;
                        this.setInner(branch.asInner());
                        this.setSelected(this.base.nibblet(this.depth));
                        continue;
                    }
                    if (branch.isLeaf()) break;
                }
                ShaMapLeaf leaf = branch.asLeaf();
                Hash256 leafIndex = leaf.index;
                boolean bl = leafIsOnPathToBase = this.depth < this.commonNibblets;
                if (leafIsOnPathToBase || leafIndex.compareTo(this.base) > 0 && leafIndex.compareTo(this.end) < 0) {
                    this.next = leaf;
                    this.incrementSelection();
                } else {
                    this.finished = true;
                }
            }
        }

        private ShaMapInner currentInner() {
            return this.inners[this.depth];
        }

        private int selected() {
            return this.selections[this.depth];
        }

        private void setSelected(int nibblet) {
            this.selections[this.depth] = nibblet;
        }

        private void incrementSelection() {
            int n = this.depth;
            this.selections[n] = this.selections[n] + 1;
        }

        @Override
        public boolean hasNext() {
            this.findNext();
            return !this.finished && this.next != null;
        }

        @Override
        public LedgerEntry next() {
            LedgerEntryItem item = (LedgerEntryItem)this.next.item;
            return item.entry;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

