/*
 * Decompiled with CFR 0.152.
 */
package com.jccdex.rpc.core.types.known.tx.result;

import com.jccdex.rpc.core.coretypes.STObject;
import com.jccdex.rpc.core.coretypes.hash.Hash256;
import com.jccdex.rpc.core.fields.Field;
import com.jccdex.rpc.core.serialized.SerializedType;
import com.jccdex.rpc.core.serialized.enums.LedgerEntryType;
import com.jccdex.rpc.core.types.known.sle.LedgerEntry;

public class AffectedNode
extends STObject {
    public final Field field;
    public final STObject nested;

    public AffectedNode(STObject source) {
        this.fields = source.getFields();
        this.field = this.getField();
        this.nested = this.nestedObject();
    }

    public boolean isOffer() {
        return this.ledgerEntryType() == LedgerEntryType.Offer;
    }

    public boolean isAccountRoot() {
        return this.ledgerEntryType() == LedgerEntryType.AccountRoot;
    }

    public boolean isRippleState() {
        return this.ledgerEntryType() == LedgerEntryType.RippleState;
    }

    public boolean isDirectoryNode() {
        return this.ledgerEntryType() == LedgerEntryType.DirectoryNode;
    }

    public boolean wasPreviousNode() {
        return this.isDeletedNode() || this.isModifiedNode();
    }

    public boolean isFinalNode() {
        return true;
    }

    public boolean isCreatedNode() {
        return this.field == Field.CreatedNode;
    }

    public boolean isDeletedNode() {
        return this.field == Field.DeletedNode;
    }

    public boolean isModifiedNode() {
        return this.field == Field.ModifiedNode;
    }

    public Field getField() {
        return (Field)((Object)this.fields.firstKey());
    }

    public Hash256 ledgerIndex() {
        return this.nested.get(Hash256.LedgerIndex);
    }

    public LedgerEntryType ledgerEntryType() {
        return AffectedNode.ledgerEntryType(this.nested);
    }

    private STObject nestedObject() {
        return (STObject)this.get(this.getField());
    }

    public LedgerEntry nodeAsPrevious() {
        return (LedgerEntry)this.rebuildFromMeta(true);
    }

    public LedgerEntry nodeAsFinal() {
        return (LedgerEntry)this.rebuildFromMeta(false);
    }

    private STObject rebuildFromMeta(boolean layerPrevious) {
        Field finalFields;
        STObject mixed = new STObject();
        boolean created = this.isCreatedNode();
        Field wrapperField = created ? Field.CreatedNode : (this.isDeletedNode() ? Field.DeletedNode : Field.ModifiedNode);
        STObject wrapped = (STObject)this.get(wrapperField);
        Field field = finalFields = created ? Field.NewFields : Field.FinalFields;
        if (!wrapped.has(finalFields)) {
            STObject source = new STObject(wrapped.getFields());
            source.put(Hash256.index, wrapped.get(Hash256.LedgerIndex));
            return STObject.formatted(source);
        }
        STObject finals = (STObject)wrapped.get(finalFields);
        for (Field field2 : finals) {
            mixed.put(field2, finals.get(field2));
        }
        if (layerPrevious && wrapped.has(Field.PreviousFields)) {
            STObject previous = wrapped.get(STObject.PreviousFields);
            STObject changed = new STObject();
            mixed.put(Field.FinalFields, (SerializedType)changed);
            for (Field field3 : previous) {
                mixed.put(field3, previous.get(field3));
                changed.put(field3, finals.get(field3));
            }
        }
        block5: for (Field field2 : wrapped) {
            switch (field2) {
                case NewFields: 
                case PreviousFields: 
                case FinalFields: {
                    continue block5;
                }
            }
            SerializedType value = wrapped.get(field2);
            if (field2 == Field.LedgerIndex) {
                field2 = Field.index;
            }
            mixed.put(field2, value);
        }
        return STObject.formatted(mixed);
    }

    public static boolean isAffectedNode(STObject source) {
        return source.size() == 1 && (source.has(DeletedNode) || source.has(CreatedNode) || source.has(ModifiedNode));
    }
}

