/*
 * Decompiled with CFR 0.152.
 */
package com.jccdex.rpc.core.serialized;

import com.jccdex.rpc.core.fields.Field;
import com.jccdex.rpc.core.fields.Type;
import com.jccdex.rpc.core.serialized.BytesList;
import com.jccdex.rpc.core.serialized.BytesSink;
import com.jccdex.rpc.core.serialized.SerializedType;
import java.util.Arrays;

public class BinarySerializer {
    private final BytesSink sink;

    public BinarySerializer(BytesSink sink) {
        this.sink = sink;
    }

    public void add(byte[] n) {
        this.sink.add(n);
    }

    public void addLengthEncoded(byte[] n) {
        this.add(BinarySerializer.encodeVL(n.length));
        this.add(n);
    }

    public static byte[] encodeVL(int length) {
        byte[] lenBytes = new byte[4];
        if (length <= 192) {
            lenBytes[0] = (byte)length;
            return Arrays.copyOf(lenBytes, 1);
        }
        if (length <= 12480) {
            lenBytes[0] = (byte)(193 + ((length -= 193) >>> 8));
            lenBytes[1] = (byte)(length & 0xFF);
            return Arrays.copyOf(lenBytes, 2);
        }
        if (length <= 918744) {
            lenBytes[0] = (byte)(241 + ((length -= 12481) >>> 16));
            lenBytes[1] = (byte)(length >> 8 & 0xFF);
            lenBytes[2] = (byte)(length & 0xFF);
            return Arrays.copyOf(lenBytes, 3);
        }
        throw new RuntimeException("Overflow error");
    }

    public void add(BytesList bl) {
        for (byte[] bytes : bl.rawList()) {
            this.sink.add(bytes);
        }
    }

    public int addFieldHeader(Field f) {
        if (!f.isSerialized()) {
            throw new IllegalStateException(String.format("Field %s is a discardable field", new Object[]{f}));
        }
        byte[] n = f.getBytes();
        this.add(n);
        return n.length;
    }

    public void add(byte type) {
        this.sink.add(type);
    }

    public void addLengthEncoded(BytesList bytes) {
        this.add(BinarySerializer.encodeVL(bytes.bytesLength()));
        this.add(bytes);
    }

    public void add(Field field, SerializedType value) {
        this.addFieldHeader(field);
        if (field.isVLEncoded()) {
            this.addLengthEncoded(value);
        } else {
            value.toBytesSink(this.sink);
            if (field.getType() == Type.STObject) {
                this.addFieldHeader(Field.ObjectEndMarker);
            } else if (field.getType() == Type.STArray) {
                this.addFieldHeader(Field.ArrayEndMarker);
            }
        }
    }

    public void addLengthEncoded(SerializedType value) {
        BytesList bytes = new BytesList();
        value.toBytesSink(bytes);
        this.addLengthEncoded(bytes);
    }
}

