/*
 * Decompiled with CFR 0.152.
 */
package com.jccdex.rpc.core.formats;

import com.jccdex.rpc.core.fields.Field;
import com.jccdex.rpc.core.formats.Format;
import com.jccdex.rpc.core.serialized.enums.TransactionType;
import java.util.EnumMap;

public class TxFormat
extends Format {
    public static EnumMap<TransactionType, TxFormat> formats = new EnumMap(TransactionType.class);
    public final TransactionType transactionType;
    public static TxFormat AccountSet = new TxFormat(TransactionType.AccountSet, new Object[]{Field.EmailHash, Format.Requirement.OPTIONAL, Field.WalletLocator, Format.Requirement.OPTIONAL, Field.WalletSize, Format.Requirement.OPTIONAL, Field.MessageKey, Format.Requirement.OPTIONAL, Field.Domain, Format.Requirement.OPTIONAL, Field.TransferRate, Format.Requirement.OPTIONAL, Field.SetFlag, Format.Requirement.OPTIONAL, Field.ClearFlag, Format.Requirement.OPTIONAL});
    public static TxFormat TrustSet = new TxFormat(TransactionType.TrustSet, new Object[]{Field.LimitAmount, Format.Requirement.OPTIONAL, Field.QualityIn, Format.Requirement.OPTIONAL, Field.QualityOut, Format.Requirement.OPTIONAL});
    public static TxFormat OfferCreate = new TxFormat(TransactionType.OfferCreate, new Object[]{Field.TakerPays, Format.Requirement.REQUIRED, Field.TakerGets, Format.Requirement.REQUIRED, Field.Expiration, Format.Requirement.OPTIONAL, Field.OfferSequence, Format.Requirement.OPTIONAL});
    public static TxFormat OfferCancel = new TxFormat(TransactionType.OfferCancel, new Object[]{Field.OfferSequence, Format.Requirement.REQUIRED});
    public static TxFormat TicketCreate = new TxFormat(TransactionType.TicketCreate, new Object[]{Field.Target, Format.Requirement.OPTIONAL, Field.Expiration, Format.Requirement.OPTIONAL});
    public static TxFormat TicketCancel = new TxFormat(TransactionType.TicketCancel, new Object[]{Field.TicketID, Format.Requirement.REQUIRED});
    public static TxFormat SetRegularKey = new TxFormat(TransactionType.SetRegularKey, new Object[]{Field.RegularKey, Format.Requirement.OPTIONAL});
    public static TxFormat Payment = new TxFormat(TransactionType.Payment, new Object[]{Field.Destination, Format.Requirement.REQUIRED, Field.Amount, Format.Requirement.REQUIRED, Field.SendMax, Format.Requirement.OPTIONAL, Field.Paths, Format.Requirement.DEFAULT, Field.InvoiceID, Format.Requirement.OPTIONAL, Field.DestinationTag, Format.Requirement.OPTIONAL});
    public static TxFormat RelationSet = new TxFormat(TransactionType.RelationSet, new Object[]{Field.Target, Format.Requirement.REQUIRED, Field.LimitAmount, Format.Requirement.REQUIRED});
    public static TxFormat SuspendedPaymentCreate = new TxFormat(TransactionType.SuspendedPaymentCreate, new Object[]{Field.Destination, Format.Requirement.REQUIRED, Field.Amount, Format.Requirement.REQUIRED, Field.Digest, Format.Requirement.OPTIONAL, Field.CancelAfter, Format.Requirement.OPTIONAL, Field.FinishAfter, Format.Requirement.OPTIONAL, Field.DestinationTag, Format.Requirement.OPTIONAL});
    public static TxFormat SuspendedPaymentFinish = new TxFormat(TransactionType.SuspendedPaymentFinish, new Object[]{Field.Owner, Format.Requirement.REQUIRED, Field.OfferSequence, Format.Requirement.REQUIRED, Field.Method, Format.Requirement.OPTIONAL, Field.Digest, Format.Requirement.OPTIONAL, Field.Proof, Format.Requirement.OPTIONAL});
    public static TxFormat SuspendedPaymentCancel = new TxFormat(TransactionType.SuspendedPaymentCancel, new Object[]{Field.Owner, Format.Requirement.REQUIRED, Field.OfferSequence, Format.Requirement.REQUIRED});
    public static TxFormat EnableAmendment = new TxFormat(TransactionType.EnableAmendment, new Object[]{Field.Amendment, Format.Requirement.REQUIRED});
    public static TxFormat SetFee = new TxFormat(TransactionType.SetFee, new Object[]{Field.BaseFee, Format.Requirement.REQUIRED, Field.ReferenceFeeUnits, Format.Requirement.REQUIRED, Field.ReserveBase, Format.Requirement.REQUIRED, Field.ReserveIncrement, Format.Requirement.REQUIRED});

    public static TxFormat fromString(String name) {
        return TxFormat.getTxFormat(TransactionType.valueOf(name));
    }

    public static TxFormat fromNumber(Number ord) {
        return TxFormat.getTxFormat(TransactionType.fromNumber(ord));
    }

    public static TxFormat fromValue(Object o) {
        if (o instanceof Number) {
            return TxFormat.fromNumber(((Number)o).intValue());
        }
        if (o instanceof String) {
            return TxFormat.fromString((String)o);
        }
        return null;
    }

    private static TxFormat getTxFormat(TransactionType key) {
        if (key == null) {
            return null;
        }
        return formats.get(key);
    }

    public TxFormat(TransactionType type, Object ... args) {
        super(args);
        this.transactionType = type;
        this.addCommonFields();
        formats.put(this.transactionType, this);
    }

    @Override
    public void addCommonFields() {
        this.put(Field.TransactionType, Format.Requirement.REQUIRED);
        this.put(Field.Flags, Format.Requirement.OPTIONAL);
        this.put(Field.SourceTag, Format.Requirement.OPTIONAL);
        this.put(Field.LastLedgerSequence, Format.Requirement.OPTIONAL);
        this.put(Field.Account, Format.Requirement.REQUIRED);
        this.put(Field.Sequence, Format.Requirement.OPTIONAL);
        this.put(Field.Fee, Format.Requirement.REQUIRED);
        this.put(Field.OperationLimit, Format.Requirement.OPTIONAL);
        this.put(Field.SigningPubKey, Format.Requirement.OPTIONAL);
        this.put(Field.TxnSignature, Format.Requirement.OPTIONAL);
        this.put(Field.PreviousTxnID, Format.Requirement.OPTIONAL);
        this.put(Field.AccountTxnID, Format.Requirement.OPTIONAL);
        this.put(Field.Memos, Format.Requirement.OPTIONAL);
        this.put(Field.Platform, Format.Requirement.OPTIONAL);
    }

    @Override
    public String name() {
        return this.transactionType.toString();
    }
}

