/*
 * Decompiled with CFR 0.152.
 */
package com.jccdex.rpc.core.coretypes.uint;

import com.jccdex.rpc.core.serialized.BinaryParser;
import com.jccdex.rpc.core.serialized.BytesSink;
import com.jccdex.rpc.core.serialized.SerializedType;
import com.jccdex.rpc.core.serialized.TypeTranslator;
import com.jccdex.rpc.encoding.common.B16;
import java.math.BigInteger;

public abstract class UInt<Subclass extends UInt>
extends Number
implements SerializedType,
Comparable<UInt> {
    private BigInteger value;
    public static BigInteger Max8 = new BigInteger("256");
    public static BigInteger Max16 = new BigInteger("65536");
    public static BigInteger Max32 = new BigInteger("4294967296");
    public static BigInteger Max64 = new BigInteger("18446744073709551616");

    public BigInteger getMinimumValue() {
        return BigInteger.ZERO;
    }

    public UInt(byte[] bytes) {
        this.setValue(new BigInteger(1, bytes));
    }

    public UInt(BigInteger bi) {
        this.setValue(bi);
    }

    public UInt(Number s) {
        this.setValue(BigInteger.valueOf(s.longValue()));
    }

    public UInt(String s) {
        this.setValue(new BigInteger(s));
    }

    public UInt(String s, int radix) {
        this.setValue(new BigInteger(s, radix));
    }

    public String toString() {
        return this.value.toString();
    }

    public UInt() {
    }

    public abstract int getByteWidth();

    public abstract Subclass instanceFrom(BigInteger var1);

    public boolean isValid(BigInteger n) {
        return this.bitLength() / 8 <= this.getByteWidth();
    }

    public Subclass add(UInt val) {
        return this.instanceFrom(this.value.add(val.value));
    }

    public Subclass subtract(UInt val) {
        return this.instanceFrom(this.value.subtract(val.value));
    }

    public Subclass multiply(UInt val) {
        return this.instanceFrom(this.value.multiply(val.value));
    }

    public Subclass divide(UInt val) {
        return this.instanceFrom(this.value.divide(val.value));
    }

    public Subclass or(UInt val) {
        return this.instanceFrom(this.value.or(val.value));
    }

    public Subclass shiftLeft(int n) {
        return this.instanceFrom(this.value.shiftLeft(n));
    }

    public Subclass shiftRight(int n) {
        return this.instanceFrom(this.value.shiftRight(n));
    }

    public int bitLength() {
        return this.value.bitLength();
    }

    @Override
    public int compareTo(UInt val) {
        return this.value.compareTo(val.value);
    }

    public boolean equals(Object obj) {
        if (obj instanceof UInt) {
            return this.equals((UInt)obj);
        }
        return super.equals(obj);
    }

    public boolean equals(UInt x) {
        return this.value.equals(x.value);
    }

    public BigInteger min(BigInteger val) {
        return this.value.min(val);
    }

    public BigInteger max(BigInteger val) {
        return this.value.max(val);
    }

    public String toString(int radix) {
        return this.value.toString(radix);
    }

    public byte[] toByteArray() {
        int length = this.getByteWidth();
        byte[] bytes = this.value.toByteArray();
        if (bytes[0] == 0) {
            if (bytes.length - 1 > length) {
                throw new IllegalArgumentException("standard length exceeded for value");
            }
            byte[] tmp = new byte[length];
            System.arraycopy(bytes, 1, tmp, tmp.length - (bytes.length - 1), bytes.length - 1);
            return tmp;
        }
        if (bytes.length == length) {
            return bytes;
        }
        if (bytes.length > length) {
            throw new IllegalArgumentException("standard length exceeded for value");
        }
        byte[] tmp = new byte[length];
        System.arraycopy(bytes, 0, tmp, tmp.length - bytes.length, bytes.length);
        return tmp;
    }

    public abstract Object value();

    public BigInteger bigInteger() {
        return this.value;
    }

    @Override
    public int intValue() {
        return this.value.intValue();
    }

    @Override
    public long longValue() {
        return this.value.longValue();
    }

    @Override
    public double doubleValue() {
        return this.value.doubleValue();
    }

    @Override
    public float floatValue() {
        return this.value.floatValue();
    }

    @Override
    public byte byteValue() {
        return this.value.byteValue();
    }

    @Override
    public short shortValue() {
        return this.value.shortValue();
    }

    public void setValue(BigInteger value) {
        this.value = value;
    }

    public <T extends UInt> boolean lte(T sequence) {
        return this.compareTo(sequence) < 1;
    }

    public boolean testBit(int f) {
        return this.value.testBit(f);
    }

    public boolean isZero() {
        return this.value.signum() == 0;
    }

    public static abstract class UINTTranslator<T extends UInt>
    extends TypeTranslator<T> {
        public abstract T newInstance(BigInteger var1);

        public abstract int byteWidth();

        @Override
        public T fromParser(BinaryParser parser, Integer hint) {
            return this.newInstance(new BigInteger(1, parser.read(this.byteWidth())));
        }

        @Override
        public Object toJSON(T obj) {
            if (((UInt)obj).getByteWidth() <= 4) {
                return ((UInt)obj).longValue();
            }
            return this.toString(obj);
        }

        @Override
        public T fromLong(long aLong) {
            return this.newInstance(BigInteger.valueOf(aLong));
        }

        @Override
        public T fromString(String value) {
            int radix = this.byteWidth() <= 4 ? 10 : 16;
            return this.newInstance(new BigInteger(value, radix));
        }

        @Override
        public T fromInteger(int integer) {
            return (T)this.fromLong(integer);
        }

        @Override
        public String toString(T obj) {
            return B16.toString(((UInt)obj).toByteArray());
        }

        @Override
        public void toBytesSink(T obj, BytesSink to) {
            to.add(((UInt)obj).toByteArray());
        }
    }
}

