/*
 * Decompiled with CFR 0.152.
 */
package com.jccdex.rpc.core.coretypes;

import com.jccdex.rpc.core.coretypes.hash.Hash256;
import com.jccdex.rpc.core.fields.Field;
import com.jccdex.rpc.core.fields.Type;
import com.jccdex.rpc.core.fields.Vector256Field;
import com.jccdex.rpc.core.serialized.BinaryParser;
import com.jccdex.rpc.core.serialized.BytesSink;
import com.jccdex.rpc.core.serialized.SerializedType;
import com.jccdex.rpc.core.serialized.TypeTranslator;
import com.jccdex.rpc.encoding.common.B16;
import java.util.ArrayList;
import org.json.JSONArray;

public class Vector256
extends ArrayList<Hash256>
implements SerializedType {
    public static Translator translate = new Translator();
    public static Vector256Field Indexes = Vector256.vector256Field(Field.Indexes);
    public static Vector256Field Hashes = Vector256.vector256Field(Field.Hashes);
    public static Vector256Field Amendments = Vector256.vector256Field(Field.Amendments);

    @Override
    public Object toJSON() {
        return this.toJSONArray();
    }

    public JSONArray toJSONArray() {
        JSONArray array = new JSONArray();
        for (Hash256 hash256 : this) {
            array.put((Object)hash256.toString());
        }
        return array;
    }

    @Override
    public byte[] toBytes() {
        return translate.toBytes(this);
    }

    @Override
    public String toHex() {
        return translate.toHex(this);
    }

    @Override
    public void toBytesSink(BytesSink to) {
        for (Hash256 hash256 : this) {
            hash256.toBytesSink(to);
        }
    }

    @Override
    public Type type() {
        return Type.Vector256;
    }

    public boolean removeUnstable(Hash256 ledgerIndex) {
        int i = this.indexOf(ledgerIndex);
        if (i == -1) {
            return false;
        }
        int last = this.size() - 1;
        Hash256 lastIndex = (Hash256)this.get(last);
        this.set(i, lastIndex);
        this.remove(last);
        return true;
    }

    public static Vector256Field vector256Field(final Field f) {
        return new Vector256Field(){

            @Override
            public Field getField() {
                return f;
            }
        };
    }

    public static class Translator
    extends TypeTranslator<Vector256> {
        @Override
        public Vector256 fromParser(BinaryParser parser, Integer hint) {
            Vector256 vector256 = new Vector256();
            if (hint == null) {
                hint = parser.size() - parser.pos();
            }
            for (int i = 0; i < hint / 32; ++i) {
                vector256.add(Hash256.translate.fromParser(parser));
            }
            return vector256;
        }

        @Override
        public JSONArray toJSONArray(Vector256 obj) {
            return obj.toJSONArray();
        }

        @Override
        public Vector256 fromJSONArray(JSONArray jsonArray) {
            Vector256 vector = new Vector256();
            for (int i = 0; i < jsonArray.length(); ++i) {
                String hex = jsonArray.getString(i);
                vector.add(new Hash256(B16.decode(hex)));
            }
            return vector;
        }
    }
}

