/*
 * Decompiled with CFR 0.152.
 */
package com.jccdex.rpc.core.coretypes;

import com.jccdex.rpc.core.coretypes.AccountID;
import com.jccdex.rpc.core.coretypes.Currency;
import com.jccdex.rpc.core.fields.Field;
import com.jccdex.rpc.core.fields.PathSetField;
import com.jccdex.rpc.core.fields.Type;
import com.jccdex.rpc.core.serialized.BinaryParser;
import com.jccdex.rpc.core.serialized.BytesSink;
import com.jccdex.rpc.core.serialized.SerializedType;
import com.jccdex.rpc.core.serialized.TypeTranslator;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONObject;

public class PathSet
extends ArrayList<Path>
implements SerializedType {
    public static byte PATH_SEPARATOR_BYTE = (byte)-1;
    public static byte PATHSET_END_BYTE = 0;
    public static Translator translate = new Translator();
    public static PathSetField Paths = PathSet.pathsetField(Field.Paths);

    public JSONArray toJSONArray() {
        JSONArray array = new JSONArray();
        for (Path path : this) {
            array.put((Object)path.toJSONArray());
        }
        return array;
    }

    @Override
    public Object toJSON() {
        return this.toJSONArray();
    }

    @Override
    public void toBytesSink(BytesSink buffer) {
        int n = 0;
        for (Path path : this) {
            if (n++ != 0) {
                buffer.add(PATH_SEPARATOR_BYTE);
            }
            for (Hop hop : path) {
                int type = hop.getType();
                buffer.add((byte)type);
                if (hop.hasAccount()) {
                    buffer.add(hop.account.bytes());
                }
                if (hop.hasCurrency()) {
                    buffer.add(hop.currency.bytes());
                }
                if (!hop.hasIssuer()) continue;
                buffer.add(hop.issuer.bytes());
            }
        }
        buffer.add(PATHSET_END_BYTE);
    }

    @Override
    public Type type() {
        return Type.PathSet;
    }

    @Override
    public String toHex() {
        return translate.toHex(this);
    }

    @Override
    public byte[] toBytes() {
        return translate.toBytes(this);
    }

    public static PathSetField pathsetField(final Field f) {
        return new PathSetField(){

            @Override
            public Field getField() {
                return f;
            }
        };
    }

    public static class Translator
    extends TypeTranslator<PathSet> {
        @Override
        public PathSet fromParser(BinaryParser parser, Integer hint) {
            byte type;
            PathSet pathSet = new PathSet();
            Path path = null;
            while (!parser.end() && (type = parser.readOne()) != PATHSET_END_BYTE) {
                if (path == null) {
                    path = new Path();
                    pathSet.add(path);
                }
                if (type == PATH_SEPARATOR_BYTE) {
                    path = null;
                    continue;
                }
                Hop hop = new Hop();
                path.add(hop);
                if ((type & Hop.TYPE_ACCOUNT) != 0) {
                    hop.account = (AccountID)AccountID.translate.fromParser(parser);
                }
                if ((type & Hop.TYPE_CURRENCY) != 0) {
                    hop.currency = (Currency)Currency.translate.fromParser(parser);
                }
                if ((type & Hop.TYPE_ISSUER) == 0) continue;
                hop.issuer = (AccountID)AccountID.translate.fromParser(parser);
            }
            return pathSet;
        }

        @Override
        public PathSet fromJSONArray(JSONArray array) {
            PathSet paths = new PathSet();
            int nPaths = array.length();
            for (int i = 0; i < nPaths; ++i) {
                JSONArray path = array.getJSONArray(i);
                paths.add(Path.fromJSONArray(path));
            }
            return paths;
        }
    }

    public static class Path
    extends ArrayList<Hop> {
        public static Path fromJSONArray(JSONArray array) {
            Path path = new Path();
            int nHops = array.length();
            for (int i = 0; i < nHops; ++i) {
                JSONObject hop = array.getJSONObject(i);
                path.add(Hop.fromJSONObject(hop));
            }
            return path;
        }

        public JSONArray toJSONArray() {
            JSONArray array = new JSONArray();
            for (Hop hop : this) {
                array.put((Object)hop.toJSONObject());
            }
            return array;
        }
    }

    public static class Hop {
        public static byte TYPE_ACCOUNT = 1;
        public static byte TYPE_CURRENCY = (byte)16;
        public static byte TYPE_ISSUER = (byte)32;
        public static final int TYPE_ACCOUNT_CURRENCY_ISSUER = TYPE_CURRENCY | TYPE_ACCOUNT | TYPE_ISSUER;
        public static final int TYPE_ACCOUNT_CURRENCY = TYPE_CURRENCY | TYPE_ACCOUNT;
        public static int VALID_TYPE_MASK = ~(TYPE_ACCOUNT | TYPE_CURRENCY | TYPE_ISSUER);
        public AccountID account;
        public AccountID issuer;
        public Currency currency;
        private int type;

        public boolean hasIssuer() {
            return this.issuer != null;
        }

        public boolean hasCurrency() {
            return this.currency != null;
        }

        public boolean hasAccount() {
            return this.account != null;
        }

        public int getType() {
            if (this.type == 0) {
                this.synthesizeType();
            }
            return this.type;
        }

        public static Hop fromJSONObject(JSONObject json) {
            Hop hop = new Hop();
            if (json.has("account")) {
                hop.account = AccountID.fromAddress(json.getString("account"));
            }
            if (json.has("issuer")) {
                hop.issuer = AccountID.fromAddress(json.getString("issuer"));
            }
            if (json.has("currency")) {
                hop.currency = Currency.fromString(json.getString("currency"));
            }
            if (json.has("type")) {
                hop.type = json.getInt("type");
            }
            return hop;
        }

        public void synthesizeType() {
            this.type = 0;
            if (this.hasAccount()) {
                this.type |= TYPE_ACCOUNT;
            }
            if (this.hasCurrency()) {
                this.type |= TYPE_CURRENCY;
            }
            if (this.hasIssuer()) {
                this.type |= TYPE_ISSUER;
            }
        }

        public JSONObject toJSONObject() {
            JSONObject object = new JSONObject();
            object.put("type", this.getType());
            if (this.hasAccount()) {
                object.put("account", this.account.toJSON());
            }
            if (this.hasIssuer()) {
                object.put("issuer", this.issuer.toJSON());
            }
            if (this.hasCurrency()) {
                object.put("currency", this.currency.toJSON());
            }
            return object;
        }
    }
}

