/*
 * Decompiled with CFR 0.152.
 */
package com.jccdex.rpc.core.cache;

import com.jccdex.rpc.core.coretypes.hash.Hash256;
import com.jccdex.rpc.core.coretypes.uint.UInt32;
import com.jccdex.rpc.core.types.known.sle.LedgerEntry;
import com.jccdex.rpc.core.types.known.tx.result.AffectedNode;
import com.jccdex.rpc.core.types.known.tx.result.TransactionMeta;
import com.jccdex.rpc.core.types.known.tx.result.TransactionResult;
import java.util.TreeMap;

public class SLECache {
    private final TreeMap<Hash256, CacheEntry> cache = new TreeMap();

    public boolean cache(LedgerEntry le, UInt32 validatedLedgerIndex) {
        Hash256 index = le.ledgerIndex();
        CacheEntry ce = this.getOrCreate(index);
        ce.upateLedgerEntry(le, validatedLedgerIndex, null);
        return true;
    }

    private CacheEntry getEntry(Hash256 index) {
        return this.cache.get(index);
    }

    private CacheEntry createEntry(Hash256 index) {
        CacheEntry ce = new CacheEntry();
        this.cache.put(index, ce);
        return ce;
    }

    public LedgerEntry get(Hash256 index) {
        CacheEntry entry = this.getEntry(index);
        return entry == null || entry.deleted ? null : entry.le;
    }

    public void updateFromTransactionResult(TransactionResult tr) {
        if (!tr.validated) {
            return;
        }
        TransactionMeta meta = tr.meta;
        UInt32 ledgerIndex = tr.ledgerIndex;
        UInt32 txnIndex = meta.transactionIndex();
        for (AffectedNode an : meta.affectedNodes()) {
            Hash256 index = an.ledgerIndex();
            CacheEntry ce = this.getOrCreate(index);
            ce.upateLedgerEntry(an.isDeletedNode() ? null : an.nodeAsFinal(), ledgerIndex, txnIndex);
        }
    }

    private CacheEntry getOrCreate(Hash256 index) {
        CacheEntry already = this.getEntry(index);
        if (already == null) {
            return this.createEntry(index);
        }
        return already;
    }

    public static class CacheEntry {
        public LedgerEntry le;
        public UInt32 prevTxnIndex;
        public UInt32 prevLedger;
        public boolean deleted = false;

        public void upateLedgerEntry(LedgerEntry le, UInt32 ledgerIndex, UInt32 txnIndex) {
            if (this.doUpdate(txnIndex, ledgerIndex)) {
                this.prevTxnIndex = txnIndex;
                this.prevLedger = ledgerIndex;
                if (le == null) {
                    this.deleted = true;
                }
                this.le = le;
            }
        }

        private boolean doUpdate(UInt32 txnIndex, UInt32 ledgerIndex) {
            if (this.le == null && !this.deleted) {
                return true;
            }
            if (this.prevLedger == null) {
                return true;
            }
            int ledgerCmp = ledgerIndex.compareTo(this.prevLedger);
            if (ledgerCmp == 1) {
                return true;
            }
            if (ledgerCmp == 0) {
                if (this.prevTxnIndex == null) {
                    return true;
                }
                if (txnIndex.compareTo(this.prevTxnIndex) == 1) {
                    return true;
                }
            }
            return false;
        }
    }
}

