/*
 * Decompiled with CFR 0.152.
 */
package com.jccdex.rpc.config;

import com.jccdex.rpc.encoding.B58IdentiferCodecs;
import com.jccdex.rpc.encoding.base58.B58;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class Config {
    public static final String DEFAULT_ALPHABET = "jpshnaf39wBUDNEGHJKLM4PQRST7VWXYZ2bcdeCg65rkm8oFqi1tuvAxyz";
    public static final String DEFAULT_ISSUER = "jGa9J9TkqtBcUoHe2zqhVFFbgUVED6o9or";
    public static final String DEFAULT_PLATFORM = "jDXCeSHSpZ9LiX6ihckWaYDeDt5hFrdTto";
    public static final double DEFAULT_FEE_CUSHION = 1.1;
    public static final String DEFAULT_CURRENCY = "SWT";
    public static B58IdentiferCodecs b58IdentiferCodecs;
    public static double feeCushion;
    public static B58 b58;
    public static int SEED_PREFIX;
    public static String CURRENCY;
    public static String ACCOUNT_ZERO;
    public static String ACCOUNT_ONE;
    public static Integer FEE;
    public static String ISSUER;
    public static String PLATFORM;
    public static boolean bouncyInitiated;

    public static void setAlphabet(String alphabet) {
        b58 = new B58(alphabet);
        b58IdentiferCodecs = new B58IdentiferCodecs(b58);
    }

    public static B58IdentiferCodecs getB58IdentiferCodecs() {
        return b58IdentiferCodecs;
    }

    public static B58 getB58() {
        return b58;
    }

    public static void initBouncy() {
        if (!bouncyInitiated) {
            Security.addProvider((Provider)new BouncyCastleProvider());
            bouncyInitiated = true;
        }
    }

    public static double getFeeCushion() {
        return feeCushion;
    }

    public static void setFeeCushion(double fee_cushion) {
        feeCushion = fee_cushion;
    }

    public static void setIssuer(String _issuer) {
        ISSUER = _issuer;
    }

    public static void setFee(Integer _fee) {
        FEE = _fee;
    }

    public static void setCurrency(String _currency) {
        CURRENCY = _currency;
    }

    public static void setPlatform(String _platform) {
        PLATFORM = _platform;
    }

    static {
        SEED_PREFIX = 33;
        ACCOUNT_ZERO = "jjjjjjjjjjjjjjjjjjjjjhoLvTp";
        ACCOUNT_ONE = "jjjjjjjjjjjjjjjjjjjjBZbvri";
        FEE = 100;
        bouncyInitiated = false;
        Security.addProvider((Provider)new BouncyCastleProvider());
        Config.setAlphabet(DEFAULT_ALPHABET);
        Config.setIssuer(DEFAULT_ISSUER);
        Config.setFeeCushion(1.1);
        Config.setCurrency(DEFAULT_CURRENCY);
        Config.setPlatform(DEFAULT_PLATFORM);
        Config.initBouncy();
    }
}

