/*
 * Decompiled with CFR 0.152.
 */
package com.jccdex.rpc;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jccdex.core.client.Wallet;
import com.jccdex.rpc.config.Config;
import com.jccdex.rpc.config.RpcNode;
import com.jccdex.rpc.core.coretypes.AccountID;
import com.jccdex.rpc.core.coretypes.Amount;
import com.jccdex.rpc.core.coretypes.Currency;
import com.jccdex.rpc.core.coretypes.uint.UInt32;
import com.jccdex.rpc.core.types.known.tx.signed.SignedTransaction;
import com.jccdex.rpc.core.types.known.tx.txns.OfferCancel;
import com.jccdex.rpc.core.types.known.tx.txns.OfferCreate;
import com.jccdex.rpc.core.types.known.tx.txns.Payment;
import com.jccdex.rpc.http.OkhttpUtil;
import com.jccdex.rpc.utils.Utils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;

public class JccJingtum {
    private final RpcNode rpcNode;
    private int tryTimes;
    private final String SUCCESS_CODE = "success";
    private final String TX_SUCCESS_CODE = "tesSUCCESS";

    public JccJingtum(ArrayList<String> rpcNodes) {
        this.tryTimes = rpcNodes.size();
        this.rpcNode = new RpcNode(rpcNodes);
    }

    public JccJingtum(Integer fee, String baseToken, String issuer, ArrayList<String> rpcNodes) {
        this(rpcNodes);
        Config.setFee(fee);
        Config.setCurrency(baseToken);
        Config.setIssuer(issuer);
    }

    public JccJingtum(String alphabet, Integer fee, String baseToken, String issuer, ArrayList<String> rpcNodes) {
        this(fee, baseToken, issuer, rpcNodes);
        Config.setAlphabet(alphabet);
    }

    public JccJingtum(String alphabet, Integer fee, String baseToken, String issuer, String platform, ArrayList<String> rpcNodes) {
        this(alphabet, fee, baseToken, issuer, rpcNodes);
        Config.setPlatform(platform);
    }

    public void setFee(Integer fee) throws Exception {
        try {
            if (fee <= 0) {
                throw new Exception("\u71c3\u6599\u8d39\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0");
            }
            Config.setFee(fee);
        }
        catch (Exception e) {
            throw new Exception("\u8bbe\u7f6e\u71c3\u6599\u8d39\u5f02\u5e38");
        }
    }

    public Integer getFee() {
        return Config.FEE;
    }

    public void setPlatform(String platform) throws Exception {
        try {
            if (!Wallet.isValidAddress((String)platform)) {
                throw new Exception("\u5e73\u53f0\u8d26\u53f7\u4e0d\u5408\u6cd5");
            }
            Config.setPlatform(platform);
        }
        catch (Exception e) {
            throw new Exception("\u8bbe\u7f6e\u4ea4\u6613\u5e73\u53f0\u8d26\u53f7\u5f02\u5e38");
        }
    }

    public String getPlatform() {
        return Config.PLATFORM;
    }

    public String createWallet() throws Exception {
        try {
            ObjectNode data = new ObjectMapper().createObjectNode();
            Wallet wallet = Wallet.generate();
            data.put("secret", wallet.getSecret());
            data.put("address", wallet.getAddress());
            return data.toString();
        }
        catch (Exception e) {
            throw new Exception("\u521b\u5efa\u94b1\u5305\u5f02\u5e38");
        }
    }

    public String getWalletAddress(String secret) throws Exception {
        try {
            if (!Wallet.isValidSecret((String)secret)) {
                throw new Exception("\u94b1\u5305\u5bc6\u94a5\u4e0d\u5408\u6cd5");
            }
            Wallet wallet = Wallet.fromSecret((String)secret);
            return wallet.getAddress();
        }
        catch (Exception e) {
            throw new Exception("\u521b\u5efa\u94b1\u5305\u5f02\u5e38");
        }
    }

    public void setTryTimes(int tryTimes) {
        this.tryTimes = tryTimes;
    }

    private String getSequence(String address) throws Exception {
        if (!Wallet.isValidAddress((String)address)) {
            throw new Exception("\u94b1\u5305\u5730\u5740\u4e0d\u5408\u6cd5");
        }
        String sequence = "";
        int times = this.tryTimes;
        do {
            try {
                --times;
                ObjectMapper mapper = new ObjectMapper();
                ObjectNode data = mapper.createObjectNode();
                ObjectNode object = mapper.createObjectNode();
                object.put("account", address);
                ArrayList<ObjectNode> params = new ArrayList<ObjectNode>();
                params.add(object);
                ArrayNode array = (ArrayNode)mapper.valueToTree(params);
                data.put("method", "account_info");
                data.set("params", (JsonNode)array);
                String url = this.rpcNode.randomUrl();
                String res = OkhttpUtil.post(url, data.toString());
                String code = JSONObject.parseObject((String)res).getJSONObject("result").getString("status");
                if ("success".equals(code)) {
                    sequence = JSONObject.parseObject((String)res).getJSONObject("result").getJSONObject("account_data").getString("Sequence");
                }
                if (!sequence.isEmpty()) break;
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (times > 0);
        if (sequence.isEmpty()) {
            throw new Exception("\u83b7\u53d6sequence\u5931\u8d25");
        }
        return sequence;
    }

    private String requestTx(String hash, String rpcNode) {
        String tx = "";
        try {
            ObjectMapper mapper = new ObjectMapper();
            ObjectNode data = mapper.createObjectNode();
            ObjectNode object = mapper.createObjectNode();
            object.put("transaction", hash);
            object.put("binary", false);
            ArrayList<ObjectNode> params = new ArrayList<ObjectNode>();
            params.add(object);
            ArrayNode array = (ArrayNode)mapper.valueToTree(params);
            data.put("method", "tx");
            data.set("params", (JsonNode)array);
            String res = OkhttpUtil.post(rpcNode, data.toString());
            String status = JSONObject.parseObject((String)res).getJSONObject("result").getString("status");
            Boolean validated = JSONObject.parseObject((String)res).getJSONObject("result").getBoolean("validated");
            if ("success".equals(status) && validated.booleanValue()) {
                tx = res;
            }
            return tx;
        }
        catch (Exception e) {
            return tx;
        }
    }

    public String requestTx(String hash) throws Exception {
        String tx = "";
        try {
            String url;
            ArrayList<String> list = this.rpcNode.getUrls();
            Iterator<String> it = list.iterator();
            while (it.hasNext() && (tx = this.requestTx(hash, url = it.next())).isEmpty()) {
            }
        }
        catch (Exception e) {
            throw new Exception("\u83b7\u53d6\u4ea4\u6613\u4fe1\u606f\u5931\u8d25");
        }
        if (tx.isEmpty()) {
            throw new Exception("\u83b7\u53d6\u4ea4\u6613\u4fe1\u606f\u5931\u8d25");
        }
        return tx;
    }

    public String getMemoData(String hexStrMemData) throws Exception {
        try {
            return Utils.hexStrToStr(hexStrMemData);
        }
        catch (Exception e) {
            throw new Exception("\u83b7\u53d6\u5907\u6ce8\u5185\u5bb9\u5931\u8d25");
        }
    }

    public String paymentWithCheck(String secret, String receiver, String pToken, String pAmount, String memos) throws Exception {
        try {
            if (!Wallet.isValidSecret((String)secret)) {
                throw new Exception("\u94b1\u5305\u5bc6\u94a5\u4e0d\u5408\u6cd5");
            }
            if (!Wallet.isValidAddress((String)receiver)) {
                throw new Exception("\u94b1\u5305\u5730\u5740\u4e0d\u5408\u6cd5");
            }
            if (pToken.isEmpty()) {
                throw new Exception("token\u540d\u79f0\u4e0d\u5408\u6cd5");
            }
            if (pAmount.isEmpty()) {
                throw new Exception("token\u540d\u79f0\u4e0d\u5408\u6cd5");
            }
            Wallet wallet = Wallet.fromSecret((String)secret);
            String sender = wallet.getAddress();
            String sequence = this.getSequence(sender);
            ObjectMapper mapper = new ObjectMapper();
            String token = pToken.toUpperCase();
            Payment payment = new Payment();
            payment.as(AccountID.Account, sender);
            payment.as(AccountID.Destination, receiver);
            BigDecimal bigDecimal = new BigDecimal(pAmount);
            if (bigDecimal.compareTo(new BigDecimal(0)) < 1) {
                throw new Exception("token\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0");
            }
            Amount amount = Config.CURRENCY.equals(token) ? new Amount(bigDecimal) : new Amount(bigDecimal, Currency.fromString(token), AccountID.fromString(Config.ISSUER));
            payment.as(Amount.Amount, amount);
            payment.as(Amount.Fee, String.valueOf(Config.FEE));
            payment.sequence(new UInt32(sequence));
            payment.flags(new UInt32(0));
            if (memos.length() > 0) {
                ArrayList<String> memoList = new ArrayList<String>(1);
                memoList.add(memos);
                payment.addMemo(memoList);
            }
            SignedTransaction tx = payment.sign(secret);
            String res = this.submit(tx.tx_blob, tx.hash.toHex());
            return res;
        }
        catch (Exception e) {
            throw new Exception("\u8f6c\u8d26\u5931\u8d25");
        }
    }

    public String paymentNoCheck(String secret, String receiver, String pToken, String pAmount, String memos) throws Exception {
        if (!Wallet.isValidSecret((String)secret)) {
            throw new Exception("\u94b1\u5305\u5bc6\u94a5\u4e0d\u5408\u6cd5");
        }
        if (!Wallet.isValidAddress((String)receiver)) {
            throw new Exception("\u94b1\u5305\u5730\u5740\u4e0d\u5408\u6cd5");
        }
        if (pToken.isEmpty()) {
            throw new Exception("token\u540d\u79f0\u4e0d\u5408\u6cd5");
        }
        if (pAmount.isEmpty()) {
            throw new Exception("token\u540d\u79f0\u4e0d\u5408\u6cd5");
        }
        Wallet wallet = Wallet.fromSecret((String)secret);
        String sender = wallet.getAddress();
        String sequence = this.getSequence(sender);
        ObjectMapper mapper = new ObjectMapper();
        String token = pToken.toUpperCase();
        Payment payment = new Payment();
        payment.as(AccountID.Account, sender);
        payment.as(AccountID.Destination, receiver);
        BigDecimal bigDecimal = new BigDecimal(pAmount);
        if (bigDecimal.compareTo(new BigDecimal(0)) < 1) {
            throw new Exception("token\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0");
        }
        Amount amount = Config.CURRENCY.equals(token) ? new Amount(bigDecimal) : new Amount(bigDecimal, Currency.fromString(token), AccountID.fromString(Config.ISSUER));
        payment.as(Amount.Amount, amount);
        payment.as(Amount.Fee, String.valueOf(Config.FEE));
        payment.sequence(new UInt32(sequence));
        payment.flags(new UInt32(0));
        if (memos.length() > 0) {
            ArrayList<String> memoList = new ArrayList<String>(1);
            memoList.add(memos);
            payment.addMemo(memoList);
        }
        SignedTransaction tx = payment.sign(secret);
        String res = this.submit(tx.tx_blob);
        return res;
    }

    public String createOrderWithCheck(String secret, String pPayToke, String pPayAmount, String pGetToken, String pGetAmount, String memos) throws Exception {
        try {
            if (!Wallet.isValidSecret((String)secret)) {
                throw new Exception("\u94b1\u5305\u5bc6\u94a5\u4e0d\u5408\u6cd5");
            }
            if (pPayToke.isEmpty() || pGetToken.isEmpty()) {
                throw new Exception("token\u540d\u79f0\u4e0d\u5408\u6cd5");
            }
            if (pPayAmount.isEmpty() || pGetAmount.isEmpty()) {
                throw new Exception("token\u6570\u91cf\u4e0d\u5408\u6cd5");
            }
            Wallet wallet = Wallet.fromSecret((String)secret);
            String address = wallet.getAddress();
            ObjectMapper mapper = new ObjectMapper();
            String payToken = pPayToke.toUpperCase();
            String getToken = pGetToken.toUpperCase();
            OfferCreate offerCreate = new OfferCreate();
            offerCreate.as(AccountID.Account, address);
            offerCreate.as(AccountID.Platform, Config.PLATFORM);
            BigDecimal payBigDecimal = new BigDecimal(pPayAmount);
            BigDecimal getBigDecimal = new BigDecimal(pGetAmount);
            if (payBigDecimal.compareTo(new BigDecimal(0)) < 1) {
                throw new Exception("token\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0");
            }
            if (getBigDecimal.compareTo(new BigDecimal(0)) < 1) {
                throw new Exception("token\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0");
            }
            Amount payAmount = Config.CURRENCY.equals(payToken) ? new Amount(payBigDecimal) : new Amount(payBigDecimal, Currency.fromString(payToken), AccountID.fromString(Config.ISSUER));
            Amount getAmount = Config.CURRENCY.equals(getToken) ? new Amount(getBigDecimal) : new Amount(getBigDecimal, Currency.fromString(getToken), AccountID.fromString(Config.ISSUER));
            offerCreate.as(Amount.TakerPays, getAmount);
            offerCreate.as(Amount.TakerGets, payAmount);
            offerCreate.as(Amount.Fee, String.valueOf(Config.FEE));
            String sequence = this.getSequence(address);
            offerCreate.sequence(new UInt32(sequence));
            if (memos.length() > 0) {
                ArrayList<String> memoList = new ArrayList<String>(1);
                memoList.add(memos);
                offerCreate.addMemo(memoList);
            }
            SignedTransaction tx = offerCreate.sign(secret);
            String res = this.submit(tx.tx_blob, tx.hash.toHex());
            return res;
        }
        catch (Exception e) {
            throw new Exception("\u6302\u5355\u5931\u8d25");
        }
    }

    public String createOrderNoCheck(String secret, String pPayToke, String pPayAmount, String pGetToken, String pGetAmount, String memos) throws Exception {
        try {
            if (!Wallet.isValidSecret((String)secret)) {
                throw new Exception("\u94b1\u5305\u5bc6\u94a5\u4e0d\u5408\u6cd5");
            }
            if (pPayToke.isEmpty() || pGetToken.isEmpty()) {
                throw new Exception("token\u540d\u79f0\u4e0d\u5408\u6cd5");
            }
            if (pPayAmount.isEmpty() || pGetAmount.isEmpty()) {
                throw new Exception("token\u6570\u91cf\u4e0d\u5408\u6cd5");
            }
            Wallet wallet = Wallet.fromSecret((String)secret);
            String address = wallet.getAddress();
            String payToken = pPayToke.toUpperCase();
            String getToken = pGetToken.toUpperCase();
            OfferCreate offerCreate = new OfferCreate();
            offerCreate.as(AccountID.Account, address);
            offerCreate.as(AccountID.Platform, Config.PLATFORM);
            BigDecimal payBigDecimal = new BigDecimal(pPayAmount);
            BigDecimal getBigDecimal = new BigDecimal(pGetAmount);
            if (payBigDecimal.compareTo(new BigDecimal(0)) < 1) {
                throw new Exception("token\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0");
            }
            if (getBigDecimal.compareTo(new BigDecimal(0)) < 1) {
                throw new Exception("token\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0");
            }
            Amount payAmount = Config.CURRENCY.equals(payToken) ? new Amount(payBigDecimal) : new Amount(payBigDecimal, Currency.fromString(payToken), AccountID.fromString(Config.ISSUER));
            Amount getAmount = Config.CURRENCY.equals(getToken) ? new Amount(getBigDecimal) : new Amount(getBigDecimal, Currency.fromString(getToken), AccountID.fromString(Config.ISSUER));
            offerCreate.as(Amount.TakerPays, getAmount);
            offerCreate.as(Amount.TakerGets, payAmount);
            offerCreate.as(Amount.Fee, String.valueOf(Config.FEE));
            String sequence = this.getSequence(address);
            offerCreate.sequence(new UInt32(sequence));
            if (memos.length() > 0) {
                ArrayList<String> memoList = new ArrayList<String>(1);
                memoList.add(memos);
                offerCreate.addMemo(memoList);
            }
            SignedTransaction tx = offerCreate.sign(secret);
            String res = this.submit(tx.tx_blob);
            return res;
        }
        catch (Exception e) {
            throw new Exception("\u6302\u5355\u5931\u8d25");
        }
    }

    public String cancleOrder(String secret, String pSequence) throws Exception {
        try {
            if (!Wallet.isValidSecret((String)secret)) {
                throw new Exception("\u94b1\u5305\u5bc6\u94a5\u4e0d\u5408\u6cd5");
            }
            BigDecimal bigDecimal = new BigDecimal(pSequence);
            if (bigDecimal.compareTo(new BigDecimal(0)) < 1) {
                throw new Exception("sequence\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0");
            }
            Wallet wallet = Wallet.fromSecret((String)secret);
            String address = wallet.getAddress();
            OfferCancel offerCancel = new OfferCancel();
            offerCancel.as(AccountID.Account, address);
            offerCancel.as(UInt32.OfferSequence, bigDecimal.longValue());
            offerCancel.as(Amount.Fee, String.valueOf(Config.FEE));
            String sequence = this.getSequence(address);
            offerCancel.sequence(new UInt32(sequence));
            SignedTransaction tx = offerCancel.sign(secret);
            String res = this.submit(tx.tx_blob);
            return res;
        }
        catch (Exception e) {
            throw new Exception("\u64a4\u5355\u5931\u8d25");
        }
    }

    public String submit(String txBlob, String hash) throws Exception {
        int times = this.tryTimes;
        String resTx = "";
        String result = "";
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode data = mapper.createObjectNode();
        ObjectNode object = mapper.createObjectNode();
        object.put("tx_blob", txBlob);
        ArrayList<ObjectNode> params = new ArrayList<ObjectNode>();
        params.add(object);
        ArrayNode array = (ArrayNode)mapper.valueToTree(params);
        data.put("method", "submit");
        data.set("params", (JsonNode)array);
        do {
            --times;
            try {
                String url = this.rpcNode.randomUrl();
                result = OkhttpUtil.post(url, data.toString());
                Thread.sleep(5000L);
                resTx = this.requestTx(hash);
                if (!resTx.isEmpty()) {
                    break;
                }
            }
            catch (Exception e) {
                continue;
            }
            Thread.sleep(1000L);
        } while (times > 0);
        if (resTx.isEmpty()) {
            return result;
        }
        return resTx;
    }

    public String submit(String txBlob) throws Exception {
        try {
            int times = this.tryTimes;
            String res = "";
            ObjectMapper mapper = new ObjectMapper();
            ObjectNode data = mapper.createObjectNode();
            ObjectNode object = mapper.createObjectNode();
            object.put("tx_blob", txBlob);
            ArrayList<ObjectNode> params = new ArrayList<ObjectNode>();
            params.add(object);
            ArrayNode array = (ArrayNode)mapper.valueToTree(params);
            data.put("method", "submit");
            data.set("params", (JsonNode)array);
            do {
                --times;
                try {
                    String url = this.rpcNode.randomUrl();
                    res = OkhttpUtil.post(url, data.toString());
                    String status = JSONObject.parseObject((String)res).getJSONObject("result").getString("engine_result");
                    if ("tesSUCCESS".equals(status)) {
                        break;
                    }
                }
                catch (Exception e) {
                    continue;
                }
                Thread.sleep(1000L);
            } while (times > 0);
            return res;
        }
        catch (Exception e) {
            throw new Exception("\u6302\u5355\u5931\u8d25");
        }
    }
}

