/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.graph.disk;

import io.github.jbellis.jvector.disk.IndexWriter;
import io.github.jbellis.jvector.graph.GraphIndex;
import io.github.jbellis.jvector.graph.NodesIterator;
import io.github.jbellis.jvector.graph.OnHeapGraphIndex;
import io.github.jbellis.jvector.graph.disk.AbstractGraphIndexWriter;
import io.github.jbellis.jvector.graph.disk.OrdinalMapper;
import io.github.jbellis.jvector.graph.disk.feature.Feature;
import io.github.jbellis.jvector.graph.disk.feature.FeatureId;
import java.io.IOException;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.IntFunction;

public class OnDiskSequentialGraphIndexWriter
extends AbstractGraphIndexWriter<IndexWriter> {
    public static final int FOOTER_MAGIC = 1247167044;
    public static final int FOOTER_OFFSET_SIZE = 8;
    public static final int FOOTER_MAGIC_SIZE = 4;
    public static final int FOOTER_SIZE = 12;

    OnDiskSequentialGraphIndexWriter(IndexWriter out, int version, GraphIndex graph, OrdinalMapper oldToNewOrdinals, int dimension, EnumMap<FeatureId, Feature> features) {
        super(out, version, graph, oldToNewOrdinals, dimension, features);
    }

    @Override
    public synchronized void close() throws IOException {
        this.view.close();
    }

    @Override
    public synchronized void write(Map<FeatureId, IntFunction<Feature.State>> featureStateSuppliers) throws IOException {
        Object ohgi;
        long startOffset = this.out.position();
        this.writeHeader(startOffset);
        if (this.graph instanceof OnHeapGraphIndex && ((OnHeapGraphIndex)(ohgi = (OnHeapGraphIndex)this.graph)).getDeletedNodes().cardinality() > 0) {
            throw new IllegalArgumentException("Run builder.cleanup() before writing the graph");
        }
        for (FeatureId featureId : featureStateSuppliers.keySet()) {
            if (this.featureMap.containsKey((Object)featureId)) continue;
            throw new IllegalArgumentException(String.format("Feature %s not configured for index", new Object[]{featureId}));
        }
        if (this.ordinalMapper.maxOrdinal() < this.graph.size(0) - 1) {
            String msg = String.format("Ordinal mapper from [0..%d] does not cover all nodes in the graph of size %d", this.ordinalMapper.maxOrdinal(), this.graph.size(0));
            throw new IllegalStateException(msg);
        }
        for (int newOrdinal = 0; newOrdinal <= this.ordinalMapper.maxOrdinal(); ++newOrdinal) {
            int n;
            int originalOrdinal = this.ordinalMapper.newToOld(newOrdinal);
            if (originalOrdinal == Integer.MIN_VALUE) {
                throw new IllegalStateException("Ordinal mapper mapped new ordinal" + newOrdinal + " to non-existing node. This behavior is not supported on OnDiskSequentialGraphIndexWriter. Use OnDiskGraphIndexWriter instead.");
            }
            if (!this.graph.containsNode(originalOrdinal)) {
                String msg = String.format("Ordinal mapper mapped new ordinal %s to non-existing node %s", newOrdinal, originalOrdinal);
                throw new IllegalStateException(msg);
            }
            this.out.writeInt(newOrdinal);
            assert (this.out.position() == this.featureOffsetForOrdinal(startOffset, newOrdinal)) : String.format("%d != %d", this.out.position(), this.featureOffsetForOrdinal(startOffset, newOrdinal));
            for (Feature feature : this.inlineFeatures) {
                IntFunction<Feature.State> supplier = featureStateSuppliers.get((Object)feature.id());
                if (supplier == null) {
                    throw new IllegalStateException("Supplier for feature " + String.valueOf((Object)feature.id()) + " not found");
                }
                feature.writeInline(this.out, supplier.apply(originalOrdinal));
            }
            NodesIterator neighbors = this.view.getNeighborsIterator(0, originalOrdinal);
            if (neighbors.size() > this.graph.getDegree(0)) {
                String msg = String.format("Node %d has more neighbors %d than the graph's max degree %d -- run Builder.cleanup()!", originalOrdinal, neighbors.size(), this.graph.getDegree(0));
                throw new IllegalStateException(msg);
            }
            this.out.writeInt(neighbors.size());
            for (n = 0; n < neighbors.size(); ++n) {
                int newNeighborOrdinal = this.ordinalMapper.oldToNew(neighbors.nextInt());
                if (newNeighborOrdinal < 0 || newNeighborOrdinal > this.ordinalMapper.maxOrdinal()) {
                    String msg = String.format("Neighbor ordinal out of bounds: %d/%d", newNeighborOrdinal, this.ordinalMapper.maxOrdinal());
                    throw new IllegalStateException(msg);
                }
                this.out.writeInt(newNeighborOrdinal);
            }
            assert (!neighbors.hasNext());
            while (n < this.graph.getDegree(0)) {
                this.out.writeInt(-1);
                ++n;
            }
        }
        this.writeSparseLevels();
        this.writeSeparatedFeatures(featureStateSuppliers);
        this.writeFooter(this.out.position());
    }

    public static class Builder
    extends AbstractGraphIndexWriter.Builder<OnDiskSequentialGraphIndexWriter, IndexWriter> {
        public Builder(GraphIndex graphIndex, IndexWriter out) {
            super(graphIndex, out);
        }

        @Override
        protected OnDiskSequentialGraphIndexWriter reallyBuild(int dimension) {
            return new OnDiskSequentialGraphIndexWriter(this.out, this.version, this.graphIndex, this.ordinalMapper, dimension, (EnumMap<FeatureId, Feature>)this.features);
        }
    }
}

