/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.vector;

import io.github.jbellis.jvector.vector.VectorSimilarityFunction;
import io.github.jbellis.jvector.vector.types.ByteSequence;
import io.github.jbellis.jvector.vector.types.VectorFloat;
import java.util.List;

public interface VectorUtilSupport {
    public float dotProduct(VectorFloat<?> var1, VectorFloat<?> var2);

    public float dotProduct(VectorFloat<?> var1, int var2, VectorFloat<?> var3, int var4, int var5);

    public float cosine(VectorFloat<?> var1, VectorFloat<?> var2);

    public float cosine(VectorFloat<?> var1, int var2, VectorFloat<?> var3, int var4, int var5);

    public float squareDistance(VectorFloat<?> var1, VectorFloat<?> var2);

    public float squareDistance(VectorFloat<?> var1, int var2, VectorFloat<?> var3, int var4, int var5);

    public VectorFloat<?> sum(List<VectorFloat<?>> var1);

    public float sum(VectorFloat<?> var1);

    public void scale(VectorFloat<?> var1, float var2);

    public void addInPlace(VectorFloat<?> var1, VectorFloat<?> var2);

    public void subInPlace(VectorFloat<?> var1, VectorFloat<?> var2);

    public VectorFloat<?> sub(VectorFloat<?> var1, VectorFloat<?> var2);

    public VectorFloat<?> sub(VectorFloat<?> var1, int var2, VectorFloat<?> var3, int var4, int var5);

    public float assembleAndSum(VectorFloat<?> var1, int var2, ByteSequence<?> var3);

    public int hammingDistance(long[] var1, long[] var2);

    default public void bulkShuffleQuantizedSimilarity(ByteSequence<?> shuffles, int codebookCount, ByteSequence<?> quantizedPartials, float delta, float minDistance, VectorSimilarityFunction vsf, VectorFloat<?> results) {
        int i;
        for (i = 0; i < codebookCount; ++i) {
            for (int j = 0; j < results.length(); ++j) {
                int shuffle = Byte.toUnsignedInt(shuffles.get(i * results.length() + j)) * 2;
                byte lowByte = quantizedPartials.get(i * 512 + shuffle);
                byte highByte = quantizedPartials.get(i * 512 + shuffle + 1);
                int val = Byte.toUnsignedInt(highByte) << 8 | Byte.toUnsignedInt(lowByte);
                results.set(j, results.get(j) + (float)val);
            }
        }
        block6: for (i = 0; i < results.length(); ++i) {
            switch (vsf) {
                case EUCLIDEAN: {
                    results.set(i, 1.0f / (1.0f + delta * results.get(i) + minDistance));
                    continue block6;
                }
                case DOT_PRODUCT: {
                    results.set(i, (1.0f + delta * results.get(i) + minDistance) / 2.0f);
                    continue block6;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported similarity function " + String.valueOf((Object)vsf));
                }
            }
        }
    }

    default public void bulkShuffleQuantizedSimilarityCosine(ByteSequence<?> shuffles, int codebookCount, ByteSequence<?> quantizedPartialSums, float sumDelta, float minDistance, ByteSequence<?> quantizedPartialSquaredMagnitudes, float magnitudeDelta, float minMagnitude, float queryMagnitudeSquared, VectorFloat<?> results) {
        int i;
        float[] sums = new float[results.length()];
        float[] magnitudes = new float[results.length()];
        for (i = 0; i < codebookCount; ++i) {
            int j = 0;
            while (j < results.length()) {
                int shuffle = Byte.toUnsignedInt(shuffles.get(i * results.length() + j)) * 2;
                byte lowByte = quantizedPartialSums.get(i * 512 + shuffle);
                byte highByte = quantizedPartialSums.get(i * 512 + shuffle + 1);
                int val = Byte.toUnsignedInt(highByte) << 8 | Byte.toUnsignedInt(lowByte);
                int n = j;
                sums[n] = sums[n] + (float)val;
                lowByte = quantizedPartialSquaredMagnitudes.get(i * 512 + shuffle);
                highByte = quantizedPartialSquaredMagnitudes.get(i * 512 + shuffle + 1);
                val = Byte.toUnsignedInt(highByte) << 8 | Byte.toUnsignedInt(lowByte);
                int n2 = j++;
                magnitudes[n2] = magnitudes[n2] + (float)val;
            }
        }
        for (i = 0; i < results.length(); ++i) {
            float unquantizedSum = sumDelta * sums[i] + minDistance;
            float unquantizedMagnitude = magnitudeDelta * magnitudes[i] + minMagnitude;
            double divisor = Math.sqrt(unquantizedMagnitude * queryMagnitudeSquared);
            results.set(i, (1.0f + (float)((double)unquantizedSum / divisor)) / 2.0f);
        }
    }

    public void calculatePartialSums(VectorFloat<?> var1, int var2, int var3, int var4, VectorFloat<?> var5, int var6, VectorSimilarityFunction var7, VectorFloat<?> var8);

    public void calculatePartialSums(VectorFloat<?> var1, int var2, int var3, int var4, VectorFloat<?> var5, int var6, VectorSimilarityFunction var7, VectorFloat<?> var8, VectorFloat<?> var9);

    public void quantizePartials(float var1, VectorFloat<?> var2, VectorFloat<?> var3, ByteSequence<?> var4);

    public float max(VectorFloat<?> var1);

    public float min(VectorFloat<?> var1);

    default public float pqDecodedCosineSimilarity(ByteSequence<?> encoded, int clusterCount, VectorFloat<?> partialSums, VectorFloat<?> aMagnitude, float bMagnitude) {
        float sum = 0.0f;
        float aMag = 0.0f;
        for (int m = 0; m < encoded.length(); ++m) {
            int centroidIndex = Byte.toUnsignedInt(encoded.get(m));
            int index = m * clusterCount + centroidIndex;
            sum += partialSums.get(index);
            aMag += aMagnitude.get(index);
        }
        return (float)((double)sum / Math.sqrt(aMag * bMagnitude));
    }
}

