/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.pq;

import io.github.jbellis.jvector.pq.MutableCompressedVectors;
import io.github.jbellis.jvector.pq.PQVectors;
import io.github.jbellis.jvector.pq.ProductQuantization;
import io.github.jbellis.jvector.vector.VectorizationProvider;
import io.github.jbellis.jvector.vector.types.ByteSequence;
import io.github.jbellis.jvector.vector.types.VectorFloat;
import io.github.jbellis.jvector.vector.types.VectorTypeSupport;

public class MutablePQVectors
extends PQVectors
implements MutableCompressedVectors<VectorFloat<?>> {
    private static final VectorTypeSupport vectorTypeSupport = VectorizationProvider.getInstance().getVectorTypeSupport();

    public MutablePQVectors(ProductQuantization pq, int maximumVectorCount) {
        super(pq);
        this.vectorCount = 0;
        int compressedDimension = pq.compressedVectorSize();
        long totalSize = (long)maximumVectorCount * (long)compressedDimension;
        this.vectorsPerChunk = totalSize <= 0x7FFFFFEFL ? maximumVectorCount : 0x7FFFFFEF / compressedDimension;
        int fullSizeChunks = maximumVectorCount / this.vectorsPerChunk;
        int totalChunks = maximumVectorCount % this.vectorsPerChunk == 0 ? fullSizeChunks : fullSizeChunks + 1;
        ByteSequence[] chunks = new ByteSequence[totalChunks];
        int chunkBytes = this.vectorsPerChunk * compressedDimension;
        for (int i = 0; i < fullSizeChunks; ++i) {
            chunks[i] = vectorTypeSupport.createByteSequence(chunkBytes);
        }
        if (totalChunks > fullSizeChunks) {
            int remainingVectors = maximumVectorCount % this.vectorsPerChunk;
            chunks[fullSizeChunks] = vectorTypeSupport.createByteSequence(remainingVectors * compressedDimension);
        }
        this.compressedDataChunks = chunks;
    }

    @Override
    public void encodeAndSet(int ordinal, VectorFloat<?> vector) {
        this.vectorCount = Math.max(this.vectorCount, ordinal + 1);
        this.pq.encodeTo(vector, this.get(ordinal));
    }

    @Override
    public void setZero(int ordinal) {
        this.vectorCount = Math.max(this.vectorCount, ordinal + 1);
        this.get(ordinal).zero();
    }
}

