/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.graph;

import io.github.jbellis.jvector.graph.NodesUnsorted;
import io.github.jbellis.jvector.graph.similarity.ScoreFunction;
import io.github.jbellis.jvector.util.AbstractLongHeap;
import io.github.jbellis.jvector.util.BoundedLongHeap;
import io.github.jbellis.jvector.util.NumericUtils;
import org.agrona.collections.Int2ObjectHashMap;

public class NodeQueue {
    private final AbstractLongHeap heap;
    private final Order order;

    public NodeQueue(AbstractLongHeap heap, Order order) {
        this.heap = heap;
        this.order = order;
    }

    public int size() {
        return this.heap.size();
    }

    public boolean push(int newNode, float newScore) {
        return this.heap.push(this.encode(newNode, newScore));
    }

    private long encode(int node, float score) {
        return this.order.apply((long)NumericUtils.floatToSortableInt(score) << 32 | 0xFFFFFFFFL & (long)(~node));
    }

    private float decodeScore(long heapValue) {
        return NumericUtils.sortableIntToFloat((int)(this.order.apply(heapValue) >> 32));
    }

    private int decodeNodeId(long heapValue) {
        return (int)(this.order.apply(heapValue) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public int pop() {
        return this.decodeNodeId(this.heap.pop());
    }

    public int[] nodesCopy() {
        int size = this.size();
        int[] nodes = new int[size];
        for (int i = 0; i < size; ++i) {
            nodes[i] = this.decodeNodeId(this.heap.get(i + 1));
        }
        return nodes;
    }

    public float rerank(int topK, ScoreFunction.Reranker reranker, float rerankFloor, NodeQueue reranked, NodesUnsorted unused) {
        int i;
        int[] ids = new int[this.size()];
        float[] exactScores = new float[this.size()];
        Int2ObjectHashMap approximateScoresById = new Int2ObjectHashMap();
        for (i = 0; i < this.size(); ++i) {
            long heapValue = this.heap.get(i + 1);
            float score = this.decodeScore(heapValue);
            int nodeId = this.decodeNodeId(heapValue);
            if (score >= rerankFloor) {
                ids[i] = nodeId;
                exactScores[i] = reranker.similarityTo(ids[i]);
                approximateScoresById.put(ids[i], (Object)Float.valueOf(score));
                continue;
            }
            unused.add(nodeId, score);
            ids[i] = -1;
        }
        for (i = 0; i < ids.length; ++i) {
            if (ids[i] == -1) continue;
            if (reranked.size() < topK) {
                reranked.push(ids[i], exactScores[i]);
                continue;
            }
            if (exactScores[i] > reranked.topScore()) {
                int evictedNode = reranked.topNode();
                unused.add(evictedNode, ((Float)approximateScoresById.get(evictedNode)).floatValue());
                reranked.push(ids[i], exactScores[i]);
                continue;
            }
            unused.add(ids[i], this.decodeScore(this.heap.get(i + 1)));
        }
        float worstApproximateInTopK = Float.POSITIVE_INFINITY;
        if (reranked.size() < topK) {
            return worstApproximateInTopK;
        }
        for (int i2 = 0; i2 < reranked.size(); ++i2) {
            int nodeId = this.decodeNodeId(reranked.heap.get(i2 + 1));
            worstApproximateInTopK = Math.min(worstApproximateInTopK, ((Float)approximateScoresById.get(nodeId)).floatValue());
        }
        return worstApproximateInTopK;
    }

    public int topNode() {
        return this.decodeNodeId(this.heap.top());
    }

    public float topScore() {
        return this.decodeScore(this.heap.top());
    }

    public void clear() {
        this.heap.clear();
    }

    public void setMaxSize(int maxSize) {
        ((BoundedLongHeap)this.heap).setMaxSize(maxSize);
    }

    public String toString() {
        return "Nodes[" + this.heap.size() + "]";
    }

    public void foreach(NodeConsumer consumer) {
        for (int i = 0; i < this.heap.size(); ++i) {
            long heapValue = this.heap.get(i + 1);
            consumer.accept(this.decodeNodeId(heapValue), this.decodeScore(heapValue));
        }
    }

    public static enum Order {
        MIN_HEAP{

            @Override
            long apply(long v) {
                return v;
            }
        }
        ,
        MAX_HEAP{

            @Override
            long apply(long v) {
                return -1L - v;
            }
        };


        abstract long apply(long var1);
    }

    @FunctionalInterface
    public static interface NodeConsumer {
        public void accept(int var1, float var2);
    }
}

