/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.graph.disk;

import io.github.jbellis.jvector.disk.BufferedRandomAccessWriter;
import io.github.jbellis.jvector.disk.ByteBufferReader;
import io.github.jbellis.jvector.disk.RandomAccessReader;
import io.github.jbellis.jvector.graph.GraphIndex;
import io.github.jbellis.jvector.graph.NodesIterator;
import io.github.jbellis.jvector.graph.OnHeapGraphIndex;
import io.github.jbellis.jvector.graph.disk.CommonHeader;
import io.github.jbellis.jvector.graph.disk.Feature;
import io.github.jbellis.jvector.graph.disk.FeatureId;
import io.github.jbellis.jvector.graph.disk.FeatureSource;
import io.github.jbellis.jvector.graph.disk.Header;
import io.github.jbellis.jvector.graph.disk.InlineVectors;
import io.github.jbellis.jvector.graph.disk.LVQ;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.IntFunction;
import org.agrona.collections.Int2IntHashMap;

public class OnDiskGraphIndexWriter
implements Closeable {
    private final Path outPath;
    private final int version;
    private final GraphIndex graph;
    private final GraphIndex.View view;
    private final OrdinalMapper ordinalMapper;
    private final int dimension;
    private final EnumMap<FeatureId, Feature> featureMap;
    private final BufferedRandomAccessWriter out;
    private final long startOffset;
    private volatile int maxOrdinalWritten;

    private OnDiskGraphIndexWriter(Path outPath, int version, long startOffset, GraphIndex graph, OrdinalMapper oldToNewOrdinals, int dimension, EnumMap<FeatureId, Feature> features) throws IOException {
        this.outPath = outPath;
        this.version = version;
        this.graph = graph;
        this.view = graph.getView();
        this.ordinalMapper = oldToNewOrdinals;
        this.dimension = dimension;
        this.featureMap = features;
        this.out = new BufferedRandomAccessWriter(outPath);
        this.startOffset = startOffset;
    }

    @Override
    public synchronized void close() throws IOException {
        this.view.close();
        this.out.close();
    }

    public BufferedRandomAccessWriter getOutput() {
        return this.out;
    }

    public synchronized void writeInline(int ordinal, Map<FeatureId, Feature.State> stateMap) throws IOException {
        Collection<Feature> features = this.featureMap.values();
        this.out.seek(this.getOffsetForOrdinal(ordinal, features));
        for (Feature feature : features) {
            Feature.State state = stateMap.get((Object)feature.id());
            if (state == null) {
                this.out.seek(this.out.position() + (long)feature.inlineSize());
                continue;
            }
            feature.writeInline(this.out, state);
        }
        this.maxOrdinalWritten = Math.max(this.maxOrdinalWritten, ordinal);
    }

    public int getMaxOrdinal() {
        return this.maxOrdinalWritten;
    }

    private long getOffsetForOrdinal(int ordinal, Collection<Feature> features) {
        int headerBytes = 8 + CommonHeader.size() + features.stream().mapToInt(Feature::headerSize).sum();
        int edgeSize = 4 * (1 + this.graph.maxDegree());
        int inlineBytes = ordinal * (4 + features.stream().mapToInt(Feature::inlineSize).sum() + edgeSize);
        return this.startOffset + (long)headerBytes + (long)inlineBytes + 4L;
    }

    public FeatureSource getFeatureSource() {
        RandomAccessFile in;
        try {
            in = new RandomAccessFile(this.outPath.toFile(), "r");
        }
        catch (FileNotFoundException e) {
            throw new AssertionError((Object)e);
        }
        return new FeatureSource(){
            private byte[] scratch;
            final /* synthetic */ OnDiskGraphIndexWriter this$0;
            {
                this.this$0 = this$0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public RandomAccessReader inlineReaderForNode(int ordinal, FeatureId featureId) throws IOException {
                if (ordinal > this.this$0.maxOrdinalWritten) {
                    throw new IllegalArgumentException("Ordinal " + ordinal + " has not been written yet");
                }
                Feature toRead = this.this$0.featureMap.get((Object)featureId);
                if (toRead == null) {
                    throw new IllegalStateException("Feature not present: " + String.valueOf((Object)featureId));
                }
                OnDiskGraphIndexWriter onDiskGraphIndexWriter = this.this$0;
                synchronized (onDiskGraphIndexWriter) {
                    this.this$0.out.flush();
                }
                if (this.scratch == null || this.scratch.length < toRead.inlineSize()) {
                    this.scratch = new byte[toRead.inlineSize()];
                }
                Collection<Feature> features = this.this$0.featureMap.values();
                in.seek(this.this$0.getOffsetForOrdinal(ordinal, features));
                for (Feature feature : features) {
                    int featureSize = feature.inlineSize();
                    if (feature.id() != featureId) {
                        in.seek(in.getFilePointer() + (long)featureSize);
                        continue;
                    }
                    in.readFully(this.scratch, 0, featureSize);
                    return new ByteBufferReader(ByteBuffer.wrap(this.scratch, 0, featureSize));
                }
                throw new AssertionError();
            }

            @Override
            public void close() throws IOException {
                in.close();
            }
        };
    }

    public synchronized void write(Map<FeatureId, IntFunction<Feature.State>> featureStateSuppliers) throws IOException {
        Object ohgi;
        if (this.graph instanceof OnHeapGraphIndex && ((OnHeapGraphIndex)(ohgi = (OnHeapGraphIndex)this.graph)).getDeletedNodes().cardinality() > 0) {
            throw new IllegalArgumentException("Run builder.cleanup() before writing the graph");
        }
        for (Map.Entry entry : featureStateSuppliers.entrySet()) {
            if (this.featureMap.containsKey(entry.getKey())) continue;
            throw new IllegalArgumentException("Feature supplier provided for feature not in the graph");
        }
        this.out.seek(this.startOffset);
        int graphSize = this.graph.size();
        CommonHeader commonHeader = new CommonHeader(this.version, graphSize, this.dimension, this.view.entryNode(), this.graph.maxDegree());
        Header header = new Header(commonHeader, this.featureMap);
        header.write(this.out);
        for (int newOrdinal = 0; newOrdinal < graphSize; ++newOrdinal) {
            int n;
            int originalOrdinal = this.ordinalMapper.newToOld(newOrdinal);
            if (!this.graph.containsNode(originalOrdinal)) {
                String msg = String.format("Ordinal mapper mapped new ordinal %s to non-existing node %s", newOrdinal, originalOrdinal);
                throw new IllegalStateException(msg);
            }
            this.out.writeInt(newOrdinal);
            for (Feature feature : this.featureMap.values()) {
                IntFunction<Feature.State> supplier = featureStateSuppliers.get((Object)feature.id());
                if (supplier == null) {
                    this.out.seek(this.out.position() + (long)feature.inlineSize());
                    continue;
                }
                feature.writeInline(this.out, supplier.apply(originalOrdinal));
            }
            NodesIterator neighbors = this.view.getNeighborsIterator(originalOrdinal);
            if (neighbors.size() > this.graph.maxDegree()) {
                String msg = String.format("Node %d has more neighbors %d than the graph's max degree %d -- run Builder.cleanup()!", originalOrdinal, neighbors.size(), this.graph.maxDegree());
                throw new IllegalStateException(msg);
            }
            this.out.writeInt(neighbors.size());
            for (n = 0; n < neighbors.size(); ++n) {
                int newNeighborOrdinal = this.ordinalMapper.oldToNew(neighbors.nextInt());
                if (newNeighborOrdinal < 0 || newNeighborOrdinal >= graphSize) {
                    String msg = String.format("Neighbor ordinal out of bounds: %d/%d", newNeighborOrdinal, graphSize);
                    throw new IllegalStateException(msg);
                }
                this.out.writeInt(newNeighborOrdinal);
            }
            assert (!neighbors.hasNext());
            while (n < this.graph.maxDegree()) {
                this.out.writeInt(-1);
                ++n;
            }
        }
    }

    public static Map<Integer, Integer> sequentialRenumbering(GraphIndex graph) {
        Int2IntHashMap int2IntHashMap;
        block9: {
            GraphIndex.View view = graph.getView();
            try {
                Int2IntHashMap oldToNewMap = new Int2IntHashMap(-1);
                int nextOrdinal = 0;
                for (int i = 0; i < view.getIdUpperBound(); ++i) {
                    if (!graph.containsNode(i)) continue;
                    oldToNewMap.put(i, nextOrdinal++);
                }
                int2IntHashMap = oldToNewMap;
                if (view == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (view != null) {
                        try {
                            view.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            view.close();
        }
        return int2IntHashMap;
    }

    public synchronized long checksum() throws IOException {
        long endOffset = this.out.position();
        return this.out.checksum(this.startOffset, endOffset);
    }

    public static interface OrdinalMapper {
        public int oldToNew(int var1);

        public int newToOld(int var1);
    }

    private static class MapMapper
    implements OrdinalMapper {
        private final Map<Integer, Integer> oldToNew;
        private final int[] newToOld;

        public MapMapper(Map<Integer, Integer> oldToNew) {
            this.oldToNew = oldToNew;
            this.newToOld = new int[oldToNew.size()];
            oldToNew.forEach((old, newOrdinal) -> {
                this.newToOld[newOrdinal.intValue()] = old;
            });
        }

        @Override
        public int oldToNew(int oldOrdinal) {
            return this.oldToNew.get(oldOrdinal);
        }

        @Override
        public int newToOld(int newOrdinal) {
            return this.newToOld[newOrdinal];
        }
    }

    public static class IdentityMapper
    implements OrdinalMapper {
        @Override
        public int oldToNew(int oldOrdinal) {
            return oldOrdinal;
        }

        @Override
        public int newToOld(int newOrdinal) {
            return newOrdinal;
        }
    }

    public static class Builder {
        private final GraphIndex graphIndex;
        private final Path outPath;
        private final EnumMap<FeatureId, Feature> features;
        private OrdinalMapper ordinalMapper;
        private long startOffset;
        private int version;

        public Builder(GraphIndex graphIndex, Path outPath) {
            this.graphIndex = graphIndex;
            this.outPath = outPath;
            this.features = new EnumMap(FeatureId.class);
            this.version = 3;
        }

        public Builder withVersion(int version) {
            if (version > 3) {
                throw new IllegalArgumentException("Unsupported version: " + version);
            }
            this.version = version;
            return this;
        }

        public Builder with(Feature feature) {
            this.features.put(feature.id(), feature);
            return this;
        }

        public Builder withMapper(OrdinalMapper ordinalMapper) {
            this.ordinalMapper = ordinalMapper;
            return this;
        }

        public Builder withStartOffset(long startOffset) {
            this.startOffset = startOffset;
            return this;
        }

        public OnDiskGraphIndexWriter build() throws IOException {
            int dimension;
            if (!(this.version >= 3 || this.features.containsKey((Object)FeatureId.INLINE_VECTORS) && this.features.size() <= 1)) {
                throw new IllegalArgumentException("Only INLINE_VECTORS is supported until version 3");
            }
            if (this.features.containsKey((Object)FeatureId.INLINE_VECTORS)) {
                dimension = ((InlineVectors)this.features.get((Object)FeatureId.INLINE_VECTORS)).dimension();
            } else if (this.features.containsKey((Object)FeatureId.LVQ)) {
                dimension = ((LVQ)this.features.get((Object)FeatureId.LVQ)).dimension();
            } else {
                throw new IllegalArgumentException("Either LVQ or inline vectors must be provided.");
            }
            if (this.ordinalMapper == null) {
                this.ordinalMapper = new MapMapper(OnDiskGraphIndexWriter.sequentialRenumbering(this.graphIndex));
            }
            return new OnDiskGraphIndexWriter(this.outPath, this.version, this.startOffset, this.graphIndex, this.ordinalMapper, dimension, this.features);
        }

        public Builder withMap(Map<Integer, Integer> oldToNewOrdinals) {
            return this.withMapper(new MapMapper(oldToNewOrdinals));
        }

        public Feature getFeature(FeatureId featureId) {
            return this.features.get((Object)featureId);
        }
    }
}

