/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.graph.disk;

import io.github.jbellis.jvector.disk.RandomAccessReader;
import io.github.jbellis.jvector.graph.disk.CommonHeader;
import io.github.jbellis.jvector.graph.disk.Feature;
import io.github.jbellis.jvector.graph.disk.FeatureId;
import io.github.jbellis.jvector.graph.disk.FeatureSource;
import io.github.jbellis.jvector.graph.disk.LVQPackedVectors;
import io.github.jbellis.jvector.graph.disk.OnDiskGraphIndex;
import io.github.jbellis.jvector.graph.similarity.ScoreFunction;
import io.github.jbellis.jvector.pq.LocallyAdaptiveVectorQuantization;
import io.github.jbellis.jvector.util.ExplicitThreadLocal;
import io.github.jbellis.jvector.vector.VectorSimilarityFunction;
import io.github.jbellis.jvector.vector.VectorizationProvider;
import io.github.jbellis.jvector.vector.types.ByteSequence;
import io.github.jbellis.jvector.vector.types.VectorFloat;
import io.github.jbellis.jvector.vector.types.VectorTypeSupport;
import java.io.DataOutput;
import java.io.IOException;
import java.io.UncheckedIOException;

public class LVQ
implements Feature {
    private static final VectorTypeSupport vectorTypeSupport = VectorizationProvider.getInstance().getVectorTypeSupport();
    private final LocallyAdaptiveVectorQuantization lvq;
    private final ExplicitThreadLocal<ByteSequence<?>> reusableBytes;

    public LVQ(LocallyAdaptiveVectorQuantization lvq) {
        this.lvq = lvq;
        this.reusableBytes = ExplicitThreadLocal.withInitial(() -> vectorTypeSupport.createByteSequence(lvq.compressedVectorSize() - 8));
    }

    @Override
    public FeatureId id() {
        return FeatureId.LVQ;
    }

    @Override
    public int headerSize() {
        return this.lvq.compressorSize();
    }

    @Override
    public int inlineSize() {
        return this.lvq.compressedVectorSize();
    }

    public int dimension() {
        return this.lvq.globalMean.length();
    }

    static LVQ load(CommonHeader header, RandomAccessReader reader) {
        try {
            return new LVQ(LocallyAdaptiveVectorQuantization.load(reader));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void writeHeader(DataOutput out) throws IOException {
        this.lvq.write(out);
    }

    @Override
    public void writeInline(DataOutput out, Feature.State state_) throws IOException {
        State state = (State)state_;
        state.vector.writePacked(out);
    }

    ScoreFunction.Reranker rerankerFor(VectorFloat<?> queryVector, VectorSimilarityFunction vsf, FeatureSource source) {
        return this.lvq.scoreFunctionFrom(queryVector, vsf, this.createPackedVectors(source));
    }

    public PackedVectors createPackedVectors(FeatureSource source) {
        return new PackedVectors(source);
    }

    public static class State
    implements Feature.State {
        public final LocallyAdaptiveVectorQuantization.QuantizedVector vector;

        public State(LocallyAdaptiveVectorQuantization.QuantizedVector vector) {
            this.vector = vector;
        }
    }

    public class PackedVectors
    implements LVQPackedVectors {
        final FeatureSource source;

        public PackedVectors(FeatureSource source) {
            this.source = source;
        }

        @Override
        public LocallyAdaptiveVectorQuantization.PackedVector getPackedVector(int ordinal) {
            try {
                RandomAccessReader reader = this.source.inlineReaderForNode(ordinal, FeatureId.LVQ);
                float bias = reader.readFloat();
                float scale = reader.readFloat();
                ByteSequence<?> tlBytes = LVQ.this.reusableBytes.get();
                OnDiskGraphIndex.vectorTypeSupport.readByteSequence(reader, tlBytes);
                return new LocallyAdaptiveVectorQuantization.PackedVector(tlBytes, bias, scale);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

