/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.graph;

import io.github.jbellis.jvector.annotations.Experimental;
import io.github.jbellis.jvector.graph.GraphIndex;
import io.github.jbellis.jvector.graph.NodeQueue;
import io.github.jbellis.jvector.graph.NodesIterator;
import io.github.jbellis.jvector.graph.RandomAccessVectorValues;
import io.github.jbellis.jvector.graph.ScoreTracker;
import io.github.jbellis.jvector.graph.SearchResult;
import io.github.jbellis.jvector.graph.similarity.ScoreFunction;
import io.github.jbellis.jvector.graph.similarity.SearchScoreProvider;
import io.github.jbellis.jvector.util.Bits;
import io.github.jbellis.jvector.util.BoundedLongHeap;
import io.github.jbellis.jvector.util.GrowableLongHeap;
import io.github.jbellis.jvector.util.SparseBits;
import io.github.jbellis.jvector.vector.VectorSimilarityFunction;
import io.github.jbellis.jvector.vector.types.VectorFloat;
import java.util.Arrays;
import java.util.Comparator;
import org.agrona.collections.IntHashSet;

public class GraphSearcher
implements AutoCloseable {
    private final GraphIndex.View view;
    private final NodeQueue candidates;
    private final NodeQueue resultsQueue;
    private final IntHashSet visited;
    private final NodeQueue evictedResults;
    private Bits acceptOrds;
    private SearchScoreProvider scoreProvider;

    public GraphSearcher(GraphIndex graph) {
        this(graph.getView());
    }

    private GraphSearcher(GraphIndex.View view) {
        this.view = view;
        this.candidates = new NodeQueue(new GrowableLongHeap(100), NodeQueue.Order.MAX_HEAP);
        this.evictedResults = new NodeQueue(new GrowableLongHeap(100), NodeQueue.Order.MAX_HEAP);
        this.resultsQueue = new NodeQueue(new BoundedLongHeap(100), NodeQueue.Order.MIN_HEAP);
        this.visited = new IntHashSet();
    }

    public GraphIndex.View getView() {
        return this.view;
    }

    public static SearchResult search(VectorFloat<?> queryVector, int topK, RandomAccessVectorValues vectors, VectorSimilarityFunction similarityFunction, GraphIndex graph, Bits acceptOrds) {
        SearchResult searchResult;
        GraphSearcher searcher = new GraphSearcher(graph);
        try {
            SearchScoreProvider ssp = SearchScoreProvider.exact(queryVector, similarityFunction, vectors);
            searchResult = searcher.search(ssp, topK, acceptOrds);
        }
        catch (Throwable throwable) {
            try {
                try {
                    searcher.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        searcher.close();
        return searchResult;
    }

    @Experimental
    public SearchResult search(SearchScoreProvider scoreProvider, int topK, float threshold, float rerankFloor, Bits acceptOrds) {
        return this.searchInternal(scoreProvider, topK, threshold, rerankFloor, this.view.entryNode(), acceptOrds);
    }

    public SearchResult search(SearchScoreProvider scoreProvider, int topK, float threshold, Bits acceptOrds) {
        return this.search(scoreProvider, topK, threshold, 0.0f, acceptOrds);
    }

    public SearchResult search(SearchScoreProvider scoreProvider, int topK, Bits acceptOrds) {
        return this.search(scoreProvider, topK, 0.0f, acceptOrds);
    }

    SearchResult searchInternal(SearchScoreProvider scoreProvider, int topK, float threshold, float rerankFloor, int ep, Bits rawAcceptOrds) {
        if (rawAcceptOrds == null) {
            throw new IllegalArgumentException("Use MatchAllBits to indicate that all ordinals are accepted, instead of null");
        }
        this.scoreProvider = scoreProvider;
        this.acceptOrds = Bits.intersectionOf(rawAcceptOrds, this.view.liveNodes());
        this.evictedResults.clear();
        this.candidates.clear();
        this.visited.clear();
        if (ep < 0) {
            return new SearchResult(new SearchResult.NodeScore[0], 0);
        }
        float score = scoreProvider.scoreFunction().similarityTo(ep);
        this.visited.add(ep);
        this.candidates.push(ep, score);
        SearchResult sr = this.resume(topK, threshold, rerankFloor);
        return new SearchResult(sr.getNodes(), sr.getVisitedCount() + 1);
    }

    @Experimental
    public SearchResult resume(int additionalK, float threshold, float rerankFloor) {
        float topCandidateScore;
        Bits previouslyEvicted;
        assert (this.resultsQueue.size() == 0);
        this.resultsQueue.setMaxSize(additionalK);
        int numVisited = 0;
        float minAcceptedSimilarity = Float.NEGATIVE_INFINITY;
        ScoreTracker scoreTracker = threshold > 0.0f ? new ScoreTracker.TwoPhaseTracker(threshold) : ScoreTracker.NO_OP;
        VectorFloat<?> similarities = null;
        Bits bits = previouslyEvicted = this.evictedResults.size() > 0 ? new SparseBits() : Bits.NONE;
        while (this.evictedResults.size() > 0) {
            float score = this.evictedResults.topScore();
            int node = this.evictedResults.pop();
            this.candidates.push(node, score);
            ((SparseBits)previouslyEvicted).set(node);
        }
        this.evictedResults.clear();
        while (this.candidates.size() > 0 && !((topCandidateScore = this.candidates.topScore()) < minAcceptedSimilarity) && !scoreTracker.shouldStop()) {
            int topCandidateNode = this.candidates.pop();
            if (this.acceptOrds.get(topCandidateNode) && topCandidateScore >= threshold) {
                boolean added;
                if (this.resultsQueue.size() < additionalK) {
                    this.resultsQueue.push(topCandidateNode, topCandidateScore);
                    added = true;
                } else if (topCandidateScore > this.resultsQueue.topScore()) {
                    int evictedNode = this.resultsQueue.topNode();
                    float evictedScore = this.resultsQueue.topScore();
                    this.evictedResults.push(evictedNode, evictedScore);
                    this.resultsQueue.push(topCandidateNode, topCandidateScore);
                    added = true;
                } else {
                    added = false;
                }
                if (added && this.resultsQueue.size() >= additionalK) {
                    minAcceptedSimilarity = this.resultsQueue.topScore();
                }
            }
            if (previouslyEvicted.get(topCandidateNode)) continue;
            ScoreFunction scoreFunction = this.scoreProvider.scoreFunction();
            if (scoreFunction.supportsEdgeLoadingSimilarity()) {
                similarities = scoreFunction.edgeLoadingSimilarityTo(topCandidateNode);
            }
            NodesIterator it = this.view.getNeighborsIterator(topCandidateNode);
            for (int i = 0; i < it.size(); ++i) {
                int friendOrd = it.nextInt();
                if (!this.visited.add(friendOrd)) continue;
                ++numVisited;
                float friendSimilarity = scoreFunction.supportsEdgeLoadingSimilarity() ? similarities.get(i) : scoreFunction.similarityTo(friendOrd);
                scoreTracker.track(friendSimilarity);
                this.candidates.push(friendOrd, friendSimilarity);
            }
        }
        assert (this.resultsQueue.size() <= additionalK);
        SearchResult.NodeScore[] nodes = GraphSearcher.extractScores(this.scoreProvider, this.resultsQueue, rerankFloor);
        return new SearchResult(nodes, numVisited);
    }

    @Experimental
    public SearchResult resume(int additionalK) {
        return this.resume(additionalK, 0.0f, 0.0f);
    }

    private static SearchResult.NodeScore[] extractScores(SearchScoreProvider scoreProvider, NodeQueue resultsQueue, float rerankFloor) {
        SearchResult.NodeScore[] nodes;
        if (scoreProvider.reranker() == null) {
            nodes = new SearchResult.NodeScore[resultsQueue.size()];
            for (int i = nodes.length - 1; i >= 0; --i) {
                float nScore = resultsQueue.topScore();
                int n = resultsQueue.pop();
                nodes[i] = new SearchResult.NodeScore(n, nScore);
            }
        } else {
            nodes = resultsQueue.nodesCopy(scoreProvider.reranker(), rerankFloor);
            Arrays.sort(nodes, 0, nodes.length, Comparator.comparingDouble(nodeScore -> nodeScore.score).reversed());
            resultsQueue.clear();
        }
        return nodes;
    }

    @Override
    public void close() throws Exception {
        this.view.close();
    }

    @Deprecated
    public static class Builder {
        private final GraphIndex.View view;

        public Builder(GraphIndex.View view) {
            this.view = view;
        }

        public Builder withConcurrentUpdates() {
            return this;
        }

        public GraphSearcher build() {
            return new GraphSearcher(this.view);
        }
    }
}

